/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.jacksonxml;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.spincast.core.json.IJsonArray;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.json.IJsonObject;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.IXmlManager;
import org.spincast.plugins.jacksonxml.IXmlMixinInfo;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastXmlManager
implements IXmlManager {
    private final Provider<Injector> guiceProvider;
    private final IJsonManager jsonManager;
    private final Set<IXmlMixinInfo> xmlMixinInfos;
    private final XmlPrettyPrinter xmlPrettyPrinter;
    private XmlMapper xmlMapper;
    private XmlMapper xmlMapperPretty;
    private JsonSerializer<IJsonObject> jsonObjectSerializer;
    private JsonDeserializer<IJsonObject> jsonObjectDeserializer;
    private JsonDeserializer<IJsonArray> jsonArrayDeserializer;
    private JsonSerializer<IJsonArray> jsonArraySerializer;

    @Inject
    public SpincastXmlManager(Provider<Injector> guiceProvider, IJsonManager jsonManager, @Nullable Set<IXmlMixinInfo> xmlMixinInfos, XmlPrettyPrinter xmlPrettyPrinter) {
        this.guiceProvider = guiceProvider;
        this.jsonManager = jsonManager;
        this.xmlMixinInfos = xmlMixinInfos;
        this.xmlPrettyPrinter = xmlPrettyPrinter;
    }

    protected Injector getGuice() {
        return this.guiceProvider.get();
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected Set<IXmlMixinInfo> getXmlMixinInfos() {
        return this.xmlMixinInfos;
    }

    protected XmlPrettyPrinter getXmlPrettyPrinter() {
        return this.xmlPrettyPrinter;
    }

    protected XmlMapper getXmlMapper() {
        if (this.xmlMapper == null) {
            XmlMapper xmlMapper = this.createXmlMapper();
            this.registerCustomModules(xmlMapper);
            this.xmlMapper = xmlMapper;
        }
        return this.xmlMapper;
    }

    protected XmlMapper createXmlMapper() {
        XmlMapper xmlMapper = new XmlMapper();
        this.configureXmlMapper(xmlMapper);
        return xmlMapper;
    }

    protected void configureXmlMapper(XmlMapper xmlMapper) {
        this.configureEmptyBeans(xmlMapper);
        this.configureMixins(xmlMapper);
    }

    protected void configureEmptyBeans(XmlMapper xmlMapper) {
        xmlMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    protected void configureMixins(XmlMapper xmlMapper) {
        for (IXmlMixinInfo xmlMixinInfo : this.getXmlMixinInfos()) {
            xmlMapper.addMixIn(xmlMixinInfo.getTargetClass(), xmlMixinInfo.getMixinClass());
        }
    }

    protected XmlMapper getXmlMapperPretty() {
        if (this.xmlMapperPretty == null) {
            XmlMapper xmlMapper = this.getXmlMapper().copy();
            xmlMapper.setDefaultPrettyPrinter(this.getXmlPrettyPrinter());
            xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
            this.registerCustomModules(xmlMapper);
            this.xmlMapperPretty = xmlMapper;
        }
        return this.xmlMapperPretty;
    }

    protected String getArrayAttributeName() {
        return "isArray";
    }

    protected JsonSerializer<IJsonObject> getJsonObjectSerializer() {
        if (this.jsonObjectSerializer == null) {
            this.jsonObjectSerializer = new JsonSerializer<IJsonObject>(){

                @Override
                public void serialize(IJsonObject jsonObject, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonObject == null) {
                        return;
                    }
                    ToXmlGenerator xmlGen = (ToXmlGenerator)gen;
                    xmlGen.writeStartObject();
                    for (Map.Entry element : jsonObject) {
                        xmlGen.writeFieldName((String)element.getKey());
                        xmlGen.writeObject(element.getValue());
                    }
                    xmlGen.writeEndObject();
                }
            };
        }
        return this.jsonObjectSerializer;
    }

    protected JsonSerializer<IJsonArray> getJsonArraySerializer() {
        if (this.jsonArraySerializer == null) {
            this.jsonArraySerializer = new JsonSerializer<IJsonArray>(){

                @Override
                public void serialize(IJsonArray jsonArray, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (jsonArray == null) {
                        return;
                    }
                    ToXmlGenerator xmlGen = (ToXmlGenerator)gen;
                    xmlGen.writeStartObject();
                    xmlGen.setNextIsAttribute(true);
                    xmlGen.writeFieldName(SpincastXmlManager.this.getArrayAttributeName());
                    xmlGen.writeString("true");
                    xmlGen.setNextIsAttribute(false);
                    for (Object element : jsonArray) {
                        xmlGen.writeFieldName("element");
                        if (element == null) {
                            xmlGen.writeNull();
                            continue;
                        }
                        if (element instanceof IJsonObject) {
                            xmlGen.writeStartObject();
                            xmlGen.writeFieldName("obj");
                            xmlGen.writeObject(element);
                            xmlGen.writeEndObject();
                            continue;
                        }
                        if (element instanceof IJsonArray) {
                            xmlGen.writeStartObject();
                            xmlGen.writeFieldName("array");
                            xmlGen.writeObject(element);
                            xmlGen.writeEndObject();
                            continue;
                        }
                        xmlGen.writeObject(element);
                    }
                    xmlGen.writeEndObject();
                }
            };
        }
        return this.jsonArraySerializer;
    }

    protected JsonDeserializer<IJsonObject> getJsonObjectDeserializer() {
        if (this.jsonObjectDeserializer == null) {
            this.jsonObjectDeserializer = new JsonDeserializer<IJsonObject>(){

                @Override
                public IJsonObject deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    FromXmlParser xmlParser = (FromXmlParser)jsonParser;
                    JsonToken token = xmlParser.nextToken();
                    IJsonObject jsonObject = SpincastXmlManager.this.deserializeJsonObject(xmlParser, context, null);
                    return jsonObject;
                }
            };
        }
        return this.jsonObjectDeserializer;
    }

    protected JsonDeserializer<IJsonArray> getJsonArrayDeserializer() {
        if (this.jsonArrayDeserializer == null) {
            this.jsonArrayDeserializer = new JsonDeserializer<IJsonArray>(){

                @Override
                public IJsonArray deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
                    FromXmlParser xmlParser = (FromXmlParser)jsonParser;
                    boolean firstElementSkipped = false;
                    JsonToken token = xmlParser.nextToken();
                    if (token == JsonToken.FIELD_NAME) {
                        String fieldName = xmlParser.getValueAsString();
                        token = xmlParser.nextToken();
                        firstElementSkipped = true;
                        if (fieldName != null && fieldName.equals(SpincastXmlManager.this.getArrayAttributeName()) && token == JsonToken.VALUE_STRING && "true".equalsIgnoreCase(xmlParser.getValueAsString())) {
                            token = xmlParser.nextToken();
                            firstElementSkipped = false;
                        }
                    }
                    return SpincastXmlManager.this.deserializeJsonArray(xmlParser, context, firstElementSkipped);
                }
            };
        }
        return this.jsonArrayDeserializer;
    }

    protected Object deserializeObjectOrArray(FromXmlParser xmlParser, DeserializationContext context) {
        try {
            JsonToken token = xmlParser.getCurrentToken();
            if (token == JsonToken.VALUE_NULL) {
                token = xmlParser.nextToken();
                return this.getJsonManager().create();
            }
            if (token != JsonToken.START_OBJECT) {
                throw new RuntimeException("Expecting a START_OBJECT token here, got : " + (Object)((Object)token));
            }
            token = xmlParser.nextToken();
            if (token != JsonToken.FIELD_NAME) {
                throw new RuntimeException("Expecting a FIELD_NAME token here, got : " + (Object)((Object)token));
            }
            String fieldName = xmlParser.getValueAsString();
            token = xmlParser.nextToken();
            if (token == JsonToken.END_OBJECT || token == JsonToken.VALUE_NULL) {
                return this.getJsonManager().create();
            }
            if (fieldName != null && fieldName.equals(this.getArrayAttributeName()) && token == JsonToken.VALUE_STRING && "true".equalsIgnoreCase(xmlParser.getValueAsString())) {
                token = xmlParser.nextToken();
                return this.deserializeJsonArray(xmlParser, context);
            }
            Object firstValue = null;
            firstValue = token == JsonToken.START_OBJECT ? this.deserializeObjectOrArray(xmlParser, context) : xmlParser.readValueAs(Object.class);
            token = xmlParser.nextToken();
            return this.deserializeJsonObject(xmlParser, context, new AbstractMap.SimpleEntry<String, Object>(fieldName, firstValue));
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected IJsonArray deserializeJsonArray(FromXmlParser xmlParser, DeserializationContext context) {
        return this.deserializeJsonArray(xmlParser, context, false);
    }

    protected IJsonArray deserializeJsonArray(FromXmlParser xmlParser, DeserializationContext context, boolean firstElementSkipped) {
        try {
            IJsonArray jsonArray = this.getJsonManager().createArray();
            JsonToken token = xmlParser.getCurrentToken();
            while (token == JsonToken.FIELD_NAME || firstElementSkipped) {
                if (!firstElementSkipped) {
                    String tokenName = xmlParser.getValueAsString();
                    token = xmlParser.nextToken();
                } else {
                    firstElementSkipped = false;
                }
                if (token == JsonToken.START_OBJECT) {
                    token = xmlParser.nextToken();
                    if (token != JsonToken.FIELD_NAME) {
                        throw new RuntimeException("Expecting a FIELD_NAME token here, got : " + (Object)((Object)token));
                    }
                    String fieldName = xmlParser.getValueAsString();
                    token = xmlParser.nextToken();
                    if (token == JsonToken.VALUE_NULL) {
                        jsonArray.add(this.getJsonManager().create());
                    } else if (token == JsonToken.START_OBJECT) {
                        jsonArray.addConvert(this.deserializeObjectOrArray(xmlParser, context));
                    } else {
                        IJsonObject jsonObject = this.getJsonManager().create();
                        Object value = xmlParser.readValueAs(Object.class);
                        jsonObject.putConvert(fieldName, value);
                        jsonArray.add(jsonObject);
                    }
                    token = xmlParser.nextToken();
                    if (token != JsonToken.END_OBJECT) {
                        throw new RuntimeException("An array element can't contain more than one child! The current array already contains one : " + jsonArray.toJsonString());
                    }
                } else {
                    Object value = xmlParser.readValueAs(Object.class);
                    jsonArray.addConvert(value);
                }
                token = xmlParser.nextToken();
            }
            return jsonArray;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected IJsonObject deserializeJsonObject(FromXmlParser xmlParser, DeserializationContext context, Map.Entry<String, Object> firstProperty) {
        try {
            IJsonObject jsonObject = this.getJsonManager().create();
            if (firstProperty != null) {
                jsonObject.putConvert(firstProperty.getKey(), firstProperty.getValue());
            }
            JsonToken token = xmlParser.getCurrentToken();
            while (token == JsonToken.FIELD_NAME) {
                String fieldName = xmlParser.getValueAsString();
                if (StringUtils.isBlank(fieldName)) {
                    throw new RuntimeException("A Json object can't have a property with an empty name. For example, this is invalid : <root>someValue</root>, a name must be specified : <root><someKey>someValue</someKey></root>");
                }
                token = xmlParser.nextToken();
                if (token == JsonToken.VALUE_NULL) {
                    jsonObject.put(fieldName, this.getJsonManager().create());
                } else if (token == JsonToken.START_OBJECT) {
                    jsonObject.putConvert(fieldName, this.deserializeObjectOrArray(xmlParser, context));
                } else {
                    Object value = xmlParser.readValueAs(Object.class);
                    jsonObject.putConvert(fieldName, value);
                }
                token = xmlParser.nextToken();
            }
            return jsonObject;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void registerCustomModules(XmlMapper objectMapper) {
        this.registerIJsonObjectModule(objectMapper);
    }

    protected void registerIJsonObjectModule(XmlMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(IJsonObject.class, this.getJsonObjectSerializer());
        module.addDeserializer(IJsonObject.class, this.getJsonObjectDeserializer());
        module.addSerializer(IJsonArray.class, this.getJsonArraySerializer());
        module.addDeserializer(IJsonArray.class, this.getJsonArrayDeserializer());
        objectMapper.registerModule(module);
    }

    @Override
    public String toXml(Object obj) {
        return this.toXml(obj, false);
    }

    @Override
    public String toXml(Object obj, boolean pretty) {
        try {
            if (pretty) {
                return this.getXmlMapperPretty().writeValueAsString(obj);
            }
            return this.getXmlMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public IJsonObject fromXml(String xml) {
        return (IJsonObject)this.fromXmlToType(xml, (Type)((Object)IJsonObject.class));
    }

    @Override
    public IJsonArray fromXmlToJsonArray(String xml) {
        return (IJsonArray)this.fromXmlToType(xml, (Type)((Object)IJsonArray.class));
    }

    @Override
    public <T> T fromXml(String xml, Class<T> clazz) {
        return this.fromXmlToType(xml, clazz);
    }

    protected void injectDependencies(Object obj) {
        if (obj != null) {
            this.getGuice().injectMembers(obj);
        }
    }

    @Override
    public <T> T fromXmlToType(String xml, Type type) {
        if (xml == null) {
            return null;
        }
        if (type == null) {
            return null;
        }
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructType(type);
            Object obj = this.getXmlMapper().readValue(xml, javaType);
            this.injectDependencies(obj);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public <T> T fromXmlInputStream(InputStream inputStream, Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can't be NULL");
        if (inputStream == null) {
            return null;
        }
        try {
            JavaType javaType = TypeFactory.defaultInstance().constructType(clazz);
            Object obj = this.getXmlMapper().readValue(inputStream, javaType);
            this.injectDependencies(obj);
            return obj;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

