/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.pebble;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.mitchellbosecke.pebble.extension.Filter;
import com.mitchellbosecke.pebble.extension.Function;
import com.mitchellbosecke.pebble.extension.NodeVisitorFactory;
import com.mitchellbosecke.pebble.extension.Test;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.operator.BinaryOperator;
import com.mitchellbosecke.pebble.operator.UnaryOperator;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.tokenParser.TokenParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spincast.core.templating.ITemplatingEngine;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.pebble.ISpincastPebbleExtension;

public class SpincastPebbleExtension
implements ISpincastPebbleExtension {
    private final Provider<ITemplatingEngine> templatingEngineProvider;
    private ITemplatingEngine templatingEngine;

    @Inject
    public SpincastPebbleExtension(Provider<ITemplatingEngine> templatingEngineProvider) {
        this.templatingEngineProvider = templatingEngineProvider;
    }

    public ITemplatingEngine getTemplatingEngine() {
        if (this.templatingEngine == null) {
            this.templatingEngine = this.templatingEngineProvider.get();
        }
        return this.templatingEngine;
    }

    @Override
    public Map<String, Filter> getFilters() {
        return null;
    }

    @Override
    public Map<String, Test> getTests() {
        return null;
    }

    @Override
    public List<TokenParser> getTokenParsers() {
        return null;
    }

    @Override
    public List<BinaryOperator> getBinaryOperators() {
        return null;
    }

    @Override
    public List<UnaryOperator> getUnaryOperators() {
        return null;
    }

    @Override
    public Map<String, Object> getGlobalVariables() {
        return null;
    }

    @Override
    public List<NodeVisitorFactory> getNodeVisitors() {
        return null;
    }

    @Override
    public Map<String, Function> getFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>();
        Function function = this.getFieldErrorMessagesFunction();
        if (function != null) {
            functions.put(this.getFieldErrorMessagesFunctionName(), function);
        }
        if ((function = this.getFieldValueFunction()) != null) {
            functions.put(this.getFieldValueFunctionName(), function);
        }
        if ((function = this.getFieldCheckedFunction()) != null) {
            functions.put(this.getFieldCheckedFunctionName(), function);
        }
        if ((function = this.getFieldGroupErrorClassFunction()) != null) {
            functions.put(this.getFieldGroupErrorClassFunctionName(), function);
        }
        if ((function = this.getCheckedFunction()) != null) {
            functions.put(this.getCheckedFunctionName(), function);
        }
        if ((function = this.getSelectedFunction()) != null) {
            functions.put(this.getSelectedFunctionName(), function);
        }
        return functions;
    }

    protected String getFieldErrorMessagesFunctionName() {
        return "fieldErrors";
    }

    protected String getFieldValueFunctionName() {
        return "fieldValue";
    }

    protected String getFieldCheckedFunctionName() {
        return "fieldChecked";
    }

    protected String getFieldGroupErrorClassFunctionName() {
        return "fieldSectionErrorClass";
    }

    protected String getCheckedFunctionName() {
        return "checked";
    }

    protected String getSelectedFunctionName() {
        return "selected";
    }

    protected Function getFieldErrorMessagesFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("fieldName", "valueOrIndex");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                EvaluationContext evaluationContext = (EvaluationContext)args.get("_context");
                Map fields = (Map)evaluationContext.getScopeChain().get("fields");
                if (fields == null || fields.size() == 0) {
                    return "";
                }
                String fieldName = (String)args.get("fieldName");
                if (fieldName == null) {
                    return "";
                }
                Map field = (Map)fields.get(fieldName = fieldName.trim());
                if (field == null) {
                    return "";
                }
                List errors = null;
                Object valueOrIndex = args.get("valueOrIndex");
                if (valueOrIndex != null) {
                    List valuesObjects = (List)field.get("values");
                    if (valuesObjects == null || valuesObjects.size() == 0) {
                        return "";
                    }
                    if (valueOrIndex instanceof Number) {
                        List err;
                        int valueIndex = Long.valueOf(valueOrIndex.toString()).intValue();
                        int pos = 0;
                        if (valueIndex > 0) {
                            if (valueIndex > valuesObjects.size() - 1) {
                                return "";
                            }
                            pos = valueIndex;
                        }
                        errors = err = (List)((Map)valuesObjects.get(pos)).get("errors");
                    } else {
                        String valueStr = valueOrIndex.toString().trim();
                        for (Map valueObject : valuesObjects) {
                            List err;
                            Object value = valueObject.get("value");
                            if (!valueStr.equals(value)) continue;
                            errors = err = (List)valueObject.get("errors");
                            break;
                        }
                    }
                } else {
                    List err;
                    errors = err = (List)field.get("errors");
                }
                if (errors == null || errors.size() == 0) {
                    return "";
                }
                String html = SpincastPebbleExtension.this.getTemplatingEngine().fromTemplate(SpincastPebbleExtension.this.getFieldErrorMessagesFunctionTemplatePath(), SpincastStatics.params("errors", errors));
                return new SafeString(html);
            }
        };
        return function;
    }

    protected String getFieldErrorMessagesFunctionTemplatePath() {
        return "/spincast/spincast-plugins-pebble/spincastPebbleExtension/fieldErrorMessagesFunctionTemplate.html";
    }

    protected Function getFieldValueFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("fieldName", "valueIndex");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                Map valueObject;
                Object value;
                int valueIndexInt;
                EvaluationContext evaluationContext = (EvaluationContext)args.get("_context");
                Map fields = (Map)evaluationContext.getScopeChain().get("fields");
                if (fields == null || fields.size() == 0) {
                    return "";
                }
                String fieldName = (String)args.get("fieldName");
                if (fieldName == null) {
                    return "";
                }
                Map field = (Map)fields.get(fieldName = fieldName.trim());
                if (field == null) {
                    return "";
                }
                List valuesObjects = (List)field.get("values");
                if (valuesObjects == null || valuesObjects.size() == 0) {
                    return "";
                }
                Long valueIndex = (Long)args.get("valueIndex");
                int pos = 0;
                if (valueIndex != null && (valueIndexInt = valueIndex.intValue()) > 0) {
                    if (valueIndexInt > valuesObjects.size() - 1) {
                        return "";
                    }
                    pos = valueIndexInt;
                }
                if ((value = (valueObject = (Map)valuesObjects.get(pos)).get("value")) == null) {
                    value = "";
                }
                return value;
            }
        };
        return function;
    }

    protected Function getFieldCheckedFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("fieldName", "option");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                Map field;
                EvaluationContext evaluationContext = (EvaluationContext)args.get("_context");
                Map fields = (Map)evaluationContext.getScopeChain().get("fields");
                if (fields == null || fields.size() == 0) {
                    return false;
                }
                String fieldName = (String)args.get("fieldName");
                if (fieldName == null) {
                    return false;
                }
                fieldName = fieldName.trim();
                String option = (String)args.get("option");
                if (option != null && fieldName.endsWith("[]")) {
                    option = option.trim();
                    fieldName = fieldName.substring(0, fieldName.length() - "[]".length());
                    fieldName = fieldName + "[" + option + "]";
                }
                if ((field = (Map)fields.get(fieldName)) == null) {
                    return false;
                }
                String value = (String)field.get("value");
                if (value == null) {
                    return false;
                }
                if (option != null) {
                    return option.equals(value);
                }
                return true;
            }
        };
        return function;
    }

    protected Function getFieldGroupErrorClassFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("fieldName");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                EvaluationContext evaluationContext = (EvaluationContext)args.get("_context");
                Map fields = (Map)evaluationContext.getScopeChain().get("fields");
                if (fields == null || fields.size() == 0) {
                    return "";
                }
                String fieldName = (String)args.get("fieldName");
                if (fieldName == null) {
                    return "";
                }
                Map field = (Map)fields.get(fieldName = fieldName.trim());
                if (field == null) {
                    return "";
                }
                Boolean value = (Boolean)field.get("isError");
                if (value == null || !value.booleanValue()) {
                    return "";
                }
                return SpincastPebbleExtension.this.getFieldGroupErrorClassFunctionErrorClass();
            }
        };
        return function;
    }

    protected String getFieldGroupErrorClassFunctionErrorClass() {
        return "has-error";
    }

    protected Function getCheckedFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("bool");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                Object bool = args.get("bool");
                if (bool == null) {
                    return "";
                }
                if (Boolean.parseBoolean(bool.toString())) {
                    return "checked";
                }
                return "";
            }
        };
        return function;
    }

    protected Function getSelectedFunction() {
        Function function = new Function(){

            @Override
            public List<String> getArgumentNames() {
                return Lists.newArrayList("bool");
            }

            @Override
            public Object execute(Map<String, Object> args) {
                Object bool = args.get("bool");
                if (bool == null) {
                    return "";
                }
                if (Boolean.parseBoolean(bool.toString())) {
                    return "selected";
                }
                return "";
            }
        };
        return function;
    }
}

