/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.routing.Handler;
import org.spincast.core.server.Server;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.controller.AppController;
import org.spincast.quickstart.exchange.AppHandler;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.quickstart.exchange.AppRouter;
import org.spincast.quickstart.guice.AppModule;

public class App {
    protected final Logger logger = LoggerFactory.getLogger(App.class);
    private final Server server;
    private final AppConfig appConfig;
    private final AppRouter router;
    private final AppController appController;
    private final SpincastFilters<AppRequestContext> spincastFilters;

    public static void main(String[] args) {
        App.createApp(args, null);
    }

    public static Injector createApp(String[] args, Module overridingModule) {
        if (args == null) {
            args = new String[]{};
        }
        Injector guice = null;
        guice = overridingModule != null ? Guice.createInjector(Modules.override(App.getAppModules(args)).with(overridingModule)) : Guice.createInjector(App.getAppModules(args));
        App app = guice.getInstance(App.class);
        app.start();
        return guice;
    }

    protected static List<? extends Module> getAppModules(String[] args) {
        return Lists.newArrayList(new AppModule(args));
    }

    @Inject
    public App(Server server, AppConfig config, AppRouter router, AppController appController, SpincastFilters<AppRequestContext> spincastFilters) {
        this.server = server;
        this.appConfig = config;
        this.router = router;
        this.appController = appController;
        this.spincastFilters = spincastFilters;
    }

    protected AppConfig getConfig() {
        return this.appConfig;
    }

    protected Server getServer() {
        return this.server;
    }

    protected AppRouter getRouter() {
        return this.router;
    }

    protected AppController getAppController() {
        return this.appController;
    }

    protected SpincastFilters<AppRequestContext> getSpincastFilters() {
        return this.spincastFilters;
    }

    protected void start() {
        this.addRoutes();
        this.getServer().start();
        this.displayStartedMessage();
    }

    protected void addRoutes() {
        this.getRouter().GET("/").cache(3600).save(new AppHandler(){

            @Override
            public void handle(AppRequestContext context) {
                App.this.getAppController().indexPage(context);
            }
        });
        this.getRouter().GET("/greet/${name}").save(new Handler<AppRequestContext>(){

            @Override
            public void handle(AppRequestContext context) {
                context.customGreetingMethod();
            }
        });
        this.getRouter().POST("/sum").save(new AppHandler(){

            @Override
            public void handle(AppRequestContext context) {
                App.this.getAppController().sumRoute(context);
            }
        });
        this.getRouter().notFound(new AppHandler(){

            @Override
            public void handle(AppRequestContext context) {
                App.this.getAppController().notFound(context);
            }
        });
        this.getRouter().exception(new AppHandler(){

            @Override
            public void handle(AppRequestContext context) {
                App.this.getAppController().exception(context);
            }
        });
        this.getRouter().dir("/public").classpath("/public").save();
        this.getRouter().file("/favicon.ico").classpath("/public/favicon.ico").save();
        this.getRouter().file("/robots.txt").classpath("/public/robots.txt").save();
        this.getRouter().file("/humans.txt").classpath("/public/humans.txt").save();
        this.getRouter().file("/browserconfig.xml").classpath("/public/browserconfig.xml").save();
        this.getRouter().file("/apple-touch-icon.png").classpath("/public/apple-touch-icon.png").save();
        this.getRouter().file("/tile-wide.png").classpath("/public/tile-wide.png").save();
        this.getRouter().file("/tile.png").classpath("/public/tile.png").save();
        this.getRouter().before().save(new AppHandler(){

            @Override
            public void handle(AppRequestContext context) {
                App.this.getSpincastFilters().addSecurityHeaders(context);
            }
        });
    }

    protected void displayStartedMessage() {
        System.out.println();
        System.out.println("==========================================");
        System.out.print("Spincast quick start application started on ");
        if (this.getConfig().getHttpServerPort() > 0) {
            System.out.print("port " + this.getConfig().getHttpServerPort());
        }
        if (this.getConfig().getHttpsServerPort() > 0) {
            if (this.getConfig().getHttpServerPort() > 0) {
                System.out.print(" and ");
            }
            System.out.print("port " + this.getConfig().getHttpsServerPort() + " (HTTPS)");
        }
        System.out.println();
        System.out.println("Try hitting the index page or \"/greet/[YourName]\"...");
        System.out.println("==========================================");
    }
}

