/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.exceptions.PublicExceptionDefault;
import org.spincast.core.json.JsonObject;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppController {
    private final AppConfig appConfig;

    @Inject
    public AppController(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    public void notFound(AppRequestContext context) {
        String notFoundMessage = "Page not found";
        String specificNotFoundMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (specificNotFoundMessage != null) {
            notFoundMessage = specificNotFoundMessage;
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("message", notFoundMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("notFoundMessage", notFoundMessage);
            context.response().sendTemplateHtml("/templates/notFound.html");
        }
    }

    public void exception(AppRequestContext context) {
        String errorMessage = "An error occured! Please try again later...";
        Throwable originalException = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Throwable.class);
        if (originalException != null && originalException instanceof PublicException) {
            errorMessage = originalException.getMessage();
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("error", errorMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("errorMessage", errorMessage);
            context.response().sendTemplateHtml("/templates/exception.html");
        }
    }

    public void indexPage(AppRequestContext context) {
        context.response().getModel().put("appName", this.getAppConfig().getAppName());
        context.response().getModel().put("serverPort", this.getAppConfig().getHttpServerPort());
        context.response().sendTemplateHtml("/templates/index.html");
    }

    public void sumRoute(AppRequestContext context) {
        long sum;
        String error;
        block11: {
            int secondInt;
            int firstInt;
            String firstNbr = context.request().getFormData().getString("first");
            if (StringUtils.isBlank(firstNbr)) {
                throw new PublicExceptionDefault("The 'first' post parameter is required.", 400);
            }
            String secondNbr = context.request().getFormData().getString("second");
            if (StringUtils.isBlank(secondNbr)) {
                throw new PublicExceptionDefault("The 'second' post parameter is required.", 400);
            }
            error = null;
            sum = 0L;
            try {
                firstInt = Integer.parseInt(firstNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            try {
                secondInt = Integer.parseInt(secondNbr);
            }
            catch (NumberFormatException ex) {
                error = ex.getMessage();
                break block11;
            }
            sum = (long)firstInt + (long)secondInt;
            if (sum > Integer.MAX_VALUE) {
                error = "The sum overflows the maximum integer value, 2147483647";
            } else if (sum < Integer.MIN_VALUE) {
                error = "The sum overflows the minimum integer value, -2147483648";
            }
        }
        JsonObject resultObj = context.json().create();
        if (error != null) {
            context.response().setStatusCode(400);
            resultObj.put("error", error);
        } else {
            resultObj.put("result", String.valueOf(sum));
        }
        context.response().sendJson(resultObj);
    }
}

