/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.config;

import com.google.inject.Inject;
import org.spincast.core.config.SpincastConfig;

public class SpincastInitValidator {
    private final SpincastConfig spincastConfig;

    @Inject
    public SpincastInitValidator(SpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    @Inject
    protected void init() {
        this.validateLocalhostHost();
    }

    protected void validateLocalhostHost() {
        if (!this.getSpincastConfig().isDebugEnabled() && !"local".equals(this.getSpincastConfig().getEnvironmentName()) && "localhost".equals(this.getSpincastConfig().getPublicServerHost()) && this.getSpincastConfig().isValidateLocalhostHost()) {
            throw new RuntimeException("Did you forget to override the SpincastConfig#getPublicServerSchemeHostPort() method? The application was started on an environment other than 'local', with the debug mode disabled, but the host returned by SpincastConfig#getPublicServerSchemeHostPort() is 'localhost'... Make sure the host specified in this config is the *public* one. Note : you can disable this validation by changing the SpincastConfig#isValidateLocalhostHost() config.");
        }
    }
}

