/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.guice;

import com.google.inject.Key;
import com.google.inject.Scopes;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.plugins.routing.SpincastRoutingPluginGuiceModule;
import org.spincast.quickstart.App;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.config.AppConfigDefault;
import org.spincast.quickstart.controller.AppController;
import org.spincast.quickstart.exchange.AppRequestContextDefault;
import org.spincast.quickstart.exchange.AppRouter;
import org.spincast.quickstart.exchange.AppRouterDefault;
import org.spincast.quickstart.exchange.AppWebsocketContextDefault;

public class AppModule
extends SpincastDefaultGuiceModule {
    public AppModule(String[] mainArgs) {
        super(mainArgs);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(AppConfigDefault.class).in(Scopes.SINGLETON);
        this.bind(AppConfig.class).to(AppConfigDefault.class).in(Scopes.SINGLETON);
        this.bind(AppRouterDefault.class).in(Scopes.SINGLETON);
        this.bind(AppRouter.class).to(AppRouterDefault.class).in(Scopes.SINGLETON);
        this.bind(AppController.class).in(Scopes.SINGLETON);
        this.bind(App.class).in(Scopes.SINGLETON);
    }

    @Override
    protected Class<? extends RequestContext<?>> getRequestContextImplementationClass() {
        return AppRequestContextDefault.class;
    }

    @Override
    protected Class<? extends WebsocketContext<?>> getWebsocketContextImplementationClass() {
        return AppWebsocketContextDefault.class;
    }

    @Override
    protected void bindConfigPlugin() {
        this.bind(SpincastConfig.class).to(AppConfigDefault.class).in(Scopes.SINGLETON);
    }

    @Override
    protected void bindRoutingPlugin() {
        this.install(new SpincastRoutingPluginGuiceModule(this.getRequestContextType(), this.getWebsocketContextType()){

            @Override
            protected Key<?> getRouterImplementationKey() {
                return Key.get(AppRouterDefault.class);
            }
        });
    }
}

