/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import java.util.List;
import java.util.Map;
import org.spincast.core.exceptions.CantCompareException;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.ToJsonObjectConvertible;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationBuilderKey;
import org.spincast.core.validation.ValidationLevel;
import org.spincast.core.validation.ValidationMessage;
import org.spincast.core.validation.ValidationMessageFormatType;

public interface ValidationSet
extends ToJsonObjectConvertible {
    public static final String VALIDATION_CODE_WHOLE_ARRAY_VALIDATION_RESULT_TYPE = "VALIDATION_TYPE_WHOLE_ARRAY_VALIDATION_RESULT_TYPE";
    public static final String VALIDATION_CODE_NOT_AN_ARRAY = "VALIDATION_TYPE_NOT_AN_ARRAY";
    public static final String VALIDATION_CODE_NOT_NULL = "VALIDATION_TYPE_NOT_NULL";
    public static final String VALIDATION_CODE_NULL = "VALIDATION_TYPE_NULL";
    public static final String VALIDATION_CODE_NOT_BLANK = "VALIDATION_TYPE_NOT_BLANK";
    public static final String VALIDATION_CODE_BLANK = "VALIDATION_TYPE_BLANK";
    public static final String VALIDATION_CODE_EQUIVALENT = "VALIDATION_TYPE_EQUALS";
    public static final String VALIDATION_CODE_NOT_EQUIVALENT = "VALIDATION_TYPE_NOT_EQUALS";
    public static final String VALIDATION_CODE_EQUIVALENT_OR_GREATER = "VALIDATION_TYPE_EQUALS_OR_GREATER";
    public static final String VALIDATION_CODE_GREATER = "VALIDATION_TYPE_GREATER";
    public static final String VALIDATION_CODE_EQUIVALENT_OR_LESS = "VALIDATION_TYPE_EQUALS_OR_LESS";
    public static final String VALIDATION_CODE_LESS = "VALIDATION_TYPE_LESS";
    public static final String VALIDATION_CODE_LENGTH = "VALIDATION_TYPE_LENGTH";
    public static final String VALIDATION_CODE_MIN_LENGTH = "VALIDATION_TYPE_MIN_LENGTH";
    public static final String VALIDATION_CODE_MAX_LENGTH = "VALIDATION_TYPE_MAX_LENGTH";
    public static final String VALIDATION_CODE_PATTERN = "VALIDATION_TYPE_PATTERN";
    public static final String VALIDATION_CODE_NOT_PATTERN = "VALIDATION_TYPE_NOT_PATTERN";
    public static final String VALIDATION_CODE_EMAIL = "VALIDATION_TYPE_EMAIL";
    public static final String VALIDATION_CODE_SIZE = "VALIDATION_TYPE_SIZE";
    public static final String VALIDATION_CODE_MIN_SIZE = "VALIDATION_TYPE_MIN_SIZE";
    public static final String VALIDATION_CODE_MAX_SIZE = "VALIDATION_TYPE_MAX_SIZE";
    public static final String VALIDATION_CODE_CAN_BE_CONVERTED_TO = "VALIDATION_TYPE_CAN_BE_CONVERTED_TO";
    public static final String VALIDATION_CODE_IS_OF_TYPE = "VALIDATION_TYPE_IS_OF_TYPE";

    public ValidationSet createValidationSet();

    public ValidationSet addMessage(String var1, ValidationMessage var2);

    public ValidationSet addMessage(String var1, ValidationLevel var2, String var3, String var4);

    public ValidationSet addError(String var1, String var2, String var3);

    public ValidationSet addWarning(String var1, String var2, String var3);

    public ValidationSet addSuccess(String var1, String var2, String var3);

    public ValidationSet mergeValidationSet(ValidationSet var1);

    public ValidationSet mergeValidationSet(String var1, ValidationSet var2);

    public boolean hasMessages();

    public boolean hasMessages(String var1);

    public boolean isWarning();

    public boolean isWarning(String var1);

    public boolean isSuccess();

    public boolean isSuccess(String var1);

    public boolean isError();

    public boolean isError(String var1);

    public boolean isValid();

    public boolean isValid(String var1);

    public Map<String, List<ValidationMessage>> getMessages();

    public List<ValidationMessage> getMessages(String var1);

    public String getMessagesFormatted(String var1, ValidationMessageFormatType var2);

    public String getMessagesFormatted(ValidationMessageFormatType var1);

    @Override
    public JsonObject convertToJsonObject();

    public ValidationBuilderKey validation(SimpleValidator var1);

    public ValidationBuilderKey validationNotBlank();

    public ValidationBuilderKey validationBlank();

    public ValidationBuilderKey validationEmail();

    public ValidationBuilderKey validationNotNull();

    public ValidationBuilderKey validationNull();

    public ValidationBuilderKey validationPattern(String var1);

    public ValidationBuilderKey validationNotPattern(String var1);

    public ValidationBuilderKey validationSize(int var1, boolean var2);

    public ValidationBuilderKey validationMinSize(int var1, boolean var2);

    public ValidationBuilderKey validationMaxSize(int var1, boolean var2);

    public ValidationBuilderKey validationLength(int var1);

    public ValidationBuilderKey validationMinLength(int var1);

    public ValidationBuilderKey validationMaxLength(int var1);

    public ValidationBuilderKey validationEquivalent(Object var1);

    public ValidationBuilderKey validationNotEquivalent(Object var1);

    public ValidationBuilderKey validationLess(Object var1) throws CantCompareException;

    public ValidationBuilderKey validationGreater(Object var1) throws CantCompareException;

    public ValidationBuilderKey validationEquivalentOrLess(Object var1) throws CantCompareException;

    public ValidationBuilderKey validationEquivalentOrGreater(Object var1) throws CantCompareException;

    public ValidationSet prefixValidationKeys(String var1);
}

