/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Set;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.SpincastPluginBase;
import org.spincast.plugins.config.SpincastConfigPluginModule;

public class SpincastConfigPlugin
extends SpincastPluginBase {
    public static final String PLUGIN_ID = SpincastConfigPlugin.class.getName();
    private Class<? extends SpincastConfig> specificConfigImplClass;

    public SpincastConfigPlugin() {
    }

    public SpincastConfigPlugin(Class<? extends SpincastConfig> specificConfigImplClass) {
        this.specificConfigImplClass = specificConfigImplClass;
    }

    @Override
    public String getId() {
        return PLUGIN_ID;
    }

    protected Class<? extends SpincastConfig> getSpecificConfigImplClass() {
        return this.specificConfigImplClass;
    }

    @Override
    public Module apply(Module module) {
        GuiceModuleUtils guiceModuleUtils;
        Set<Class<SpincastConfig>> classes;
        Class<? extends SpincastConfig> specificConfigImplClass = this.getSpecificConfigImplClass();
        if (specificConfigImplClass == null && (classes = (guiceModuleUtils = new GuiceModuleUtils(module)).getBoundClassesExtending(SpincastConfig.class)).size() > 0) {
            if (classes.size() > 1) {
                String msg = "More than one custom implementations of " + SpincastConfig.class.getName() + " has been found. You'll have to pass the implementation to use the constructor of this plugin to remove the ambiguity about which one to use. Bindings found :\n";
                for (Class<SpincastConfig> clazz : classes) {
                    msg = msg + "- " + clazz.getName() + "\n";
                }
                throw new RuntimeException(msg);
            }
            Class<SpincastConfig> temp = classes.iterator().next();
            specificConfigImplClass = temp;
        }
        Module pluginModule = this.getPluginModule(specificConfigImplClass);
        this.setContextTypes(pluginModule);
        module = Modules.override(pluginModule).with(module);
        return module;
    }

    protected Module getPluginModule(Class<? extends SpincastConfig> specificConfigImplClass) {
        return new SpincastConfigPluginModule(specificConfigImplClass);
    }
}

