/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.json.JsonObject;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppController {
    protected final Logger logger = LoggerFactory.getLogger(AppController.class);
    private final AppConfig appConfig;

    @Inject
    public AppController(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected void addCommonModelElements(AppRequestContext context) {
        context.response().getModel().put("appName", this.getAppConfig().getAppName());
        context.response().getModel().put("serverPort", this.getAppConfig().getHttpServerPort());
    }

    public void index(AppRequestContext context) {
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/templates/index.html");
    }

    public void formExample(AppRequestContext context) {
        String userName = context.request().getQueryStringParamFirst("userName");
        String greetings = "";
        if (!StringUtils.isBlank(userName)) {
            greetings = "Hi " + userName + "!";
        }
        context.response().getModel().put("userName", userName);
        context.response().getModel().put("greetings", greetings);
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/templates/form.html");
    }

    public void exceptionExample(AppRequestContext context) {
        throw new RuntimeException("This simulates an exception in the application!");
    }

    public void notFound(AppRequestContext context) {
        String notFoundMessage = "Page not found";
        String specificNotFoundMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (specificNotFoundMessage != null) {
            notFoundMessage = specificNotFoundMessage;
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("message", notFoundMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("notFoundMessage", notFoundMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/templates/notFound.html");
        }
    }

    public void exception(AppRequestContext context) {
        String errorMessage = "An error occured! Please try again later...";
        Throwable originalException = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Throwable.class);
        this.logger.error("An exception occured : " + originalException);
        if (originalException != null && originalException instanceof PublicException) {
            errorMessage = originalException.getMessage();
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.put("error", errorMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().put("errorMessage", errorMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/templates/exception.html");
        }
    }
}

