/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AnnotatedClass
extends Annotated
implements TypeResolutionContext {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final JavaType _type;
    protected final Class<?> _class;
    protected final TypeBindings _bindings;
    protected final List<JavaType> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected boolean _creatorsResolved = false;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;

    private AnnotatedClass(JavaType type, Class<?> rawType, TypeBindings bindings, List<JavaType> superTypes, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir, TypeFactory tf, AnnotationMap classAnnotations) {
        this._type = type;
        this._class = rawType;
        this._bindings = bindings;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
        this._typeFactory = tf;
        this._mixInResolver = mir;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = classAnnotations;
    }

    @Override
    public AnnotatedClass withAnnotations(AnnotationMap ann) {
        return new AnnotatedClass(this._type, this._class, this._bindings, this._superTypes, this._annotationIntrospector, this._mixInResolver, this._typeFactory, ann);
    }

    public static AnnotatedClass construct(JavaType type, MapperConfig<?> config) {
        AnnotationIntrospector intr = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        Class<?> raw = type.getRawClass();
        return new AnnotatedClass(type, raw, type.getBindings(), ClassUtil.findSuperTypes(type, null, false), intr, config, config.getTypeFactory(), null);
    }

    public static AnnotatedClass construct(JavaType type, MapperConfig<?> config, ClassIntrospector.MixInResolver mir) {
        AnnotationIntrospector intr = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        Class<?> raw = type.getRawClass();
        return new AnnotatedClass(type, raw, type.getBindings(), ClassUtil.findSuperTypes(type, null, false), intr, mir, config.getTypeFactory(), null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, MapperConfig<?> config) {
        if (config == null) {
            return new AnnotatedClass(null, cls, TypeBindings.emptyBindings(), Collections.emptyList(), null, null, null, null);
        }
        AnnotationIntrospector intr = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        return new AnnotatedClass(null, cls, TypeBindings.emptyBindings(), Collections.emptyList(), intr, config, config.getTypeFactory(), null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, MapperConfig<?> config, ClassIntrospector.MixInResolver mir) {
        if (config == null) {
            return new AnnotatedClass(null, cls, TypeBindings.emptyBindings(), Collections.emptyList(), null, null, null, null);
        }
        AnnotationIntrospector intr = config.isAnnotationProcessingEnabled() ? config.getAnnotationIntrospector() : null;
        return new AnnotatedClass(null, cls, TypeBindings.emptyBindings(), Collections.emptyList(), intr, mir, config.getTypeFactory(), null);
    }

    @Override
    public JavaType resolveType(Type type) {
        return this._typeFactory.constructType(type, this._bindings);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._classAnnotations().get(acls);
    }

    @Override
    public boolean hasAnnotation(Class<?> acls) {
        return this._classAnnotations().has(acls);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
        return this._classAnnotations().hasOneOf(annoClasses);
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    public Iterable<Annotation> annotations() {
        return this._classAnnotations().annotations();
    }

    @Override
    protected AnnotationMap getAllAnnotations() {
        return this._classAnnotations();
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations();
    }

    public boolean hasAnnotations() {
        return this._classAnnotations().size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.find(name, paramTypes);
    }

    public int getFieldCount() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnnotationMap _classAnnotations() {
        AnnotationMap anns = this._classAnnotations;
        if (anns == null) {
            AnnotatedClass annotatedClass = this;
            synchronized (annotatedClass) {
                anns = this._classAnnotations;
                if (anns == null) {
                    this._classAnnotations = anns = this._resolveClassAnnotations();
                }
            }
        }
        return anns;
    }

    private AnnotationMap _resolveClassAnnotations() {
        AnnotationMap ca = new AnnotationMap();
        if (this._annotationIntrospector != null) {
            if (this._primaryMixIn != null) {
                this._addClassMixIns(ca, this._class, this._primaryMixIn);
            }
            this._addAnnotationsIfNotPresent(ca, ClassUtil.findClassAnnotations(this._class));
            for (JavaType type : this._superTypes) {
                this._addClassMixIns(ca, type);
                this._addAnnotationsIfNotPresent(ca, ClassUtil.findClassAnnotations(type.getRawClass()));
            }
            this._addClassMixIns(ca, Object.class);
        }
        return ca;
    }

    private void resolveCreators() {
        AnnotatedClass typeContext = this;
        ArrayList<AnnotatedConstructor> constructors = null;
        if (!this._type.isEnumType()) {
            ClassUtil.Ctor[] declaredCtors = ClassUtil.getConstructors(this._class);
            for (ClassUtil.Ctor ctor : declaredCtors) {
                if (!this._isIncludableConstructor(ctor.getConstructor())) continue;
                if (ctor.getParamCount() == 0) {
                    this._defaultConstructor = this._constructDefaultConstructor(ctor, typeContext);
                    continue;
                }
                if (constructors == null) {
                    constructors = new ArrayList<AnnotatedConstructor>(Math.max(10, declaredCtors.length));
                }
                constructors.add(this._constructNonDefaultConstructor(ctor, typeContext));
            }
        }
        this._constructors = constructors == null ? Collections.emptyList() : constructors;
        if (!(this._primaryMixIn == null || this._defaultConstructor == null && this._constructors.isEmpty())) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                int i = this._constructors.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._constructors.get(i))) continue;
                    this._constructors.remove(i);
                }
            }
        }
        ArrayList<AnnotatedMethod> creatorMethods = null;
        for (Method m : this._findClassMethods(this._class)) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            if (creatorMethods == null) {
                creatorMethods = new ArrayList<AnnotatedMethod>(8);
            }
            creatorMethods.add(this._constructCreatorMethod(m, typeContext));
        }
        if (creatorMethods == null) {
            this._creatorMethods = Collections.emptyList();
        } else {
            this._creatorMethods = creatorMethods;
            if (this._primaryMixIn != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null) {
                int i = this._creatorMethods.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._creatorMethods.get(i))) continue;
                    this._creatorMethods.remove(i);
                }
            }
        }
        this._creatorsResolved = true;
    }

    private void resolveMemberMethods() {
        Class<?> mixin;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap mixins = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, this, this._memberMethods, this._primaryMixIn, mixins);
        for (JavaType type : this._superTypes) {
            Class<?> mixin2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(type.getRawClass());
            this._addMemberMethods(type.getRawClass(), new TypeResolutionContext.Basic(this._typeFactory, type.getBindings()), this._memberMethods, mixin2, mixins);
        }
        if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(this._class, this._memberMethods, mixin, mixins);
        }
        if (this._annotationIntrospector != null && !mixins.isEmpty()) {
            for (AnnotatedMethod mixIn : mixins) {
                try {
                    Method m = Object.class.getDeclaredMethod(mixIn.getName(), mixIn.getRawParameterTypes());
                    if (m == null) continue;
                    AnnotatedMethod am = this._constructMethod(m, this);
                    this._addMixOvers(mixIn.getAnnotated(), am, false);
                    this._memberMethods.add(am);
                }
                catch (Exception e) {}
            }
        }
    }

    private void resolveFields() {
        Map<String, AnnotatedField> foundFields = this._findFields(this._type, this, null);
        if (foundFields == null || foundFields.size() == 0) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(foundFields.size());
            this._fields.addAll(foundFields.values());
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, JavaType target) {
        if (this._mixInResolver != null) {
            Class<?> toMask = target.getRawClass();
            this._addClassMixIns(annotations, toMask, this._mixInResolver.findMixInClassFor(toMask));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> target) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotations, target, this._mixInResolver.findMixInClassFor(target));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask, Class<?> mixin) {
        if (mixin == null) {
            return;
        }
        this._addAnnotationsIfNotPresent(annotations, ClassUtil.findClassAnnotations(mixin));
        for (Class<?> parent : ClassUtil.findSuperClasses(mixin, toMask, false)) {
            this._addAnnotationsIfNotPresent(annotations, ClassUtil.findClassAnnotations(parent));
        }
    }

    protected void _addConstructorMixIns(Class<?> mixin) {
        MemberKey[] ctorKeys = null;
        int ctorCount = this._constructors == null ? 0 : this._constructors.size();
        block0: for (ClassUtil.Ctor ctor0 : ClassUtil.getConstructors(mixin)) {
            Constructor<?> ctor = ctor0.getConstructor();
            if (ctor.getParameterTypes().length == 0) {
                if (this._defaultConstructor == null) continue;
                this._addMixOvers(ctor, this._defaultConstructor, false);
                continue;
            }
            if (ctorKeys == null) {
                ctorKeys = new MemberKey[ctorCount];
                for (int i = 0; i < ctorCount; ++i) {
                    ctorKeys[i] = new MemberKey((Constructor<?>)this._constructors.get(i).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(ctor);
            for (int i = 0; i < ctorCount; ++i) {
                if (!key.equals(ctorKeys[i])) continue;
                this._addMixOvers(ctor, this._constructors.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> mixin) {
        MemberKey[] methodKeys = null;
        int methodCount = this._creatorMethods.size();
        block0: for (Method m : ClassUtil.getDeclaredMethods(mixin)) {
            if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length == 0) continue;
            if (methodKeys == null) {
                methodKeys = new MemberKey[methodCount];
                for (int i = 0; i < methodCount; ++i) {
                    methodKeys[i] = new MemberKey(this._creatorMethods.get(i).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(m);
            for (int i = 0; i < methodCount; ++i) {
                if (!key.equals(methodKeys[i])) continue;
                this._addMixOvers(m, this._creatorMethods.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addMemberMethods(Class<?> cls, TypeResolutionContext typeContext, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        if (mixInCls != null) {
            this._addMethodMixIns(cls, methods, mixInCls, mixIns);
        }
        if (cls == null) {
            return;
        }
        for (Method m : this._findClassMethods(cls)) {
            if (!this._isIncludableMemberMethod(m)) continue;
            AnnotatedMethod old = methods.find(m);
            if (old == null) {
                AnnotatedMethod newM = this._constructMethod(m, typeContext);
                methods.add(newM);
                old = mixIns.remove(m);
                if (old == null) continue;
                this._addMixOvers(old.getAnnotated(), newM, false);
                continue;
            }
            this._addMixUnders(m, old);
            if (!old.getDeclaringClass().isInterface() || m.getDeclaringClass().isInterface()) continue;
            methods.add(old.withMethod(m));
        }
    }

    protected void _addMethodMixIns(Class<?> targetClass, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        List<Class<?>> parents = ClassUtil.findRawSuperTypes(mixInCls, targetClass, true);
        for (Class<?> mixin : parents) {
            for (Method m : ClassUtil.getDeclaredMethods(mixin)) {
                if (!this._isIncludableMemberMethod(m)) continue;
                AnnotatedMethod am = methods.find(m);
                if (am != null) {
                    this._addMixUnders(m, am);
                    continue;
                }
                am = mixIns.find(m);
                if (am != null) {
                    this._addMixUnders(m, am);
                    continue;
                }
                mixIns.add(this._constructMethod(m, this));
            }
        }
    }

    protected Map<String, AnnotatedField> _findFields(JavaType type, TypeResolutionContext typeContext, Map<String, AnnotatedField> fields) {
        JavaType parent = type.getSuperClass();
        if (parent != null) {
            Class<?> mixin;
            Class<?> cls = type.getRawClass();
            fields = this._findFields(parent, new TypeResolutionContext.Basic(this._typeFactory, parent.getBindings()), fields);
            for (Field f : ClassUtil.getDeclaredFields(cls)) {
                if (!this._isIncludableField(f)) continue;
                if (fields == null) {
                    fields = new LinkedHashMap<String, AnnotatedField>();
                }
                fields.put(f.getName(), this._constructField(f, typeContext));
            }
            if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(cls)) != null) {
                this._addFieldMixIns(mixin, cls, fields);
            }
        }
        return fields;
    }

    protected void _addFieldMixIns(Class<?> mixInCls, Class<?> targetClass, Map<String, AnnotatedField> fields) {
        List<Class<?>> parents = ClassUtil.findSuperClasses(mixInCls, targetClass, true);
        for (Class<?> mixin : parents) {
            for (Field mixinField : ClassUtil.getDeclaredFields(mixin)) {
                String name;
                AnnotatedField maskedField;
                if (!this._isIncludableField(mixinField) || (maskedField = fields.get(name = mixinField.getName())) == null) continue;
                this._addOrOverrideAnnotations(maskedField, mixinField.getDeclaredAnnotations());
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method m, TypeResolutionContext typeContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(typeContext, m, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(typeContext, m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), null);
    }

    protected AnnotatedConstructor _constructDefaultConstructor(ClassUtil.Ctor ctor, TypeResolutionContext typeContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(typeContext, ctor.getConstructor(), this._emptyAnnotationMap(), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedConstructor(typeContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
    }

    protected AnnotatedConstructor _constructNonDefaultConstructor(ClassUtil.Ctor ctor, TypeResolutionContext typeContext) {
        AnnotationMap[] resolvedAnnotations;
        int paramCount = ctor.getParamCount();
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(typeContext, ctor.getConstructor(), this._emptyAnnotationMap(), this._emptyAnnotationMaps(paramCount));
        }
        if (paramCount == 0) {
            return new AnnotatedConstructor(typeContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
        }
        Annotation[][] paramAnns = ctor.getParameterAnnotations();
        if (paramCount != paramAnns.length) {
            resolvedAnnotations = null;
            Class<?> dc = ctor.getDeclaringClass();
            if (dc.isEnum() && paramCount == paramAnns.length + 2) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 2][];
                System.arraycopy(old, 0, paramAnns, 2, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            } else if (dc.isMemberClass() && paramCount == paramAnns.length + 1) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 1][];
                System.arraycopy(old, 0, paramAnns, 1, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            }
            if (resolvedAnnotations == null) {
                throw new IllegalStateException("Internal error: constructor for " + ctor.getDeclaringClass().getName() + " has mismatch: " + paramCount + " parameters; " + paramAnns.length + " sets of annotations");
            }
        } else {
            resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
        }
        return new AnnotatedConstructor(typeContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), resolvedAnnotations);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method m, TypeResolutionContext typeContext) {
        int paramCount = m.getParameterTypes().length;
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(typeContext, m, this._emptyAnnotationMap(), this._emptyAnnotationMaps(paramCount));
        }
        if (paramCount == 0) {
            return new AnnotatedMethod(typeContext, m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeContext, m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), this._collectRelevantAnnotations(m.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field f, TypeResolutionContext typeContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(typeContext, f, this._emptyAnnotationMap());
        }
        return new AnnotatedField(typeContext, f, this._collectRelevantAnnotations(f.getDeclaredAnnotations()));
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int count) {
        if (count == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count];
        for (int i = 0; i < count; ++i) {
            maps[i] = this._emptyAnnotationMap();
        }
        return maps;
    }

    protected boolean _isIncludableMemberMethod(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        if (m.isSynthetic() || m.isBridge()) {
            return false;
        }
        int pcount = m.getParameterTypes().length;
        return pcount <= 2;
    }

    private boolean _isIncludableField(Field f) {
        if (f.isSynthetic()) {
            return false;
        }
        int mods = f.getModifiers();
        return !Modifier.isStatic(mods);
    }

    private boolean _isIncludableConstructor(Constructor<?> c) {
        return !c.isSynthetic();
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] anns) {
        int len = anns.length;
        AnnotationMap[] result = new AnnotationMap[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this._collectRelevantAnnotations(anns[i]);
        }
        return result;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] anns) {
        return this._addAnnotationsIfNotPresent(new AnnotationMap(), anns);
    }

    private AnnotationMap _addAnnotationsIfNotPresent(AnnotationMap result, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasNotPresent = result.addIfNotPresent(ann);
                if (!wasNotPresent || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addAnnotationsIfNotPresent(result, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
        return result;
    }

    private List<Annotation> _addFromBundle(Annotation bundle2, List<Annotation> result) {
        for (Annotation a : ClassUtil.findClassAnnotations(bundle2.annotationType())) {
            if (a instanceof Target || a instanceof Retention) continue;
            if (result == null) {
                result = new ArrayList<Annotation>();
            }
            result.add(a);
        }
        return result;
    }

    private void _addAnnotationsIfNotPresent(AnnotatedMember target, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasNotPresent = target.addIfNotPresent(ann);
                if (!wasNotPresent || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addAnnotationsIfNotPresent(target, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
    }

    private void _addOrOverrideAnnotations(AnnotatedMember target, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasModified = target.addOrOverride(ann);
                if (!wasModified || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addOrOverrideAnnotations(target, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
    }

    protected void _addMixOvers(Constructor<?> mixin, AnnotatedConstructor target, boolean addParamAnnotations) {
        this._addOrOverrideAnnotations(target, mixin.getDeclaredAnnotations());
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixOvers(Method mixin, AnnotatedMethod target, boolean addParamAnnotations) {
        this._addOrOverrideAnnotations(target, mixin.getDeclaredAnnotations());
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixUnders(Method src, AnnotatedMethod target) {
        this._addAnnotationsIfNotPresent(target, src.getDeclaredAnnotations());
    }

    private final boolean _isAnnotationBundle(Annotation ann) {
        return this._annotationIntrospector != null && this._annotationIntrospector.isAnnotationBundle(ann);
    }

    protected Method[] _findClassMethods(Class<?> cls) {
        try {
            return ClassUtil.getDeclaredMethods(cls);
        }
        catch (NoClassDefFoundError ex) {
            Class<?> contextClass;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                throw ex;
            }
            try {
                contextClass = loader.loadClass(cls.getName());
            }
            catch (ClassNotFoundException e) {
                throw ex;
            }
            return contextClass.getDeclaredMethods();
        }
    }

    @Override
    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public int hashCode() {
        return this._class.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return ((AnnotatedClass)o)._class == this._class;
    }
}

