/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.validation;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.spincast.core.config.SpincastDictionary;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.validation.JsonArrayValidationBuilderKey;
import org.spincast.core.validation.JsonArrayValidationSet;
import org.spincast.core.validation.JsonObjectValidationSetDefault;
import org.spincast.core.validation.SimpleValidator;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.xml.XmlManager;

public class JsonArrayValidationSetDefault
extends JsonObjectValidationSetDefault
implements JsonArrayValidationSet {
    private Map<String, SimpleValidator> isOfTypeValidators;
    private Map<String, SimpleValidator> canBeConvertedToValidators;

    @AssistedInject
    public JsonArrayValidationSetDefault(@Assisted JsonArray validatedObject, ValidationFactory validationFactory, SpincastDictionary spincastDictionary, JsonManager jsonManager, XmlManager xmlManager, ObjectConverter objectConverter) {
        super(validatedObject, validationFactory, spincastDictionary, jsonManager, xmlManager, objectConverter);
    }

    @Override
    protected JsonArray getValidatedObject() {
        return (JsonArray)super.getValidatedObject();
    }

    @Override
    protected Map<String, SimpleValidator> getIsOfTypeValidators() {
        if (this.isOfTypeValidators == null) {
            this.isOfTypeValidators = new HashMap<String, SimpleValidator>();
        }
        return this.isOfTypeValidators;
    }

    @Override
    protected Map<String, SimpleValidator> getCanBeConvertedToValidators() {
        if (this.canBeConvertedToValidators == null) {
            this.canBeConvertedToValidators = new HashMap<String, SimpleValidator>();
        }
        return this.canBeConvertedToValidators;
    }

    @Override
    public JsonArrayValidationBuilderKey validation(SimpleValidator validator) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), validator);
    }

    @Override
    public JsonArrayValidationBuilderKey validationNotBlank() {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getNotBlankValidatorInfo());
    }

    @Override
    public JsonArrayValidationBuilderKey validationBlank() {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getBlankValidatorInfo());
    }

    @Override
    public JsonArrayValidationBuilderKey validationEmail() {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getEmailValidatorInfo());
    }

    @Override
    public JsonArrayValidationBuilderKey validationNull() {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getNullValidatorInfo());
    }

    @Override
    public JsonArrayValidationBuilderKey validationNotNull() {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getNotNullValidatorInfo());
    }

    @Override
    public JsonArrayValidationBuilderKey validationPattern(String pattern) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getPatternValidator(pattern));
    }

    @Override
    public JsonArrayValidationBuilderKey validationNotPattern(String pattern) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getNotPatternValidator(pattern));
    }

    @Override
    public JsonArrayValidationBuilderKey validationSize(int size, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getSizeValidator(size, ignoreNullValues));
    }

    @Override
    public JsonArrayValidationBuilderKey validationMinSize(int minSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getMinSizeValidator(minSize, ignoreNullValues));
    }

    @Override
    public JsonArrayValidationBuilderKey validationMaxSize(int maxSize, boolean ignoreNullValues) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getMaxSizeValidator(maxSize, ignoreNullValues));
    }

    @Override
    public JsonArrayValidationBuilderKey validationLength(int length) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getLengthValidator(length));
    }

    @Override
    public JsonArrayValidationBuilderKey validationMinLength(int minLength) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getMinLengthValidator(minLength));
    }

    @Override
    public JsonArrayValidationBuilderKey validationMaxLength(int maxLength) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getMaxLengthValidator(maxLength));
    }

    @Override
    public JsonArrayValidationBuilderKey validationEquivalent(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationNotEquivalent(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getNotEquivalentValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationLess(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getLessValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationGreater(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getGreaterValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationEquivalentOrLess(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentOrLessValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationEquivalentOrGreater(Object reference) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getEquivalentOrGreaterValidator(reference));
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeOrNull(Class<?> referenceType) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getIsOfTypeValidator(referenceType));
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeStringOrNull() {
        return this.validationIsOfTypeOrNull((Class)String.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeIntegerOrNull() {
        return this.validationIsOfTypeOrNull((Class)Integer.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeLongOrNull() {
        return this.validationIsOfTypeOrNull((Class)Long.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeFloatOrNull() {
        return this.validationIsOfTypeOrNull((Class)Float.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeDoubleOrNull() {
        return this.validationIsOfTypeOrNull((Class)Double.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeBooleanOrNull() {
        return this.validationIsOfTypeOrNull((Class)Boolean.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeBigDecimalOrNull() {
        return this.validationIsOfTypeOrNull((Class)BigDecimal.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeByteArrayOrNull(boolean acceptBase64StringToo) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getIsOfTypeByteArrayValidator(acceptBase64StringToo));
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeDateOrNull() {
        return this.validationIsOfTypeOrNull((Class)Date.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeJsonObjectOrNull() {
        return this.validationIsOfTypeOrNull((Class)JsonObject.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationIsOfTypeJsonArrayOrNull() {
        return this.validationIsOfTypeOrNull((Class)JsonArray.class);
    }

    @Override
    protected JsonArrayValidationBuilderKey validationCanBeConvertedTo(Class<?> referenceType) {
        return this.getValidationFactory().createJsonArrayValidationBuilderKey(this, this.getValidatedObject(), this.getCanBeConvertedToValidator(referenceType));
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToString() {
        return this.validationCanBeConvertedTo((Class)String.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToInteger() {
        return this.validationCanBeConvertedTo((Class)Integer.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToLong() {
        return this.validationCanBeConvertedTo((Class)Long.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToFloat() {
        return this.validationCanBeConvertedTo((Class)Float.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToBoolean() {
        return this.validationCanBeConvertedTo((Class)Boolean.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToDate() {
        return this.validationCanBeConvertedTo((Class)Date.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToDouble() {
        return this.validationCanBeConvertedTo((Class)Double.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToBigDecimal() {
        return this.validationCanBeConvertedTo((Class)BigDecimal.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToByteArray() {
        return this.validationCanBeConvertedTo((Class)byte[].class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToJsonObject() {
        return this.validationCanBeConvertedTo((Class)JsonObject.class);
    }

    @Override
    public JsonArrayValidationBuilderKey validationCanBeConvertedToJsonArray() {
        return this.validationCanBeConvertedTo((Class)JsonArray.class);
    }
}

