/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.routing.StaticResourceCacheConfig;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.config.ConfigFinder;
import org.spincast.plugins.config.SpincastConfigPluginConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastConfigDefault
extends ConfigFinder
implements SpincastConfig {
    public static final String ENVIRONMENT_NAME_DEFAULT = "local";
    private File spincastBaseWritableDir;
    private StaticResourceCacheConfig staticResourceCacheConfig;
    private StaticResourceCacheConfig dynamicResourceCacheConfig;
    private String publicServerSchemeHostPort;
    private URI publicUri;

    @Inject
    protected SpincastConfigDefault(SpincastConfigPluginConfig spincastConfigPluginConfig) {
        super(spincastConfigPluginConfig.getClasspathFilePath(), spincastConfigPluginConfig.getExternalFilePath(), spincastConfigPluginConfig.getEnvironmentVariablesPrefixes(), spincastConfigPluginConfig.isEnvironmentVariablesStripPrefix(), spincastConfigPluginConfig.getSystemPropertiesPrefixes(), spincastConfigPluginConfig.isSystemPropertiesStripPrefix(), spincastConfigPluginConfig.isExternalFileConfigsOverrideEnvironmentVariables(), spincastConfigPluginConfig.isThrowExceptionIfSpecifiedClasspathConfigFileIsNotFound(), spincastConfigPluginConfig.isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound());
    }

    @Inject
    protected void init() {
        this.getRawConfigs();
    }

    @Override
    public String getEnvironmentName() {
        return ENVIRONMENT_NAME_DEFAULT;
    }

    @Override
    public int getHttpServerPort() {
        return 44419;
    }

    @Override
    public int getHttpsServerPort() {
        return -1;
    }

    @Override
    public String getHttpsKeyStorePath() {
        return null;
    }

    @Override
    public String getHttpsKeyStoreType() {
        return null;
    }

    @Override
    public String getHttpsKeyStoreStorePass() {
        return null;
    }

    @Override
    public String getHttpsKeyStoreKeyPass() {
        return null;
    }

    protected URI getPublicURI() {
        if (this.publicUri == null) {
            try {
                this.publicUri = new URI(this.getPublicUrlBase());
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        return this.publicUri;
    }

    @Override
    public final String getPublicServerScheme() {
        return this.getPublicURI().getScheme();
    }

    @Override
    public final String getPublicServerHost() {
        return this.getPublicURI().getHost();
    }

    @Override
    public final int getPublicServerPort() {
        return this.getPublicURI().getPort();
    }

    @Override
    public String getPublicUrlBase() {
        if (this.publicServerSchemeHostPort == null) {
            StringBuilder builder = new StringBuilder();
            if (this.getHttpsServerPort() > -1) {
                builder.append("https://");
                builder.append(this.getHostForDefaultPublicServerSchemeHostPort());
                int port = this.getHttpsServerPort();
                if (port != 443) {
                    builder.append(":").append(port);
                }
            } else {
                builder.append("http://");
                builder.append(this.getHostForDefaultPublicServerSchemeHostPort());
                int port = this.getHttpServerPort();
                if (port != 80) {
                    builder.append(":").append(port);
                }
            }
            this.publicServerSchemeHostPort = builder.toString();
        }
        return this.publicServerSchemeHostPort;
    }

    protected String getHostForDefaultPublicServerSchemeHostPort() {
        String serverHost = this.getServerHost();
        if ("0.0.0.0".equals(serverHost)) {
            serverHost = "localhost";
        }
        return serverHost;
    }

    @Override
    public String getServerHost() {
        return "0.0.0.0";
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isRoutesCaseSensitive() {
        return false;
    }

    @Override
    public long getServerMaxRequestBodyBytes() {
        return 0x6400000L;
    }

    @Override
    public List<String> getContentTypesToSkipGziping() {
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("image/*");
        prefixes.add("video/*");
        prefixes.add("audio/*");
        prefixes.add("application/pdf");
        prefixes.add("application/octet-stream");
        prefixes.add("application/exe");
        prefixes.add("application/x-font-woff");
        prefixes.add("application/zip");
        prefixes.add("application/x-gzip");
        prefixes.add("application/x-rar-compressed");
        return prefixes;
    }

    @Override
    public File getSpincastWritableDir() {
        if (this.spincastBaseWritableDir == null) {
            File spincastDir;
            File baseDir = null;
            String path = this.getSpincastWritableDirPath();
            if (StringUtils.isBlank(path)) {
                baseDir = new File(System.getProperty("java.io.tmpdir"));
                if (!baseDir.isDirectory()) {
                    throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
                }
            } else {
                baseDir = new File(path);
                if (!baseDir.isAbsolute()) {
                    String relativePath = StringUtils.stripStart(path, "./\\");
                    File jarDir = this.getAppJarDirectory();
                    if (jarDir != null) {
                        baseDir = new File(jarDir.getAbsolutePath() + "/" + relativePath);
                    } else {
                        File noJarDir = this.getAppRootDirectoryNoJar();
                        if (noJarDir != null) {
                            baseDir = new File(noJarDir.getAbsolutePath() + "/" + relativePath);
                        }
                    }
                }
            }
            if (!(spincastDir = new File(baseDir, "spincast")).isDirectory()) {
                boolean result = spincastDir.mkdirs();
                if (!result) {
                    throw new RuntimeException("Unable to create the Spincast writable directory : " + spincastDir.getAbsolutePath());
                }
            } else {
                this.cleanWritableSpincastDir(spincastDir);
            }
            this.spincastBaseWritableDir = spincastDir;
        }
        return this.spincastBaseWritableDir;
    }

    protected String getSpincastWritableDirPath() {
        return null;
    }

    protected void cleanWritableSpincastDir(File spincastTempDir) {
        try {
            FileUtils.cleanDirectory(spincastTempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to clean the Spincast writable directory: " + spincastTempDir.getAbsolutePath());
        }
    }

    @Override
    public Locale getDefaultLocale() {
        return Locale.US;
    }

    @Override
    public int getRouteForwardingMaxNumber() {
        return 2;
    }

    @Override
    public int getDefaultRouteCacheFilterSecondsNbr() {
        return 3600;
    }

    @Override
    public boolean isDefaultRouteCacheFilterPrivate() {
        return false;
    }

    @Override
    public Integer getDefaultRouteCacheFilterSecondsNbrCdns() {
        return null;
    }

    @Override
    public boolean isWriteToDiskDynamicStaticResource() {
        return !this.isDebugEnabled();
    }

    @Override
    public boolean isAddDefaultTemplateVariablesFilter() {
        return true;
    }

    @Override
    public int getDefaultTemplateVariablesFilterPosition() {
        return -10;
    }

    @Override
    public StaticResourceCacheConfig getDefaultStaticResourceCacheConfig(boolean isDynamicResource) {
        if (this.staticResourceCacheConfig == null) {
            this.staticResourceCacheConfig = new StaticResourceCacheConfig(){

                @Override
                public int getCacheSeconds() {
                    return 86400;
                }

                @Override
                public boolean isCachePrivate() {
                    return false;
                }

                @Override
                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (this.dynamicResourceCacheConfig == null) {
            this.dynamicResourceCacheConfig = new StaticResourceCacheConfig(){

                @Override
                public int getCacheSeconds() {
                    return 3600;
                }

                @Override
                public boolean isCachePrivate() {
                    return false;
                }

                @Override
                public Integer getCacheSecondsCdn() {
                    return null;
                }
            };
        }
        if (isDynamicResource) {
            return this.dynamicResourceCacheConfig;
        }
        return this.staticResourceCacheConfig;
    }

    @Override
    public int getMaxNumberOfKeysWhenConvertingMapToJsonObject() {
        return 100;
    }

    @Override
    public int getKeyMaxLengthWhenConvertingMapToJsonObject() {
        return 512;
    }

    @Override
    public int getJsonPathArrayIndexMax() {
        return 10000;
    }

    @Override
    public boolean isValidateLocalhostHost() {
        return true;
    }

    @Override
    public boolean isEnableCookiesValidator() {
        return true;
    }

    @Override
    public String getQueryParamFlashMessageId() {
        return "spincast_flash";
    }

    @Override
    public String getCookieNameFlashMessage() {
        return "spincast_flash";
    }

    @Override
    public String getCookieNameLocale() {
        return "spincast_locale";
    }

    @Override
    public String getCookiesValidatorCookieName() {
        return "spincast_cookies_enabled";
    }

    @Override
    public String getSpincastModelRootVariableName() {
        return "spincast";
    }
}

