/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.server.Server;
import org.spincast.defaults.bootstrapping.Spincast;
import org.spincast.plugins.httpclient.SpincastHttpClientPlugin;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.controller.AppController;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.quickstart.exchange.AppRequestContextDefault;
import org.spincast.quickstart.exchange.AppRouter;
import org.spincast.quickstart.exchange.AppWebsocketContextDefault;
import org.spincast.quickstart.guice.AppModule;

public class App {
    protected final Logger logger = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        Spincast.configure().module(new AppModule()).plugin(new SpincastHttpClientPlugin()).requestContextImplementationClass(AppRequestContextDefault.class).websocketContextImplementationClass(AppWebsocketContextDefault.class).init(args);
    }

    @Inject
    protected void init(Server server, AppConfig config, AppRouter router, AppController appController, SpincastFilters<AppRequestContext> spincastFilters) {
        this.addRoutes(router, appController, spincastFilters);
        server.start();
        this.logger.info("Server started...");
        this.displayStartedMessage(config);
    }

    protected void addRoutes(AppRouter router, AppController ctrl, SpincastFilters<AppRequestContext> spincastFilters) {
        router.dir("/public").classpath("/public").save();
        router.file("/favicon.ico").classpath("/public/favicon.ico").save();
        router.file("/robots.txt").classpath("/public/robots.txt").save();
        router.file("/humans.txt").classpath("/public/humans.txt").save();
        router.file("/browserconfig.xml").classpath("/public/browserconfig.xml").save();
        router.file("/apple-touch-icon.png").classpath("/public/apple-touch-icon.png").save();
        router.file("/tile-wide.png").classpath("/public/tile-wide.png").save();
        router.file("/tile.png").classpath("/public/tile.png").save();
        router.ALL().pos(-10).save(spincastFilters::addSecurityHeaders);
        router.GET("/").cache(3600).save(ctrl::index);
        router.GET("/form").save(ctrl::formExample);
        router.GET("/exception-example").save(ctrl::exceptionExample);
        router.notFound(ctrl::notFound);
        router.exception(ctrl::exception);
    }

    protected void displayStartedMessage(AppConfig config) {
        String appName = config.getAppName();
        String publicUrlBase = config.getPublicUrlBase();
        System.out.println();
        System.out.println("==========================================");
        System.out.println(appName + " started!");
        System.out.println(publicUrlBase);
        System.out.println("==========================================");
    }
}

