/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.builders;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.json.JsonManager;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.XmlManager;
import org.spincast.plugins.httpclient.FileToUpload;
import org.spincast.plugins.httpclient.HttpResponseFactory;
import org.spincast.plugins.httpclient.SpincastHttpClientConfig;
import org.spincast.plugins.httpclient.builders.EntitySenderRequestBuilderBase;
import org.spincast.plugins.httpclient.builders.HttpRequestBuilderBase;
import org.spincast.plugins.httpclient.utils.SpincastHttpClientUtils;
import org.spincast.shaded.org.apache.http.HttpEntity;
import org.spincast.shaded.org.apache.http.NameValuePair;
import org.spincast.shaded.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.spincast.shaded.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.entity.StringEntity;
import org.spincast.shaded.org.apache.http.entity.mime.MultipartEntityBuilder;
import org.spincast.shaded.org.apache.http.message.BasicNameValuePair;

public abstract class EntitySenderRequestBuilderBaseDefault<T extends EntitySenderRequestBuilderBase<?>>
extends HttpRequestBuilderBase<T>
implements EntitySenderRequestBuilderBase<T> {
    protected final Logger logger = LoggerFactory.getLogger(EntitySenderRequestBuilderBaseDefault.class);
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private Map<String, List<String>> entityFormDatas;
    private List<FileToUpload> entityFileUploads;
    private HttpEntity entity;
    private EntityType entityType = null;

    public EntitySenderRequestBuilderBaseDefault(String url, CookieFactory cookieFactory, HttpResponseFactory spincastHttpResponseFactory, JsonManager jsonManager, XmlManager xmlManager, SpincastHttpClientUtils spincastHttpClientUtils, SpincastHttpClientConfig spincastHttpClientConfig) {
        super(url, cookieFactory, spincastHttpResponseFactory, spincastHttpClientUtils, spincastHttpClientConfig);
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
    }

    protected String getEntityStringEncoding() {
        return "UTF-8";
    }

    protected String getEntityFormDatasEncoding() {
        return "UTF-8";
    }

    protected EntityType getEntityType() {
        return this.entityType;
    }

    protected HttpEntity getEntity() {
        return this.entity;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected Map<String, List<String>> getEntityFormDatas() {
        if (this.entityFormDatas == null) {
            this.entityFormDatas = new HashMap<String, List<String>>();
        }
        return this.entityFormDatas;
    }

    protected List<FileToUpload> getEntityFileUploads() {
        if (this.entityFileUploads == null) {
            this.entityFileUploads = new ArrayList<FileToUpload>();
        }
        return this.entityFileUploads;
    }

    @Override
    public T addEntityFormDataValue(String name, String value) {
        Objects.requireNonNull(name, "The name can't be NULL");
        if (this.getEntityType() != null && this.getEntityType() != EntityType.FORM_DATAS) {
            this.logger.warn("There was already an entity of a different type set. It will be replaced.");
        }
        this.entityFileUploads = null;
        this.entity = null;
        this.entityType = EntityType.FORM_DATAS;
        Map<String, List<String>> params = this.getEntityFormDatas();
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            params.put(name, values);
        }
        values.add(value);
        EntitySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setEntityFormData(String name, List<String> values) {
        Objects.requireNonNull(name, "The name can't be NULL");
        if (this.getEntityType() != null && this.getEntityType() != EntityType.FORM_DATAS) {
            this.logger.warn("There was already an entity of a different type set. It will be replaced.");
        }
        this.entityFileUploads = null;
        this.entity = null;
        this.entityType = EntityType.FORM_DATAS;
        this.getEntityFormDatas().put(name, values);
        EntitySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setEntityFormDatas(Map<String, List<String>> formDatas) {
        if (this.getEntityType() != null && this.getEntityType() != EntityType.FORM_DATAS) {
            this.logger.warn("There was already an entity of a different type set. It will be replaced.");
        }
        this.entityFileUploads = null;
        this.entity = null;
        if (formDatas != null && formDatas.size() > 0) {
            this.entityType = EntityType.FORM_DATAS;
        }
        this.entityFormDatas = formDatas;
        EntitySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setEntityString(String entityString, String contentType) {
        Objects.requireNonNull(contentType, "The contentType can't be NULL");
        if (this.getEntity() != null || this.getEntityType() != null && this.getEntityType() != EntityType.HTTP_ENTITY) {
            this.logger.warn("There was already an entity set. It will be replaced.");
        }
        StringEntity stringEntity = new StringEntity(entityString, this.getEntityStringEncoding());
        stringEntity.setContentType(contentType);
        this.entityFormDatas = null;
        this.entityFileUploads = null;
        this.entity = stringEntity;
        this.entityType = EntityType.HTTP_ENTITY;
        EntitySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setEntityJson(Object object) {
        Objects.requireNonNull(object, "The object can't be NULL");
        String jsonString = this.getJsonManager().toJsonString(object);
        return this.setEntityString(jsonString, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset());
    }

    @Override
    public T setEntityXml(Object object) {
        Objects.requireNonNull(object, "The object can't be NULL");
        String xml = this.getXmlManager().toXml(object);
        return this.setEntityString(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset());
    }

    @Override
    public T setEntity(HttpEntity entity) {
        if (this.getEntity() != null || this.getEntityType() != null && this.getEntityType() != EntityType.HTTP_ENTITY) {
            this.logger.warn("There was already an entity set. It will be replaced.");
        }
        this.entityFormDatas = null;
        this.entityFileUploads = null;
        this.entity = entity;
        this.entityType = EntityType.HTTP_ENTITY;
        EntitySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T addEntityFileUpload(String path, String name) {
        return this.addEntityFileUpload(path, false, name);
    }

    @Override
    public T addEntityFileUpload(String path, boolean isClasspathPath, String name) {
        Objects.requireNonNull(path, "The path can't be NULL");
        if (this.getEntityType() != null && this.getEntityType() != EntityType.FILE_UPLOADS) {
            this.logger.warn("There was already an entity set. It will be replaced.");
        }
        this.entityFormDatas = null;
        this.entity = null;
        this.entityType = EntityType.FILE_UPLOADS;
        try {
            if (isClasspathPath) {
                URL resource = this.getClass().getClassLoader().getResource(path);
                if (resource == null) {
                    throw new RuntimeException("File to upload not found on the classpath: " + path);
                }
            } else if (!new File(path).isFile()) {
                throw new RuntimeException("File to upload not found on the file system: " + path);
            }
            FileToUpload fileToUpload = new FileToUpload(path, isClasspathPath, name);
            this.getEntityFileUploads().add(fileToUpload);
            EntitySenderRequestBuilderBaseDefault t = this;
            return (T)t;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected List<NameValuePair> convertToNameValuePair(Map<String, List<String>> params) {
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                String name = entry.getKey();
                if (entry.getValue() == null) continue;
                for (String value : entry.getValue()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(name, value);
                    nameValuePairList.add(nameValuePair);
                }
            }
        }
        return nameValuePairList;
    }

    @Override
    protected HttpRequestBase createMethodSpecificHttpRequest(String url) {
        HttpEntityEnclosingRequestBase request;
        block11: {
            request = this.getHttpEntityEnclosingRequestBase(url);
            try {
                if (this.getEntityType() == null) break block11;
                if (this.getEntityType() == EntityType.HTTP_ENTITY) {
                    if (this.getEntity() != null) {
                        request.setEntity(this.getEntity());
                    }
                    break block11;
                }
                if (this.getEntityType() == EntityType.FORM_DATAS) {
                    if (this.getEntityFormDatas() != null && this.getEntityFormDatas().size() > 0) {
                        request.setEntity(new UrlEncodedFormEntity(this.convertToNameValuePair(this.getEntityFormDatas()), this.getEntityFormDatasEncoding()));
                    }
                    break block11;
                }
                if (this.getEntityType() == EntityType.FILE_UPLOADS) {
                    if (this.getEntityFileUploads() != null && this.getEntityFileUploads().size() > 0) {
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        for (FileToUpload fileToUpload : this.getEntityFileUploads()) {
                            File file;
                            if (fileToUpload.isClasspathPath()) {
                                URL resource = this.getClass().getClassLoader().getResource(fileToUpload.getPath());
                                file = new File(resource.toURI());
                            } else {
                                file = new File(fileToUpload.getPath());
                            }
                            builder.addBinaryBody(fileToUpload.getName(), file);
                        }
                        request.setEntity(builder.build());
                    }
                    break block11;
                }
                throw new RuntimeException("Not managed: " + (Object)((Object)this.getEntityType()));
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        return request;
    }

    protected abstract HttpEntityEnclosingRequestBase getHttpEntityEnclosingRequestBase(String var1);

    protected static enum EntityType {
        HTTP_ENTITY,
        FORM_DATAS,
        FILE_UPLOADS;

    }
}

