/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.controllers;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.controllers.FrontController;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.dictionary.SpincastCoreDictionaryEntriesDefault;
import org.spincast.core.exceptions.CustomStatusCodeException;
import org.spincast.core.exceptions.ForwardRouteException;
import org.spincast.core.exceptions.NotFoundException;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.exceptions.RedirectException;
import org.spincast.core.exceptions.ResponseResetableException;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.exchange.RequestContextFactory;
import org.spincast.core.exchange.RequestContextType;
import org.spincast.core.guice.SpincastRequestScope;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.RouteHandlerMatch;
import org.spincast.core.routing.Router;
import org.spincast.core.routing.RoutingResult;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.server.Server;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.xml.XmlManager;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastFrontController<R extends RequestContext<R>, W extends WebsocketContext<?>>
implements FrontController {
    protected final Logger logger = LoggerFactory.getLogger(SpincastFrontController.class);
    private final Router<R, W> router;
    private final SpincastConfig spincastConfig;
    private final Dictionary dictionary;
    private final Server server;
    private final RequestContextFactory<R> requestCreationFactory;
    private final SpincastRequestScope spincastRequestScope;
    private final Type requestContextType;
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;

    @Inject
    public SpincastFrontController(Router<R, W> router, SpincastConfig spincastConfig, Dictionary dictionary, Server server, RequestContextFactory<R> requestCreationFactory, SpincastRequestScope spincastRequestScope, @RequestContextType Type requestContextType, JsonManager jsonManager, XmlManager xmlManager) {
        this.router = router;
        this.spincastConfig = spincastConfig;
        this.dictionary = dictionary;
        this.server = server;
        this.requestCreationFactory = requestCreationFactory;
        this.spincastRequestScope = spincastRequestScope;
        this.requestContextType = requestContextType;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Dictionary getDictionary() {
        return this.dictionary;
    }

    protected Server getServer() {
        return this.server;
    }

    protected RequestContextFactory<R> getRequestContextFactory() {
        return this.requestCreationFactory;
    }

    protected SpincastRequestScope getSpincastRequestScope() {
        return this.spincastRequestScope;
    }

    protected Type getRequestContextType() {
        return this.requestContextType;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Object exchange) {
        this.getSpincastRequestScope().enter();
        RequestContext requestContext = null;
        RoutingResult<Object> routingResult = null;
        try {
            exchange = this.validateExchange(exchange);
            requestContext = (RequestContext)this.getRequestContextFactory().createRequestContext(exchange);
            this.addDependenciesInCustomRequestScope(requestContext);
            routingResult = this.findRouteMatch(requestContext);
            if (routingResult == null) {
                routingResult = this.prepareNotFoundRouting(exchange, requestContext);
            }
            try {
                this.callRouteHandlers(requestContext, routingResult);
            }
            catch (NotFoundException notFoundException) {
                if (notFoundException.isResetResponse()) {
                    this.resetResponse(requestContext);
                }
                routingResult = this.prepareNotFoundRouting(exchange, requestContext);
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE, notFoundException.getMessage());
                this.callRouteHandlers(requestContext, routingResult);
            }
        }
        catch (Throwable ex) {
            this.logger.debug("An exception occured! The exception routing process will be triggered : " + ex.getMessage());
            try {
                if (requestContext == null) {
                    throw ex;
                }
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.IS_EXCEPTION_HANDLING, true);
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, false);
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.EXCEPTION, ex);
                if (!(ex instanceof ResponseResetableException) || ((ResponseResetableException)((Object)ex)).isResetResponse()) {
                    this.resetResponse(requestContext);
                }
                if (ex instanceof CustomStatusCodeException) {
                    requestContext.response().setStatusCode(((CustomStatusCodeException)((Object)ex)).getStatusCode());
                } else {
                    requestContext.response().setStatusCode(500);
                }
                this.customExceptionHandling(ex, requestContext, routingResult);
            }
            catch (Throwable ex2) {
                try {
                    this.defaultExceptionHandling(exchange, ex2);
                }
                catch (Throwable ex3) {
                    this.lastResortExceptionHandling(ex, ex3);
                }
            }
        }
        finally {
            try {
                this.getSpincastRequestScope().exit();
            }
            catch (Throwable ex) {
                try {
                    this.logger.error("Error while exiting custom Guice scope : " + SpincastStatics.getStackTrace(ex));
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected RoutingResult<R> prepareNotFoundRouting(Object exchange, R requestContext) {
        return this.prepareNotFoundRouting(exchange, requestContext, false);
    }

    protected RoutingResult<R> prepareNotFoundRouting(Object exchange, R requestContext, boolean alreadyTried) {
        RoutingResult<R> routingResult = this.getRouter().route(requestContext, RoutingType.NOT_FOUND);
        if (routingResult == null) {
            if (alreadyTried) {
                throw new RuntimeException("The method prepareNotFoundRouting was already tried, we called addDefaultNotFoundRoute() but there's still no Not Found route!! Full url: " + this.getServer().getFullUrlOriginal(exchange));
            }
            this.addDefaultNotFoundRoute();
            return this.prepareNotFoundRouting(exchange, requestContext, true);
        }
        requestContext.variables().set(SpincastConstants.RequestScopedVariables.IS_NOT_FOUND_ROUTE, true);
        requestContext.response().setStatusCode(404);
        return routingResult;
    }

    protected void addDefaultNotFoundRoute() {
        this.getRouter().ALL("/*{path}").notFound().handle(this.getDefaultNotFoundHandler());
    }

    protected Handler<R> getDefaultNotFoundHandler() {
        Handler handler = new Handler<R>(){

            @Override
            public void handle(R context) {
                String message = SpincastFrontController.this.getDefaultNotFoundHandlerNotFoundMessage();
                String customMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
                if (!StringUtils.isBlank(customMessage)) {
                    message = customMessage;
                }
                context.response().setStatusCode(404);
                if (context.request().isJsonShouldBeReturn()) {
                    context.response().sendJson(SpincastFrontController.this.getNotFoundJsonContent(message));
                } else if (context.request().isXMLShouldBeReturn()) {
                    context.response().sendXml(SpincastFrontController.this.getNotFoundXmlContent(message));
                } else if (context.request().isHTMLShouldBeReturn()) {
                    String html = SpincastFrontController.this.getNotFoundHtmlContent(message);
                    context.response().sendHtml(html);
                } else {
                    if (!context.request().isPlainTextShouldBeReturn()) {
                        SpincastFrontController.this.logger.error("Format not managed here!: " + (Object)((Object)context.request().getContentTypeBestMatch()));
                    }
                    context.response().sendPlainText(SpincastFrontController.this.getNotFoundPlainTextContent(message));
                }
            }
        };
        return handler;
    }

    protected String getNotFoundHtmlContent(String message) {
        return "<pre>" + message + "</pre>";
    }

    protected String getNotFoundJsonContent(String message) {
        JsonObject jsonObj = this.getJsonManager().create();
        jsonObj.set("error", message);
        return jsonObj.toJsonString();
    }

    protected String getNotFoundXmlContent(String message) {
        JsonObject jsonObj = this.getJsonManager().create();
        jsonObj.set("error", message);
        return this.getXmlManager().toXml(jsonObj);
    }

    protected String getNotFoundPlainTextContent(String message) {
        return message;
    }

    protected String getDefaultNotFoundHandlerNotFoundMessage() {
        return this.getDictionary().get(SpincastCoreDictionaryEntriesDefault.MESSAGE_KEY_ROUTE_NOT_FOUND_DEFAULTMESSAGE);
    }

    protected void resetResponse(R requestContext) {
        if (requestContext != null && !requestContext.response().isHeadersSent()) {
            requestContext.response().resetEverything();
        }
    }

    protected void customExceptionHandling(Throwable ex, R requestContext, RoutingResult<R> originalRoutingResult) throws Throwable {
        try {
            RoutingResult<R> exceptionRoutingResult = this.getRouter().route(requestContext, RoutingType.EXCEPTION);
            if (exceptionRoutingResult != null) {
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.ROUTING_RESULT, exceptionRoutingResult);
                requestContext.variables().set(SpincastConstants.RequestScopedVariables.ORIGINAL_ROUTING_RESULT, originalRoutingResult);
                this.callRouteHandlers(requestContext, exceptionRoutingResult);
                return;
            }
        }
        catch (Throwable ex2) {
            try {
                this.logger.error("An exception occured while using the custom exception handler. The original exception will be thrown again so it can be managed by the default exception handler. The exception which occured is : " + SpincastStatics.getStackTrace(ex2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw ex;
    }

    protected void addDependenciesInCustomRequestScope(R requestContext) {
        this.addRequestContextInCustomRequestScope(requestContext);
    }

    protected void addRequestContextInCustomRequestScope(R requestContext) {
        Key<Object> key = Key.get(new TypeLiteral<RequestContext<?>>(){});
        this.getSpincastRequestScope().seed(key, requestContext);
        key = Key.get(this.getRequestContextType());
        this.getSpincastRequestScope().seed(key, requestContext);
    }

    protected void callRouteHandlers(R requestContext, RoutingResult<R> routingResult) throws Exception {
        requestContext.variables().set(SpincastConstants.RequestScopedVariables.ROUTING_RESULT, routingResult);
        List<RouteHandlerMatch<R>> routeHandlerMatches = routingResult.getRouteHandlerMatches();
        block4: for (int i = 0; i < routeHandlerMatches.size(); ++i) {
            RouteHandlerMatch<R> routeHandlerMatch = routeHandlerMatches.get(i);
            requestContext.variables().set(SpincastConstants.RequestScopedVariables.ROUTE_HANDLER_MATCH, routeHandlerMatch);
            Handler<R> handlerMethod = routeHandlerMatch.getHandler();
            try {
                handlerMethod.handle(requestContext);
                continue;
            }
            catch (ForwardRouteException ex) {
                this.manageForwardRouteException(ex, requestContext, routingResult);
                return;
            }
            catch (RedirectException ex) {
                this.manageRedirectException(ex, requestContext, routingResult);
                while (i < routeHandlerMatches.size()) {
                    routeHandlerMatch = routeHandlerMatches.get(i);
                    if (routeHandlerMatch.getPosition() > 0) {
                        --i;
                        continue block4;
                    }
                    ++i;
                }
                continue;
            }
            catch (SkipRemainingHandlersException ex) {
                break;
            }
        }
        if (!requestContext.response().isClosed()) {
            requestContext.response().end();
        }
    }

    protected void manageRedirectException(RedirectException ex, R context, RoutingResult<R> routingResult) {
        if (context.response().isHeadersSent()) {
            this.logger.error("Headers already sent, we can't sent redirection headers!");
        } else {
            context.response().resetEverything(false);
            if (ex.getFlashMessage() != null) {
                context.response().redirect(ex.getNewUrl(), ex.isRedirectPermanently(), ex.getFlashMessage());
            } else if (ex.getFlashMessageType() != null && ex.getFlashMessageText() != null) {
                context.response().redirect(ex.getNewUrl(), ex.isRedirectPermanently(), ex.getFlashMessageType(), ex.getFlashMessageText(), ex.getFlashMessageVariables());
            } else {
                context.response().redirect(ex.getNewUrl(), ex.isRedirectPermanently());
            }
        }
        context.response().flush(true);
    }

    protected void manageForwardRouteException(ForwardRouteException ex, R context, RoutingResult<R> originalRoutingResult) throws Exception {
        Integer nbrTimeForwarded = context.variables().get(SpincastConstants.RequestScopedVariables.ROUTE_FORWARDED_NBR, Integer.class);
        if (nbrTimeForwarded == null) {
            nbrTimeForwarded = 1;
        } else {
            Integer n = nbrTimeForwarded;
            Integer n2 = nbrTimeForwarded = Integer.valueOf(nbrTimeForwarded + 1);
        }
        if (nbrTimeForwarded > this.getSpincastConfig().getRouteForwardingMaxNumber()) {
            throw new RuntimeException("The maximum number of request forwarding has been reached : " + this.getSpincastConfig().getRouteForwardingMaxNumber() + ".This route won't be called : " + ex.getNewRoute());
        }
        context.variables().set(SpincastConstants.RequestScopedVariables.ROUTE_FORWARDED_NBR, nbrTimeForwarded);
        if (ex.isResetResponse()) {
            if (!context.response().isHeadersSent()) {
                context.response().resetEverything();
            } else {
                this.logger.warn("The response headers have already been sent, we can't reset the response...");
            }
        }
        context = this.createForwardedRequestContext(context, ex.getNewRoute());
        RoutingResult<R> routingResult = this.getRouter().route(context);
        if (routingResult == null) {
            this.logger.warn("A route forwarding was asked but the requested route doesn't have any match : " + ex.getNewRoute());
            throw new NotFoundException(false);
        }
        context.variables().set(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_EXCEPTION_MESSAGE, ex.getMessage());
        this.callRouteHandlers(context, routingResult);
    }

    protected R createForwardedRequestContext(R context, String fullUrlOrRelativePathAndQueryString) {
        try {
            if (fullUrlOrRelativePathAndQueryString == null) {
                fullUrlOrRelativePathAndQueryString = "/";
            } else if ((fullUrlOrRelativePathAndQueryString = fullUrlOrRelativePathAndQueryString.trim()).startsWith("//")) {
                fullUrlOrRelativePathAndQueryString = fullUrlOrRelativePathAndQueryString.substring(1);
            }
            String newFullUrl = fullUrlOrRelativePathAndQueryString;
            URI uri = new URI(fullUrlOrRelativePathAndQueryString);
            if (!uri.isAbsolute()) {
                if (!fullUrlOrRelativePathAndQueryString.startsWith("/")) {
                    fullUrlOrRelativePathAndQueryString = "/" + fullUrlOrRelativePathAndQueryString;
                }
                String oldFullUrlStr = context.request().getFullUrl();
                URL oldFullUrl = new URL(oldFullUrlStr);
                newFullUrl = oldFullUrl.getProtocol() + "://" + oldFullUrl.getHost() + ":" + oldFullUrl.getPort() + fullUrlOrRelativePathAndQueryString;
            }
            context.variables().set(SpincastConstants.RequestScopedVariables.FORWARD_ROUTE_URL, newFullUrl);
            return context;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected Object validateExchange(Object exchange) {
        Objects.requireNonNull(exchange, "The exchange object can't be NULL.");
        return exchange;
    }

    protected RoutingResult<R> findRouteMatch(R requestContext) {
        return this.getRouter().route(requestContext);
    }

    protected void defaultExceptionHandling(Object exchange, Throwable ex) throws Throwable {
        if (ex instanceof PublicException) {
            this.defaultPublicExceptionHandling(exchange, (PublicException)((Object)ex));
        } else {
            this.defaultPrivateExceptionHandling(exchange, ex);
        }
    }

    protected void defaultPublicExceptionHandling(Object exchange, PublicException publicException) throws Throwable {
        if (this.getServer().isResponseHeadersSent(exchange)) {
            this.logger.info("Can't sent proper public error response, headers are already sent :\n" + SpincastStatics.getStackTrace((Throwable)((Object)publicException)));
            return;
        }
        String errorMessage = ((Throwable)((Object)publicException)).getMessage();
        if (this.getSpincastConfig().isDebugEnabled()) {
            errorMessage = errorMessage + "\n\nDebug info :\n\n" + SpincastStatics.getStackTrace((Throwable)((Object)publicException));
        }
        this.sendErrorUsingBestMatchContentType(exchange, errorMessage, publicException.getStatusCode());
    }

    protected void defaultPrivateExceptionHandling(Object exchange, Throwable exception) throws Throwable {
        this.logger.error(SpincastStatics.getStackTrace(exception));
        if (this.getServer().isResponseHeadersSent(exchange)) {
            this.logger.info("Can't sent proper error response, headers are already sent :\n" + SpincastStatics.getStackTrace(exception));
            return;
        }
        String errorMessage = this.getDictionary().get(SpincastCoreDictionaryEntriesDefault.MESSAGE_KEY_EXCEPTION_DEFAULTMESSAGE);
        if (this.getSpincastConfig().isDebugEnabled()) {
            errorMessage = errorMessage + "\n\nDebug info :\n\n" + SpincastStatics.getStackTrace(exception);
        }
        int statusCode = 500;
        if (exception instanceof CustomStatusCodeException) {
            statusCode = ((CustomStatusCodeException)((Object)exception)).getStatusCode();
        }
        this.sendErrorUsingBestMatchContentType(exchange, errorMessage, statusCode);
    }

    protected void sendErrorUsingBestMatchContentType(Object exchange, String errorMessage, Integer statusCode) throws Throwable {
        ContentTypeDefaults type;
        if (statusCode == null) {
            statusCode = 500;
        }
        if ((type = this.getResponseContentTypeToUse(exchange)) == ContentTypeDefaults.JSON) {
            errorMessage = this.getInternalErrorJsonContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.XML) {
            errorMessage = this.getInternalErrorXmlContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.XML.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.HTML) {
            errorMessage = this.getInternalErrorHtmlContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset()));
        } else if (type == ContentTypeDefaults.TEXT) {
            errorMessage = this.getInternalErrorTextContent(errorMessage);
            this.getServer().setResponseHeader(exchange, "Content-Type", Arrays.asList(ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset()));
        } else {
            throw new RuntimeException("Not implemented : " + (Object)((Object)type));
        }
        byte[] errorMessageBytes = errorMessage.getBytes(this.getDefaultExceptionHandlingCharset());
        this.getServer().setResponseStatusCode(exchange, statusCode);
        this.getServer().setResponseHeader(exchange, "Content-Length", Arrays.asList("" + errorMessageBytes.length));
        this.getServer().flushBytes(exchange, errorMessageBytes, true);
    }

    protected String getDefaultExceptionHandlingCharset() {
        return "UTF-8";
    }

    protected String getInternalErrorJsonContent(String errorMessage) {
        JsonObject jsonObject = this.getJsonManager().create();
        jsonObject.set("error", errorMessage);
        return jsonObject.toJsonString();
    }

    protected String getInternalErrorXmlContent(String errorMessage) {
        JsonObject jsonObject = this.getJsonManager().create();
        jsonObject.set("error", errorMessage);
        return this.getXmlManager().toXml(jsonObject);
    }

    protected String getInternalErrorHtmlContent(String errorMessage) {
        return "<pre>" + errorMessage + "</pre>";
    }

    protected String getInternalErrorTextContent(String errorMessage) {
        return errorMessage;
    }

    protected ContentTypeDefaults getResponseContentTypeToUse(Object exchange) {
        try {
            return this.getServer().getContentTypeBestMatch(exchange);
        }
        catch (Exception ex) {
            return ContentTypeDefaults.TEXT;
        }
    }

    protected void lastResortExceptionHandling(Throwable originalException, Throwable defaultHandlingException) {
        try {
            this.logger.error("Error while trying to use the default exception handling : " + defaultHandlingException.getMessage() + ".\nThe original exception was : " + SpincastStatics.getStackTrace(originalException));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new RuntimeException("An error occured.");
    }
}

