/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.templatingaddon;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.locale.ILocaleResolver;
import org.spincast.core.templating.ITemplatingEngine;
import org.spincast.core.templating.ITemplatingRequestContextAddon;

public class SpincastTemplatingRequestContextAddon<R extends IRequestContext<?>>
implements ITemplatingRequestContextAddon<R> {
    private final R requestContext;
    private final ITemplatingEngine templatingEngine;
    private final ILocaleResolver localeResolver;
    private Map<String, Object> templatingGlobalVariables;

    @Inject
    public SpincastTemplatingRequestContextAddon(R requestContext, ITemplatingEngine templatingEngine, ILocaleResolver localeResolver) {
        this.requestContext = requestContext;
        this.templatingEngine = templatingEngine;
        this.localeResolver = localeResolver;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected ITemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    protected ILocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    protected Locale getLocaleToUse() {
        return this.getLocaleResolver().getLocaleToUse();
    }

    @Override
    public Map<String, Object> getTemplatingGlobalVariables() {
        if (this.templatingGlobalVariables == null) {
            this.templatingGlobalVariables = new HashMap<String, Object>();
        }
        return this.templatingGlobalVariables;
    }

    @Override
    public String evaluate(String content, Map<String, Object> params) {
        return this.evaluate(content, params, this.getLocaleToUse());
    }

    @Override
    public String evaluate(String content, Map<String, Object> params, Locale locale) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.putAll(this.getTemplatingGlobalVariables());
        return this.getTemplatingEngine().evaluate(content, params, locale);
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params) {
        return this.fromTemplate(templatePath, params, this.getLocaleToUse());
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params, Locale locale) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.putAll(this.getTemplatingGlobalVariables());
        return this.getTemplatingEngine().fromTemplate(templatePath, params, locale);
    }

    @Override
    public void addTemplatingGlobalVariable(String key, Object value) {
        this.getTemplatingGlobalVariables().put(key, value);
    }

    @Override
    public void addTemplatingGlobalVariables(Map<String, Object> variables) {
        this.getTemplatingGlobalVariables().putAll(variables);
    }

    @Override
    public Object getTemplatingGlobalVariable(String key) {
        return this.getTemplatingGlobalVariables().get(key);
    }

    @Override
    public void deleteAllTemplatingGlobalVariables() {
        this.getTemplatingGlobalVariables().clear();
    }

    @Override
    public void deleteTemplatingGlobalVariable(String key) {
        this.getTemplatingGlobalVariables().remove(key);
    }
}

