/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.builders;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.httpclient.HttpRequestBuilder;
import org.spincast.plugins.httpclient.HttpResponse;
import org.spincast.plugins.httpclient.HttpResponseFactory;
import org.spincast.plugins.httpclient.SpincastHttpClientConfig;
import org.spincast.plugins.httpclient.builders.SpincastHttpRequestExecutor;
import org.spincast.plugins.httpclient.utils.SpincastHttpClientUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.Header;
import org.spincast.shaded.org.apache.http.HttpEntity;
import org.spincast.shaded.org.apache.http.auth.AuthScope;
import org.spincast.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import org.spincast.shaded.org.apache.http.client.CookieStore;
import org.spincast.shaded.org.apache.http.client.HttpClient;
import org.spincast.shaded.org.apache.http.client.config.RequestConfig;
import org.spincast.shaded.org.apache.http.client.entity.DecompressingEntity;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.spincast.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.spincast.shaded.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.spincast.shaded.org.apache.http.impl.client.BasicCookieStore;
import org.spincast.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import org.spincast.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.spincast.shaded.org.apache.http.impl.cookie.BasicClientCookie;
import org.spincast.shaded.org.apache.http.protocol.HttpRequestExecutor;
import org.spincast.shaded.org.apache.http.ssl.SSLContexts;
import org.spincast.shaded.org.apache.http.util.EntityUtils;

public abstract class HttpRequestBuilderBase<T extends HttpRequestBuilder<?>>
implements HttpRequestBuilder<T> {
    private final CookieFactory cookieFactory;
    private final HttpResponseFactory spincastHttpResponseFactory;
    private final SpincastHttpClientUtils spincastHttpClientUtils;
    private final SpincastHttpClientConfig spincastHttpClientConfig;
    private String url;
    private HttpClient httpClient;
    private Map<String, List<String>> headers;
    private RequestConfig requestConfig;
    private CookieStore cookieStore;
    private HttpClientBuilder httpClientBuilder;
    private boolean disableSslCertificateErrors = false;
    private String httpAuthUsername;
    private String httpAuthPassword;

    public HttpRequestBuilderBase(String url, CookieFactory cookieFactory, HttpResponseFactory spincastHttpResponseFactory, SpincastHttpClientUtils spincastHttpClientUtils, SpincastHttpClientConfig spincastHttpClientConfig) {
        this.url = url;
        this.cookieFactory = cookieFactory;
        this.spincastHttpResponseFactory = spincastHttpResponseFactory;
        this.spincastHttpClientUtils = spincastHttpClientUtils;
        this.spincastHttpClientConfig = spincastHttpClientConfig;
    }

    protected HttpResponseFactory getSpincastHttpResponseFactory() {
        return this.spincastHttpResponseFactory;
    }

    protected boolean isDisableSslCertificateErrors() {
        return this.disableSslCertificateErrors;
    }

    protected SpincastHttpClientUtils getSpincastHttpClientUtils() {
        return this.spincastHttpClientUtils;
    }

    protected SpincastHttpClientConfig getSpincastHttpClientConfig() {
        return this.spincastHttpClientConfig;
    }

    protected HttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = this.getHttpClientBuilder();
        return httpClientBuilder.build();
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        if (this.httpClientBuilder == null) {
            this.httpClientBuilder = this.createHttpClientBuilder();
        }
        this.httpClientBuilder.setRequestExecutor(this.getHttpRequestExecutor());
        this.httpClientBuilder.setDefaultCookieStore(this.getCookieStore());
        if (this.isDisableSslCertificateErrors()) {
            try {
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, (HostnameVerifier)new NoopHostnameVerifier());
                this.httpClientBuilder.setSSLSocketFactory(sslsf);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        if (!StringUtils.isBlank(this.getHttpAuthUsername())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(this.getHttpAuthUsername(), this.getHttpAuthPassword()));
            this.httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        return this.httpClientBuilder;
    }

    protected HttpRequestExecutor getHttpRequestExecutor() {
        return new SpincastHttpRequestExecutor();
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        return HttpClientBuilder.create();
    }

    @Override
    public T setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        if (httpClientBuilder != null) {
            try {
                Field cookieStoreField = httpClientBuilder.getClass().getDeclaredField("cookieStore");
                cookieStoreField.setAccessible(true);
                CookieStore cookieStore = (CookieStore)cookieStoreField.get(httpClientBuilder);
                if (cookieStore != null) {
                    this.setCookieStore(cookieStore);
                }
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T disableSslCertificateErrors() {
        this.disableSslCertificateErrors = true;
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    protected void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    protected HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected String getUrl() {
        return this.url;
    }

    protected CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = new BasicCookieStore();
        }
        return this.cookieStore;
    }

    @Override
    public T setCookie(String name, String value) {
        return this.setCookie(name, value, true);
    }

    @Override
    public T setCookie(String name, String value, boolean secure) {
        Objects.requireNonNull(name, "The name can't be NULL");
        Cookie cookie = this.getCookieFactory().createCookie(name, value);
        cookie.setSecure(secure);
        return this.setCookie(cookie);
    }

    @Override
    public T setCookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "The cookie can't be NULL");
        return this.setCookies(Lists.newArrayList(cookie));
    }

    @Override
    public T setCookies(Collection<Cookie> cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null) continue;
                org.spincast.shaded.org.apache.http.cookie.Cookie apacheCookie = this.convertToApacheCookie(cookie);
                this.getCookieStore().addCookie(apacheCookie);
            }
        }
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    protected org.spincast.shaded.org.apache.http.cookie.Cookie convertToApacheCookie(Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        BasicClientCookie apacheCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        apacheCookie.setDomain(cookie.getDomain());
        apacheCookie.setPath(cookie.getPath());
        apacheCookie.setVersion(cookie.getVersion());
        apacheCookie.setSecure(cookie.isSecure());
        apacheCookie.setExpiryDate(cookie.getExpires());
        return apacheCookie;
    }

    @Override
    public T setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T addHeaderValue(String key, String value) {
        return this.addHeaderValues(key, Lists.newArrayList(value));
    }

    @Override
    public T addHeaderValues(String key, List<String> values) {
        Objects.requireNonNull(key, "The key can't be NULL");
        List<String> currentValues = this.getHeaders().get(key);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(key, currentValues);
        }
        currentValues.addAll(values);
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    @Override
    public T setHeaderValues(String key, List<String> values) {
        Objects.requireNonNull(key, "The key can't be NULL");
        this.getHeaders().put(key, values);
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    protected Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        return this.headers;
    }

    @Override
    public T addJsonAcceptHeader() {
        return this.addHeaderValue("Accept", ContentTypeDefaults.JSON.getMainVariation());
    }

    @Override
    public T addXMLAcceptHeader() {
        return this.addHeaderValue("Accept", ContentTypeDefaults.XML.getMainVariation());
    }

    @Override
    public T addHTMLAcceptHeader() {
        return this.addHeaderValue("Accept", ContentTypeDefaults.HTML.getMainVariation());
    }

    @Override
    public T addPlainTextAcceptHeader() {
        return this.addHeaderValue("Accept", ContentTypeDefaults.TEXT.getMainVariation());
    }

    @Override
    public T setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    protected RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    protected String getCookieEncoding() {
        return "UTF-8";
    }

    @Override
    public T setHttpAuthCredentials(String username, String password) {
        this.httpAuthUsername = username;
        this.httpAuthPassword = password;
        HttpRequestBuilderBase t = this;
        return (T)t;
    }

    protected String getHttpAuthUsername() {
        return this.httpAuthUsername;
    }

    protected String getHttpAuthPassword() {
        return this.httpAuthPassword;
    }

    protected org.spincast.shaded.org.apache.http.HttpResponse sendGetRawResponse() {
        try {
            RequestConfig requestConfig = this.getRequestConfig();
            if (requestConfig == null) {
                requestConfig = RequestConfig.copy(RequestConfig.DEFAULT).setCookieSpec("standard").build();
            }
            String url = this.getUrl();
            HttpRequestBase request = this.createMethodSpecificHttpRequest(url);
            if (requestConfig != null) {
                request.setConfig(requestConfig);
            }
            for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
                String key = entry.getKey();
                for (String value : entry.getValue()) {
                    request.addHeader(key, value);
                }
            }
            return this.getHttpClient().execute(request);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse send() {
        HttpResponse httpResponse;
        org.spincast.shaded.org.apache.http.HttpResponse response = this.sendGetRawResponse();
        try {
            Header[] allHeaders;
            HttpEntity entity;
            byte[] content = null;
            int status = response.getStatusLine().getStatusCode();
            String contentType = null;
            Header contentTypeHeader = response.getFirstHeader("Content-Type");
            if (contentTypeHeader != null) {
                contentType = contentTypeHeader.getValue();
            }
            if ((entity = response.getEntity()) != null) {
                content = EntityUtils.toByteArray(entity);
            }
            boolean wasZipped = entity instanceof DecompressingEntity;
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            for (Header header : allHeaders = response.getAllHeaders()) {
                ArrayList<String> vals = (ArrayList<String>)responseHeaders.get(header.getName());
                if (vals == null) {
                    vals = new ArrayList<String>();
                    responseHeaders.put(header.getName(), vals);
                }
                vals.add(header.getValue());
            }
            HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
            CookieStore cookieStore = this.getCookieStore();
            if (cookieStore != null) {
                List<org.spincast.shaded.org.apache.http.cookie.Cookie> responseCookies = cookieStore.getCookies();
                for (org.spincast.shaded.org.apache.http.cookie.Cookie responseCookie : responseCookies) {
                    String name = responseCookie.getName();
                    String value = responseCookie.getValue();
                    if (value != null) {
                        try {
                            name = URLDecoder.decode(name, this.getCookieEncoding());
                            value = URLDecoder.decode(value, this.getCookieEncoding());
                        }
                        catch (Exception ex) {
                            throw SpincastStatics.runtimize(ex);
                        }
                    }
                    Cookie cookie = this.getCookieFactory().createCookie(name, value, responseCookie.getPath(), responseCookie.getDomain(), responseCookie.getExpiryDate(), responseCookie.isSecure(), false, null, !responseCookie.isPersistent(), responseCookie.getVersion());
                    cookies.put(cookie.getName(), cookie);
                }
            }
            httpResponse = this.getSpincastHttpResponseFactory().create(status, contentType, content, responseHeaders, cookies, wasZipped);
        }
        catch (Throwable throwable) {
            try {
                EntityUtils.consumeQuietly(response.getEntity());
                throw throwable;
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        EntityUtils.consumeQuietly(response.getEntity());
        return httpResponse;
    }

    protected abstract HttpRequestBase createMethodSpecificHttpRequest(String var1);
}

