/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class GatedStreamSinkChannel
implements StreamSinkChannel {
    private final StreamSinkChannel delegate;
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> writeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener.SimpleSetter<GatedStreamSinkChannel> closeSetter = new ChannelListener.SimpleSetter();
    private int state;
    private static final int FLAG_GATE_OPEN = 1;
    private static final int FLAG_WRITES_RESUMED = 2;
    private static final int FLAG_CLOSE_REQUESTED = 4;
    private static final int FLAG_CLOSED = 8;

    public GatedStreamSinkChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    public void openGate() throws IOException {
        int val = this.state;
        if (Bits.allAreSet(val, 1)) {
            return;
        }
        this.state |= 1;
        if (Bits.allAreSet(val, 8)) {
            this.delegate.close();
        } else {
            if (Bits.allAreSet(val, 4)) {
                this.delegate.shutdownWrites();
            }
            if (Bits.allAreSet(val, 2)) {
                this.delegate.wakeupWrites();
            }
        }
    }

    public boolean isGateOpen() {
        return Bits.allAreSet(this.state, 1);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        if (this.handleGate()) {
            return 0;
        }
        return this.delegate.writeFinal(src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.writeFinal(srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.writeFinal(srcs);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.handleGate()) {
            return 0;
        }
        return this.delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.write(srcs, offset, length);
    }

    private boolean handleGate() throws ClosedChannelException {
        int val = this.state;
        if (Bits.anyAreSet(val, 4)) {
            throw new ClosedChannelException();
        }
        return Bits.anyAreClear(val, 1);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (this.handleGate()) {
            return 0L;
        }
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    @Override
    public boolean flush() throws IOException {
        if (Bits.anyAreClear(this.state, 1)) {
            return false;
        }
        if (Bits.anyAreSet(this.state, 8)) {
            throw new ClosedChannelException();
        }
        if (Bits.anyAreSet(this.state, 4)) {
            boolean result = this.delegate.flush();
            if (result) {
                this.state |= 8;
            }
            return result;
        }
        return this.delegate.flush();
    }

    @Override
    public void suspendWrites() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.suspendWrites();
        } else {
            this.state &= 0xFFFFFFFD;
        }
    }

    @Override
    public void resumeWrites() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.resumeWrites();
        } else {
            this.state |= 2;
        }
    }

    @Override
    public boolean isWriteResumed() {
        if (Bits.anyAreSet(this.state, 1)) {
            return this.delegate.isWriteResumed();
        }
        return Bits.anyAreSet(this.state, 2);
    }

    @Override
    public void wakeupWrites() {
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.wakeupWrites();
        } else {
            this.state |= 2;
            this.getIoThread().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelListeners.invokeChannelListener(GatedStreamSinkChannel.this, GatedStreamSinkChannel.this.writeSetter.get());
                }
            });
        }
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.state |= 4;
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.shutdownWrites();
        }
    }

    @Override
    public void close() throws IOException {
        if (Bits.allAreSet(this.state, 8)) {
            return;
        }
        this.state |= 8;
        if (Bits.anyAreSet(this.state, 1)) {
            this.delegate.close();
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        if (Bits.allAreClear(this.state, 1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.allAreClear(this.state, 1)) {
            throw new IllegalStateException();
        }
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 8);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return false;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return null;
    }

    public StreamSinkChannel getChannel() {
        return Bits.allAreSet(this.state, 1) ? this.delegate : this;
    }
}

