/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.IOException;
import java.net.URL;

public class FileClassPathResourceManager
implements ResourceManager {
    private final String filePath;

    public FileClassPathResourceManager(String filePath) {
        this.filePath = filePath;
    }

    protected String getFilePath() {
        return this.filePath;
    }

    @Override
    public Resource getResource(String path) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(this.getFilePath());
        if (resource == null) {
            return null;
        }
        return new URLResource(resource, resource.openConnection(), this.getFilePath());
    }

    @Override
    public boolean isResourceChangeListenerSupported() {
        return false;
    }

    @Override
    public void registerResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void removeResourceChangeListener(ResourceChangeListener listener) {
        throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
    }

    @Override
    public void close() throws IOException {
    }
}

