/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.utils;

import java.util.ArrayList;
import java.util.List;
import org.junit.internal.runners.statements.Fail;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.testing.utils.ExpectingInstanciationException;
import org.spincast.testing.utils.IBeforeAfterClassMethodsProvider;

public class OneInstancePerClassJUnitRunner
extends BlockJUnit4ClassRunner {
    protected final Logger logger = LoggerFactory.getLogger(OneInstancePerClassJUnitRunner.class);
    private Object spincastTestInstance = null;
    private Exception exceptionInBeforeClass = null;
    private Boolean isExpectingInstanciationException = null;

    public OneInstancePerClassJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public boolean isExpectingInstanciationException() {
        if (this.isExpectingInstanciationException == null) {
            this.isExpectingInstanciationException = this.getTestClass().getAnnotation(ExpectingInstanciationException.class) != null;
        }
        return this.isExpectingInstanciationException;
    }

    @Override
    public Object createTest() throws Exception {
        block5: {
            if (this.exceptionInBeforeClass != null) {
                throw this.exceptionInBeforeClass;
            }
            if (this.spincastTestInstance == null) {
                this.spincastTestInstance = super.createTest();
                if (this.spincastTestInstance instanceof IBeforeAfterClassMethodsProvider) {
                    try {
                        ((IBeforeAfterClassMethodsProvider)this.spincastTestInstance).beforeClass();
                    }
                    catch (Exception ex) {
                        this.exceptionInBeforeClass = ex;
                        if (this.isExpectingInstanciationException()) break block5;
                        throw ex;
                    }
                }
            }
        }
        return this.spincastTestInstance;
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        try {
            List<FrameworkMethod> testMethods = super.computeTestMethods();
            if (this.isExpectingInstanciationException() && testMethods.size() == 0) {
                testMethods = new ArrayList<FrameworkMethod>(testMethods);
                FrameworkMethod method = new FrameworkMethod(this.getTestClass().getJavaClass().getMethod("hashCode", new Class[0]));
                testMethods.add(method);
            }
            return testMethods;
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    @Override
    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = super.methodBlock(method);
        if (statement instanceof Fail) {
            try {
                ((Fail)statement).evaluate();
            }
            catch (Throwable ex) {
                this.exceptionInBeforeClass = new Exception(ex);
            }
        }
        if (this.isExpectingInstanciationException() && this.exceptionInBeforeClass != null) {
            statement = new Statement(){

                @Override
                public void evaluate() throws Throwable {
                }
            };
        }
        return statement;
    }

    @Override
    public void run(RunNotifier notifier) {
        super.run(notifier);
        if (this.exceptionInBeforeClass == null && this.spincastTestInstance != null && this.spincastTestInstance instanceof IBeforeAfterClassMethodsProvider) {
            ((IBeforeAfterClassMethodsProvider)this.spincastTestInstance).afterClass();
        }
    }
}

