/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpincastStatics {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastStatics.class);
    private static SpincastStatics instance;

    protected static SpincastStatics getInstance() {
        if (instance == null) {
            instance = new SpincastStatics();
        }
        return instance;
    }

    public static void setInstance(SpincastStatics instance) {
        SpincastStatics.instance = instance;
    }

    public static RuntimeException runtimize(Exception ex) {
        return SpincastStatics.getInstance().runtimizePrivate(ex);
    }

    protected RuntimeException runtimizePrivate(Exception ex) {
        RuntimeException exceptionToReturn;
        Throwable wrappedException;
        Objects.requireNonNull(ex, "NULL exception");
        if (ex instanceof InvocationTargetException && (wrappedException = ((InvocationTargetException)ex).getTargetException()) != null && wrappedException instanceof Exception) {
            ex = (Exception)wrappedException;
        }
        if (ex instanceof InterruptedException && (exceptionToReturn = this.manageInterruptedException(ex)) != null) {
            return exceptionToReturn;
        }
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex.getMessage(), ex);
    }

    protected RuntimeException manageInterruptedException(Exception ex) {
        Thread.currentThread().interrupt();
        return new RuntimeException(ex.getMessage(), ex);
    }

    public static String getStackTrace(Throwable ex) {
        return SpincastStatics.getInstance().getStackTraceInstance(ex);
    }

    protected String getStackTraceInstance(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

