/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Deque;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.plugins.undertow.SkipResourceOnQueryStringHandler;

public class SkipResourceOnQueryStringHandlerDefault
implements SkipResourceOnQueryStringHandler {
    protected final Logger logger = LoggerFactory.getLogger(SkipResourceOnQueryStringHandlerDefault.class);
    private final HttpHandler runHandler;
    private final HttpHandler skipHandler;

    @AssistedInject
    public SkipResourceOnQueryStringHandlerDefault(@Assisted(value="runHandler") HttpHandler runHandler, @Assisted(value="skipHandler") HttpHandler skipHandler) {
        this.runHandler = runHandler;
        this.skipHandler = skipHandler;
    }

    protected HttpHandler getRunHandler() {
        return this.runHandler;
    }

    protected HttpHandler getSkipHandler() {
        return this.skipHandler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map<String, Deque<String>> queryParameters = exchange.getQueryParameters();
        if (queryParameters != null && queryParameters.size() > 0) {
            this.getSkipHandler().handleRequest(exchange);
        } else {
            this.getRunHandler().handleRequest(exchange);
        }
    }
}

