/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellbosecke.pebble.template;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.extension.escaper.SafeString;
import com.mitchellbosecke.pebble.node.ArgumentsNode;
import com.mitchellbosecke.pebble.node.RootNode;
import com.mitchellbosecke.pebble.template.Block;
import com.mitchellbosecke.pebble.template.EvaluationContext;
import com.mitchellbosecke.pebble.template.Hierarchy;
import com.mitchellbosecke.pebble.template.Macro;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import com.mitchellbosecke.pebble.template.ScopeChain;
import com.mitchellbosecke.pebble.utils.FutureWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PebbleTemplateImpl
implements PebbleTemplate {
    private final PebbleEngine engine;
    private final Map<String, Block> blocks = new HashMap<String, Block>();
    private final Map<String, Macro> macros = new HashMap<String, Macro>();
    private final RootNode rootNode;
    private final String name;

    public PebbleTemplateImpl(PebbleEngine engine, RootNode root, String name) {
        this.engine = engine;
        this.rootNode = root;
        this.name = name;
    }

    @Override
    public void evaluate(Writer writer) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(locale);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null);
        context.getScopeChain().pushScope(map);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluate(Writer writer, Map<String, Object> map, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(locale);
        context.getScopeChain().pushScope(map);
        this.evaluate(writer, context);
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(locale);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Map<String, Object> map) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(null);
        context.getScopeChain().pushScope(map);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    @Override
    public void evaluateBlock(String blockName, Writer writer, Map<String, Object> map, Locale locale) throws PebbleException, IOException {
        EvaluationContext context = this.initContext(locale);
        context.getScopeChain().pushScope(map);
        this.evaluate((Writer)new NoopWriter(), context);
        this.block(writer, context, blockName, false);
        writer.flush();
    }

    private void evaluate(Writer writer, EvaluationContext context) throws PebbleException, IOException {
        if (context.getExecutorService() != null) {
            writer = new FutureWriter(writer);
        }
        this.rootNode.render(this, writer, context);
        if (context.getHierarchy().getParent() != null) {
            PebbleTemplateImpl parent = context.getHierarchy().getParent();
            context.getHierarchy().ascend();
            parent.evaluate(writer, context);
        }
        writer.flush();
    }

    private EvaluationContext initContext(Locale locale) {
        locale = locale == null ? this.engine.getDefaultLocale() : locale;
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("locale", locale);
        globals.put("template", this);
        ScopeChain scopeChain = new ScopeChain(globals);
        scopeChain.pushScope(this.engine.getExtensionRegistry().getGlobalVariables());
        return new EvaluationContext(this, this.engine.isStrictVariables(), locale, this.engine.getExtensionRegistry(), this.engine.getTagCache(), this.engine.getExecutorService(), new ArrayList<PebbleTemplateImpl>(), scopeChain, null);
    }

    public void importTemplate(EvaluationContext context, String name) throws PebbleException {
        context.getImportedTemplates().add((PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name)));
    }

    public void includeTemplate(Writer writer, EvaluationContext context, String name, Map<?, ?> additionalVariables) throws PebbleException, IOException {
        PebbleTemplateImpl template = (PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(name));
        EvaluationContext newContext = context.shallowCopyWithoutInheritanceChain(template);
        ScopeChain scopeChain = newContext.getScopeChain();
        scopeChain.pushScope();
        for (Map.Entry<?, ?> entry : additionalVariables.entrySet()) {
            scopeChain.put((String)entry.getKey(), entry.getValue());
        }
        template.evaluate(writer, newContext);
        scopeChain.popScope();
    }

    public boolean hasMacro(String macroName) {
        return this.macros.containsKey(macroName);
    }

    public boolean hasBlock(String blockName) {
        return this.blocks.containsKey(blockName);
    }

    public String resolveRelativePath(String relativePath) {
        String resolved = this.engine.getLoader().resolveRelativePath(relativePath, this.name);
        if (resolved == null) {
            return relativePath;
        }
        return resolved;
    }

    public void registerBlock(Block block) {
        this.blocks.put(block.getName(), block);
    }

    public void registerMacro(Macro macro) throws PebbleException {
        if (this.macros.containsKey(macro.getName())) {
            throw new PebbleException(null, "More than one macro can not share the same name: " + macro.getName());
        }
        this.macros.put(macro.getName(), macro);
    }

    public void block(Writer writer, EvaluationContext context, String blockName, boolean ignoreOverriden) throws PebbleException, IOException {
        Hierarchy hierarchy = context.getHierarchy();
        PebbleTemplateImpl childTemplate = hierarchy.getChild();
        if (!ignoreOverriden && childTemplate != null) {
            hierarchy.descend();
            childTemplate.block(writer, context, blockName, false);
            hierarchy.ascend();
        } else if (this.blocks.containsKey(blockName)) {
            Block block = this.blocks.get(blockName);
            block.evaluate(this, writer, context);
        } else if (hierarchy.getParent() != null) {
            PebbleTemplateImpl parent = hierarchy.getParent();
            hierarchy.ascend();
            parent.block(writer, context, blockName, true);
            hierarchy.descend();
        }
    }

    public SafeString macro(EvaluationContext context, String macroName, ArgumentsNode args, boolean ignoreOverriden, int lineNumber) throws PebbleException {
        SafeString result = null;
        boolean found = false;
        PebbleTemplateImpl childTemplate = context.getHierarchy().getChild();
        if (!ignoreOverriden && childTemplate != null) {
            found = true;
            context.getHierarchy().descend();
            result = childTemplate.macro(context, macroName, args, false, lineNumber);
            context.getHierarchy().ascend();
        } else if (this.hasMacro(macroName)) {
            found = true;
            Macro macro = this.macros.get(macroName);
            Map<String, Object> namedArguments = args.getArgumentMap(this, context, macro);
            result = new SafeString(macro.call(this, context, namedArguments));
        }
        if (!found) {
            for (PebbleTemplateImpl template : context.getImportedTemplates()) {
                if (!template.hasMacro(macroName)) continue;
                found = true;
                result = template.macro(context, macroName, args, false, lineNumber);
                break;
            }
        }
        if (!found) {
            if (context.getHierarchy().getParent() != null) {
                PebbleTemplateImpl parent = context.getHierarchy().getParent();
                context.getHierarchy().ascend();
                result = parent.macro(context, macroName, args, true, lineNumber);
                context.getHierarchy().descend();
            } else {
                throw new PebbleException(null, String.format("Function or Macro [%s] does not exist.", macroName), lineNumber, this.name);
            }
        }
        return result;
    }

    public void setParent(EvaluationContext context, String parentName) throws PebbleException {
        context.getHierarchy().pushAncestor((PebbleTemplateImpl)this.engine.getTemplate(this.resolveRelativePath(parentName)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class NoopWriter
    extends Writer {
        private NoopWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

