/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.config;

import com.google.inject.Inject;
import org.spincast.core.guice.TestingMode;
import org.spincast.plugins.config.SpincastConfigDefault;
import org.spincast.plugins.config.SpincastConfigPluginConfig;
import org.spincast.quickstart.config.AppConfig;

public class AppConfigDefault
extends SpincastConfigDefault
implements AppConfig {
    private String thisRootPackageName = null;

    @Inject
    public AppConfigDefault(SpincastConfigPluginConfig spincastConfigPluginConfig, @TestingMode boolean testingMode) {
        super(spincastConfigPluginConfig, testingMode);
    }

    @Override
    public String getAppName() {
        return this.getString("app.name");
    }

    @Override
    public String getAppRootPackage() {
        if (this.thisRootPackageName == null) {
            int dotPos2;
            String rootPackageName = AppConfigDefault.class.getPackage().getName();
            int dotPos = rootPackageName.indexOf(".");
            if (dotPos > 0 && (dotPos2 = rootPackageName.indexOf(".", dotPos + 1)) > 0) {
                rootPackageName = rootPackageName.substring(0, dotPos2);
            }
            this.thisRootPackageName = rootPackageName;
        }
        return this.thisRootPackageName;
    }

    @Override
    public String getPublicUrlBase() {
        return this.getString("spincast.publicAccess.urlBase");
    }

    @Override
    public String getCookiesValidatorCookieName() {
        return this.getString("spincast.cookies.validator.name", super.getCookiesValidatorCookieName());
    }

    @Override
    public String getCookieNameFlashMessage() {
        return this.getString("spincast.cookies.flashMessageCookieName", super.getCookieNameFlashMessage());
    }

    @Override
    public String getCookieNameLocale() {
        return this.getString("spincast.cookies.localeCookieName", super.getCookieNameLocale());
    }
}

