/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.server.Server;
import org.spincast.defaults.bootstrapping.Spincast;
import org.spincast.plugins.httpclient.SpincastHttpClientPlugin;
import org.spincast.plugins.logbackutils.SpincastLogbackUtilsPlugin;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.controller.AppController;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.quickstart.exchange.AppRequestContextDefault;
import org.spincast.quickstart.exchange.AppRouter;
import org.spincast.quickstart.exchange.AppWebsocketContextDefault;
import org.spincast.quickstart.guice.AppModule;

public class App {
    protected static final Logger logger = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        Spincast.configure().module(new AppModule()).plugin(new SpincastHttpClientPlugin()).plugin(new SpincastLogbackUtilsPlugin()).requestContextImplementationClass(AppRequestContextDefault.class).websocketContextImplementationClass(AppWebsocketContextDefault.class).init(args);
    }

    @Inject
    protected void init(Server server, AppConfig config, AppRouter router, AppController appController, SpincastFilters<AppRequestContext> spincastFilters) {
        this.addRoutes(router, appController, spincastFilters);
        server.start();
        logger.info("Server started...");
        this.displayStartedMessage(config);
    }

    protected void addRoutes(AppRouter router, AppController ctrl, SpincastFilters<AppRequestContext> spincastFilters) {
        router.dir("/public").classpath("/quick-start/public").handle();
        router.file("/favicon.ico").classpath("/quick-start/public/favicon.ico").handle();
        router.file("/robots.txt").classpath("/quick-start/public/robots.txt").handle();
        router.file("/humans.txt").classpath("/quick-start/public/humans.txt").handle();
        router.file("/browserconfig.xml").classpath("/quick-start/public/browserconfig.xml").handle();
        router.file("/apple-touch-icon.png").classpath("/quick-start/public/apple-touch-icon.png").handle();
        router.file("/tile-wide.png").classpath("/quick-start/public/tile-wide.png").handle();
        router.file("/tile.png").classpath("/quick-start/public/tile.png").handle();
        router.ALL().pos(-10).handle(spincastFilters::addSecurityHeaders);
        router.GET("/").cache(3600).handle(ctrl::index);
        router.GET("/form").handle(ctrl::formExample);
        router.GET("/exception-example").handle(ctrl::exceptionExample);
        router.notFound(ctrl::notFound);
        router.exception(ctrl::exception);
    }

    protected void displayStartedMessage(AppConfig config) {
        String appName = config.getAppName();
        String publicUrlBase = config.getPublicUrlBase();
        System.out.println();
        System.out.println("==========================================");
        System.out.println(appName + " started!");
        System.out.println(publicUrlBase);
        System.out.println("==========================================");
    }
}

