/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.filters;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exceptions.SkipRemainingHandlersException;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.CorsFilterClient;
import org.spincast.core.filters.CorsFilterResponse;
import org.spincast.core.filters.SpincastFilters;
import org.spincast.core.flash.FlashMessage;
import org.spincast.core.flash.FlashMessageLevel;
import org.spincast.core.response.Alert;
import org.spincast.core.response.AlertLevel;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.server.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtils;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class SpincastFiltersDefault<R extends RequestContext<?>>
implements SpincastFilters<R> {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastFiltersDefault.class);
    private final CorsFilter corsFilter;
    private final SpincastConfig spincastConfig;
    private final Server server;
    private final SpincastUtils spincastUtils;

    @Inject
    public SpincastFiltersDefault(CorsFilter corsFilter, SpincastConfig spincastConfig, Server server, SpincastUtils spincastUtils) {
        this.corsFilter = corsFilter;
        this.spincastConfig = spincastConfig;
        this.server = server;
        this.spincastUtils = spincastUtils;
    }

    protected CorsFilter getCorsFilter() {
        return this.corsFilter;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Server getServer() {
        return this.server;
    }

    protected SpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    @Override
    public boolean saveGeneratedResource(R context, String pathForGeneratedResource) {
        try {
            File resourceFile = new File(pathForGeneratedResource);
            if (resourceFile.exists()) {
                logger.info("The resource already exists. We don't save it here.");
                return true;
            }
            if (200 != context.response().getStatusCode()) {
                logger.info("Nothing will be saved since the response code is not 200");
                return false;
            }
            if (context.response().isHeadersSent()) {
                logger.warn("Headers sent, we can't save a copy of the generated resource! You will have to make sure that you save the generated resource by yourself, otherwise, a new version will be generated for each request!");
                return false;
            }
            byte[] unsentBytes = context.response().getUnsentBytes();
            FileUtils.writeByteArrayToFile(resourceFile, unsentBytes);
            return true;
        }
        catch (Exception ex) {
            logger.error("Unable to save the generated resource '" + pathForGeneratedResource + "' :\n" + SpincastStatics.getStackTrace(ex));
            return false;
        }
    }

    @Override
    public void addSecurityHeaders(R context) {
        context.response().addHeaderValue("X-Xss-Protection", "1; mode=block");
        context.response().addHeaderValue("X-Frame-Options", "SAMEORIGIN");
        context.response().addHeaderValue("x-content-type-options", "nosniff");
    }

    @Override
    public void cors(R context) {
        this.cors(context, this.getCorsDefaultAllowedOrigins(), this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins) {
        this.cors(context, allowedOrigins, this.getCorsDefaultExtraHeadersAllowedToBeRead(), this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, this.getCorsDefaultExtraHeadersAllowedToBeSent(), this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, this.getCorsDefaultIsCookiesAllowed(), this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, this.getCorsDefaultAllowedMethods(), this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods) {
        this.cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, this.getCorsDefaultMaxAgeInSeconds());
    }

    @Override
    public void cors(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        CorsFilterClient corsFilterClient = this.createCorsFilterClient(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
        CorsFilterResponse corsResult = this.getCorsFilter().apply(corsFilterClient);
        if (corsResult == CorsFilterResponse.NOT_CORS) {
            return;
        }
        if (corsResult == CorsFilterResponse.HEADERS_ALREADY_SENT) {
            return;
        }
        if (corsResult == CorsFilterResponse.INVALID_CORS_REQUEST) {
            throw new SkipRemainingHandlersException();
        }
        if (corsResult == CorsFilterResponse.SIMPLE) {
            return;
        }
        if (corsResult == CorsFilterResponse.PREFLIGHT) {
            throw new SkipRemainingHandlersException();
        }
        throw new RuntimeException("Unmanaged cors result: " + (Object)((Object)corsResult));
    }

    protected CorsFilterClient createCorsFilterClient(R context, Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        return new CorsFilterClient((RequestContext)context, allowCookies, maxAgeInSeconds, extraHeadersAllowedToBeSent, extraHeadersAllowedToBeRead, allowedOrigins, allowedMethods){
            final /* synthetic */ RequestContext val$context;
            final /* synthetic */ boolean val$allowCookies;
            final /* synthetic */ int val$maxAgeInSeconds;
            final /* synthetic */ Set val$extraHeadersAllowedToBeSent;
            final /* synthetic */ Set val$extraHeadersAllowedToBeRead;
            final /* synthetic */ Set val$allowedOrigins;
            final /* synthetic */ Set val$allowedMethods;
            {
                this.val$context = requestContext;
                this.val$allowCookies = bl;
                this.val$maxAgeInSeconds = n;
                this.val$extraHeadersAllowedToBeSent = set;
                this.val$extraHeadersAllowedToBeRead = set2;
                this.val$allowedOrigins = set3;
                this.val$allowedMethods = set4;
            }

            @Override
            public void setStatusCode(int code) {
                this.val$context.response().setStatusCode(code);
            }

            @Override
            public void resetEverything() {
                this.val$context.response().resetEverything();
            }

            @Override
            public boolean requestContainsCookies() {
                Map<String, String> cookies = this.val$context.request().getCookiesValues();
                return cookies != null && cookies.size() > 0;
            }

            @Override
            public boolean isHeadersSent() {
                return this.val$context.response().isHeadersSent();
            }

            @Override
            public boolean isAllowCookies() {
                return this.val$allowCookies;
            }

            @Override
            public int getMaxAgeInSeconds() {
                return this.val$maxAgeInSeconds;
            }

            @Override
            public HttpMethod getHttpMethod() {
                return this.val$context.request().getHttpMethod();
            }

            @Override
            public String getHeaderFirst(String name) {
                return this.val$context.request().getHeaderFirst(name);
            }

            @Override
            public String getFullUrl() {
                return this.val$context.request().getFullUrl();
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeSent() {
                return this.val$extraHeadersAllowedToBeSent;
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeRead() {
                return this.val$extraHeadersAllowedToBeRead;
            }

            @Override
            public Set<String> getAllowedOrigins() {
                return this.val$allowedOrigins;
            }

            @Override
            public Set<HttpMethod> getAllowedMethods() {
                return this.val$allowedMethods;
            }

            @Override
            public void addHeaderValue(String name, String value) {
                this.val$context.response().addHeaderValue(name, value);
            }
        };
    }

    protected int getCorsDefaultMaxAgeInSeconds() {
        return 86400;
    }

    protected Set<String> getCorsDefaultAllowedOrigins() {
        return Sets.newHashSet("*");
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeRead() {
        return null;
    }

    protected Set<String> getCorsDefaultExtraHeadersAllowedToBeSent() {
        return Sets.newHashSet("*");
    }

    protected boolean getCorsDefaultIsCookiesAllowed() {
        return true;
    }

    protected Set<HttpMethod> getCorsDefaultAllowedMethods() {
        return Sets.newHashSet(HttpMethod.values());
    }

    @Override
    public void cache(R context) {
        this.cache(context, this.getCacheSecondsByDefault());
    }

    @Override
    public void cache(R context, int seconds) {
        this.cache(context, seconds, this.isCachePrivateByDefault());
    }

    @Override
    public void cache(R context, int seconds, boolean isPrivate) {
        this.cache(context, seconds, isPrivate, this.getCacheCdnSecondsByDefault());
    }

    @Override
    public void cache(R context, int seconds, boolean isPrivate, Integer cdnSeconds) {
        context.cacheHeaders().cache(seconds, isPrivate, cdnSeconds);
    }

    protected int getCacheSecondsByDefault() {
        return this.getSpincastConfig().getDefaultRouteCacheFilterSecondsNbr();
    }

    protected boolean isCachePrivateByDefault() {
        return this.getSpincastConfig().isDefaultRouteCacheFilterPrivate();
    }

    protected Integer getCacheCdnSecondsByDefault() {
        return this.getSpincastConfig().getDefaultRouteCacheFilterSecondsNbrCdns();
    }

    @Override
    public void addDefaultGlobalTemplateVariables(R context) {
        Map<String, Object> map = context.templating().getSpincastReservedMap();
        if (context.routing().isForwarded()) {
            map.clear();
        }
        map.put("langAbrv", context.getLocaleToUse().getLanguage());
        String currentVersion = this.getSpincastUtils().getSpincastCurrentVersion();
        map.put("spincastCurrrentVersion", currentVersion);
        map.put("spincastCurrrentVersionIsSnapshot", currentVersion.contains("-SNAPSHOT"));
        map.put("cacheBuster", this.getSpincastUtils().getCacheBusterCode());
        map.put("requestScopedVars", context.variables().getAll());
        map.put("routeId", context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().getId());
        map.put("routePath", context.routing().getRoutingResult().getMainRouteHandlerMatch().getSourceRoute().getPath());
        map.put("root", this.getSpincastConfig().getPublicUrlBase());
        map.put("fullUrl", context.request().getFullUrl());
        map.put("isHttps", context.request().isHttps());
        map.put("pathParams", context.routing().getRoutingResult().getMainRouteHandlerMatch().getPathParams());
        map.put("qsParams", context.request().getQueryStringParams());
        map.put("cookies", context.request().getCookiesValues());
        if (context.request().isFlashMessageExists()) {
            ArrayList<LazyLoadedFlashMessageAlert> alerts = (ArrayList<LazyLoadedFlashMessageAlert>)map.get("alerts");
            if (alerts == null) {
                alerts = new ArrayList<LazyLoadedFlashMessageAlert>();
                map.put("alerts", alerts);
            }
            boolean lazyLoadedAlertAlreadyAdded = false;
            for (Alert alert : alerts) {
                if (!(alert instanceof LazyLoadedFlashMessageAlert)) continue;
                lazyLoadedAlertAlreadyAdded = true;
                break;
            }
            if (!lazyLoadedAlertAlreadyAdded) {
                alerts.add(new LazyLoadedFlashMessageAlert(this, context));
            }
        }
    }

    protected static class LazyLoadedFlashMessageAlert
    implements Alert {
        private FlashMessage flashMessage;
        private boolean flashMessageGot;
        private R context;
        final /* synthetic */ SpincastFiltersDefault this$0;

        public LazyLoadedFlashMessageAlert(R context) {
            this.this$0 = this$0;
            this.context = context;
        }

        protected FlashMessage getFlashMessage() {
            if (!this.flashMessageGot) {
                this.flashMessageGot = true;
                this.flashMessage = this.context.request().getFlashMessage();
            }
            return this.flashMessage;
        }

        @Override
        public String getText() {
            return this.getFlashMessage() != null ? this.getFlashMessage().getText() : null;
        }

        @Override
        public AlertLevel getAlertType() {
            if (this.getFlashMessage() == null) {
                return null;
            }
            FlashMessageLevel flashType = this.getFlashMessage().getFlashType();
            if (flashType == FlashMessageLevel.SUCCESS) {
                return AlertLevel.SUCCESS;
            }
            if (flashType == FlashMessageLevel.WARNING) {
                return AlertLevel.WARNING;
            }
            if (flashType == FlashMessageLevel.ERROR) {
                return AlertLevel.ERROR;
            }
            throw new RuntimeException("Flash type not managed here : " + (Object)((Object)flashType));
        }
    }
}

