/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.httpclient.builders;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.json.JsonManager;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.XmlManager;
import org.spincast.plugins.httpclient.FileToUpload;
import org.spincast.plugins.httpclient.HttpResponseFactory;
import org.spincast.plugins.httpclient.SpincastHttpClientConfig;
import org.spincast.plugins.httpclient.builders.BodySenderRequestBuilderBase;
import org.spincast.plugins.httpclient.builders.HttpRequestBuilderBase;
import org.spincast.plugins.httpclient.utils.SpincastHttpClientUtils;
import org.spincast.shaded.org.apache.http.HttpEntity;
import org.spincast.shaded.org.apache.http.NameValuePair;
import org.spincast.shaded.org.apache.http.client.entity.UrlEncodedFormEntity;
import org.spincast.shaded.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.spincast.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.spincast.shaded.org.apache.http.entity.StringEntity;
import org.spincast.shaded.org.apache.http.entity.mime.MultipartEntityBuilder;
import org.spincast.shaded.org.apache.http.message.BasicNameValuePair;

public abstract class BodySenderRequestBuilderBaseDefault<T extends BodySenderRequestBuilderBase<?>>
extends HttpRequestBuilderBase<T>
implements BodySenderRequestBuilderBase<T> {
    protected static final Logger logger = LoggerFactory.getLogger(BodySenderRequestBuilderBaseDefault.class);
    private final JsonManager jsonManager;
    private final XmlManager xmlManager;
    private Map<String, List<String>> formBodyFields;
    private List<FileToUpload> filesToUpload;
    private HttpEntity standardBody;
    private BodyType bodyType = null;

    public BodySenderRequestBuilderBaseDefault(String url, CookieFactory cookieFactory, HttpResponseFactory spincastHttpResponseFactory, JsonManager jsonManager, XmlManager xmlManager, SpincastHttpClientUtils spincastHttpClientUtils, SpincastHttpClientConfig spincastHttpClientConfig) {
        super(url, cookieFactory, spincastHttpResponseFactory, spincastHttpClientUtils, spincastHttpClientConfig);
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
    }

    protected String getStringBodyEncoding() {
        return "UTF-8";
    }

    protected String getFormBodyEncoding() {
        return "UTF-8";
    }

    protected BodyType getBodyType() {
        return this.bodyType;
    }

    protected HttpEntity getStandardBody() {
        return this.standardBody;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected XmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected Map<String, List<String>> getFormBodyFields() {
        if (this.formBodyFields == null) {
            this.formBodyFields = new HashMap<String, List<String>>();
        }
        return this.formBodyFields;
    }

    protected List<FileToUpload> getFileToUploads() {
        if (this.filesToUpload == null) {
            this.filesToUpload = new ArrayList<FileToUpload>();
        }
        return this.filesToUpload;
    }

    @Override
    public T addFormBodyFieldValue(String name, String value) {
        Objects.requireNonNull(name, "The name can't be NULL");
        if (this.getBodyType() != null && this.getBodyType() != BodyType.FORM) {
            logger.warn("There was already a body of a different type set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        this.filesToUpload = null;
        this.standardBody = null;
        this.bodyType = BodyType.FORM;
        Map<String, List<String>> params = this.getFormBodyFields();
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            params.put(name, values);
        }
        values.add(value);
        BodySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setFormBodyField(String fieldName, List<String> values) {
        Objects.requireNonNull(fieldName, "The name can't be NULL");
        if (this.getBodyType() != null && this.getBodyType() != BodyType.FORM) {
            logger.warn("There was already a body of a different type set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        this.filesToUpload = null;
        this.standardBody = null;
        this.bodyType = BodyType.FORM;
        this.getFormBodyFields().put(fieldName, values);
        BodySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setFormBodyFields(Map<String, List<String>> formFields) {
        if (this.getBodyType() != null && this.getBodyType() != BodyType.FORM) {
            logger.warn("There was already a body of a different type set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        this.filesToUpload = null;
        this.standardBody = null;
        if (formFields != null && formFields.size() > 0) {
            this.bodyType = BodyType.FORM;
        }
        this.formBodyFields = formFields;
        BodySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setStringBody(String stringBody, String contentType) {
        Objects.requireNonNull(contentType, "The contentType can't be NULL");
        if (this.getStandardBody() != null || this.getBodyType() != null && this.getBodyType() != BodyType.STANDARD) {
            logger.warn("There was already a body set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        StringEntity stringEntity = new StringEntity(stringBody, this.getStringBodyEncoding());
        stringEntity.setContentType(contentType);
        this.formBodyFields = null;
        this.filesToUpload = null;
        this.standardBody = stringEntity;
        this.bodyType = BodyType.STANDARD;
        BodySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T setJsonStringBody(Object object) {
        Objects.requireNonNull(object, "The object can't be NULL");
        String jsonString = this.getJsonManager().toJsonString(object);
        return this.setStringBody(jsonString, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset());
    }

    @Override
    public T setXmlStringBody(Object object) {
        Objects.requireNonNull(object, "The object can't be NULL");
        String xml = this.getXmlManager().toXml(object);
        return this.setStringBody(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset());
    }

    @Override
    public T setBody(HttpEntity body) {
        if (this.getStandardBody() != null || this.getBodyType() != null && this.getBodyType() != BodyType.STANDARD) {
            logger.warn("There was already a body set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        this.formBodyFields = null;
        this.filesToUpload = null;
        this.standardBody = body;
        this.bodyType = BodyType.STANDARD;
        BodySenderRequestBuilderBaseDefault t = this;
        return (T)t;
    }

    @Override
    public T addFileToUploadBody(String path, String name) {
        return this.addFileToUploadBody(path, false, name);
    }

    @Override
    public T addFileToUploadBody(String path, boolean isClasspathPath, String name) {
        Objects.requireNonNull(path, "The path can't be NULL");
        if (this.getBodyType() != null && this.getBodyType() != BodyType.FILES_TO_UPLOAD) {
            logger.warn("There was already a body set ('" + (Object)((Object)this.getBodyType()) + "'). It will be replaced.");
        }
        this.formBodyFields = null;
        this.standardBody = null;
        this.bodyType = BodyType.FILES_TO_UPLOAD;
        try {
            if (isClasspathPath) {
                URL resource = this.getClass().getClassLoader().getResource(path);
                if (resource == null) {
                    throw new RuntimeException("File to upload not found on the classpath: " + path);
                }
            } else if (!new File(path).isFile()) {
                throw new RuntimeException("File to upload not found on the file system: " + path);
            }
            FileToUpload fileToUpload = new FileToUpload(path, isClasspathPath, name);
            this.getFileToUploads().add(fileToUpload);
            BodySenderRequestBuilderBaseDefault t = this;
            return (T)t;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected List<NameValuePair> convertToNameValuePair(Map<String, List<String>> params) {
        ArrayList<NameValuePair> nameValuePairList = new ArrayList<NameValuePair>();
        if (params != null) {
            for (Map.Entry<String, List<String>> entry : params.entrySet()) {
                String name = entry.getKey();
                if (entry.getValue() == null) continue;
                for (String value : entry.getValue()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(name, value);
                    nameValuePairList.add(nameValuePair);
                }
            }
        }
        return nameValuePairList;
    }

    @Override
    protected HttpRequestBase createMethodSpecificHttpRequest(String url) {
        HttpEntityEnclosingRequestBase request;
        block11: {
            request = this.getHttpEntityEnclosingRequestBase(url);
            try {
                if (this.getBodyType() == null) break block11;
                if (this.getBodyType() == BodyType.STANDARD) {
                    if (this.getStandardBody() != null) {
                        request.setEntity(this.getStandardBody());
                    }
                    break block11;
                }
                if (this.getBodyType() == BodyType.FORM) {
                    if (this.getFormBodyFields() != null && this.getFormBodyFields().size() > 0) {
                        request.setEntity(new UrlEncodedFormEntity(this.convertToNameValuePair(this.getFormBodyFields()), this.getFormBodyEncoding()));
                    }
                    break block11;
                }
                if (this.getBodyType() == BodyType.FILES_TO_UPLOAD) {
                    if (this.getFileToUploads() != null && this.getFileToUploads().size() > 0) {
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        for (FileToUpload fileToUpload : this.getFileToUploads()) {
                            File file;
                            if (fileToUpload.isClasspathPath()) {
                                URL resource = this.getClass().getClassLoader().getResource(fileToUpload.getPath());
                                file = new File(resource.toURI());
                            } else {
                                file = new File(fileToUpload.getPath());
                            }
                            builder.addBinaryBody(fileToUpload.getName(), file);
                        }
                        request.setEntity(builder.build());
                    }
                    break block11;
                }
                throw new RuntimeException("Not managed: " + (Object)((Object)this.getBodyType()));
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        return request;
    }

    protected abstract HttpEntityEnclosingRequestBase getHttpEntityEnclosingRequestBase(String var1);

    protected static enum BodyType {
        STANDARD,
        FORM,
        FILES_TO_UPLOAD;

    }
}

