/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.quickstart.controller;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConstants;
import org.spincast.core.exceptions.PublicException;
import org.spincast.core.json.JsonObject;
import org.spincast.quickstart.config.AppConfig;
import org.spincast.quickstart.exchange.AppRequestContext;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class AppController {
    protected static final Logger logger = LoggerFactory.getLogger(AppController.class);
    private final AppConfig appConfig;

    @Inject
    public AppController(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    protected AppConfig getAppConfig() {
        return this.appConfig;
    }

    protected void addCommonModelElements(AppRequestContext context) {
        context.response().getModel().set("appName", this.getAppConfig().getAppName());
        context.response().getModel().set("serverPort", this.getAppConfig().getHttpServerPort());
    }

    public void index(AppRequestContext context) {
        logger.debug("In the 'index' handler");
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/quick-start/templates/index.html");
    }

    public void formExample(AppRequestContext context) {
        String userName = context.request().getQueryStringParamFirst("userName");
        Object greetings = "";
        if (!StringUtils.isBlank(userName)) {
            greetings = "Hi " + userName + "!";
        }
        context.response().getModel().set("userName", userName);
        context.response().getModel().set("greetings", greetings);
        this.addCommonModelElements(context);
        context.response().sendTemplateHtml("/quick-start/templates/form.html");
    }

    public void exceptionExample(AppRequestContext context) {
        throw new RuntimeException("This simulates an exception in the application!");
    }

    public void notFound(AppRequestContext context) {
        String notFoundMessage = "Page not found";
        String specificNotFoundMessage = context.variables().getAsString(SpincastConstants.RequestScopedVariables.NOT_FOUND_PUBLIC_MESSAGE);
        if (specificNotFoundMessage != null) {
            notFoundMessage = specificNotFoundMessage;
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.set("message", notFoundMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().set("notFoundMessage", notFoundMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/quick-start/templates/notFound.html");
        }
    }

    public void exception(AppRequestContext context) {
        String errorMessage = "An error occured! Please try again later...";
        Throwable originalException = context.variables().get(SpincastConstants.RequestScopedVariables.EXCEPTION, Throwable.class);
        logger.error("An exception occured : " + originalException);
        if (originalException != null && originalException instanceof PublicException) {
            errorMessage = originalException.getMessage();
        }
        if (context.request().isJsonShouldBeReturn()) {
            JsonObject errorObj = context.json().create();
            errorObj.set("error", errorMessage);
            context.response().sendJson(errorObj);
        } else {
            context.response().getModel().set("errorMessage", errorMessage);
            this.addCommonModelElements(context);
            context.response().sendTemplateHtml("/quick-start/templates/exception.html");
        }
    }
}

