/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.shaded.org.commonjava.mimeparse;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.commons.lang3.math.NumberUtils;

public final class MIMEParse {
    protected static ParseResults parseMimeType(String mimeType) {
        String[] parts = StringUtils.split(mimeType, ";");
        ParseResults results = new ParseResults();
        results.params = new HashMap<String, String>();
        for (int i = 1; i < parts.length; ++i) {
            String p = parts[i];
            String[] subParts = StringUtils.split(p, '=');
            if (subParts.length != 2) continue;
            results.params.put(subParts[0].trim(), subParts[1].trim());
        }
        String fullType = parts[0].trim();
        if (fullType.equals("*")) {
            fullType = "*/*";
        }
        String[] types = StringUtils.split(fullType, "/");
        results.type = types[0].trim();
        results.subType = types[1].trim();
        return results;
    }

    protected static ParseResults parseMediaRange(String range) {
        ParseResults results = MIMEParse.parseMimeType(range);
        String q = results.params.get("q");
        float f = NumberUtils.toFloat(q, 1.0f);
        if (StringUtils.isBlank(q) || f < 0.0f || f > 1.0f) {
            results.params.put("q", "1");
        }
        return results;
    }

    protected static FitnessAndQuality fitnessAndQualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        int bestFitness = -1;
        float bestFitQ = 0.0f;
        ParseResults target = MIMEParse.parseMediaRange(mimeType);
        for (ParseResults range : parsedRanges) {
            if (!target.type.equals(range.type) && !range.type.equals("*") && !target.type.equals("*") || !target.subType.equals(range.subType) && !range.subType.equals("*") && !target.subType.equals("*")) continue;
            for (String k : target.params.keySet()) {
                int paramMatches = 0;
                if (!k.equals("q") && range.params.containsKey(k) && target.params.get(k).equals(range.params.get(k))) {
                    ++paramMatches;
                }
                int fitness = range.type.equals(target.type) ? 100 : 0;
                fitness += range.subType.equals(target.subType) ? 10 : 0;
                if ((fitness += paramMatches) <= bestFitness) continue;
                bestFitness = fitness;
                bestFitQ = NumberUtils.toFloat(range.params.get("q"), 0.0f);
            }
        }
        return new FitnessAndQuality(bestFitness, bestFitQ);
    }

    protected static float qualityParsed(String mimeType, Collection<ParseResults> parsedRanges) {
        return MIMEParse.fitnessAndQualityParsed((String)mimeType, parsedRanges).quality;
    }

    public static float quality(String mimeType, String ranges) {
        LinkedList<ParseResults> results = new LinkedList<ParseResults>();
        for (String r : StringUtils.split(ranges, ',')) {
            results.add(MIMEParse.parseMediaRange(r));
        }
        return MIMEParse.qualityParsed(mimeType, results);
    }

    public static String bestMatch(Collection<String> supported, String header) {
        LinkedList<ParseResults> parseResults = new LinkedList<ParseResults>();
        LinkedList<FitnessAndQuality> weightedMatches = new LinkedList<FitnessAndQuality>();
        for (String r : StringUtils.split(header, ',')) {
            parseResults.add(MIMEParse.parseMediaRange(r));
        }
        for (String s : supported) {
            FitnessAndQuality fitnessAndQuality = MIMEParse.fitnessAndQualityParsed(s, parseResults);
            fitnessAndQuality.mimeType = s;
            weightedMatches.add(fitnessAndQuality);
        }
        Collections.sort(weightedMatches);
        FitnessAndQuality lastOne = (FitnessAndQuality)weightedMatches.get(weightedMatches.size() - 1);
        return Float.compare(lastOne.quality, 0.0f) != 0 ? lastOne.mimeType : "";
    }

    private MIMEParse() {
    }

    protected static class ParseResults {
        String type;
        String subType;
        Map<String, String> params;

        protected ParseResults() {
        }

        public String toString() {
            StringBuffer s = new StringBuffer("('" + this.type + "', '" + this.subType + "', {");
            for (String k : this.params.keySet()) {
                s.append("'" + k + "':'" + this.params.get(k) + "',");
            }
            return s.append("})").toString();
        }
    }

    protected static class FitnessAndQuality
    implements Comparable<FitnessAndQuality> {
        int fitness;
        float quality;
        String mimeType;

        public FitnessAndQuality(int fitness, float quality) {
            this.fitness = fitness;
            this.quality = quality;
        }

        @Override
        public int compareTo(FitnessAndQuality o) {
            if (this.fitness == o.fitness) {
                if (this.quality == o.quality) {
                    return 0;
                }
                return this.quality < o.quality ? -1 : 1;
            }
            return this.fitness < o.fitness ? -1 : 1;
        }
    }
}

