/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Objects;
import org.spincast.core.cookies.ICookieFactory;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.routing.IRouter;
import org.spincast.core.server.IServer;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.plugins.httpclient.builders.IConnectRequestBuilder;
import org.spincast.plugins.httpclient.builders.IDeleteRequestBuilder;
import org.spincast.plugins.httpclient.builders.IGetRequestBuilder;
import org.spincast.plugins.httpclient.builders.IHeadRequestBuilder;
import org.spincast.plugins.httpclient.builders.IOptionsRequestBuilder;
import org.spincast.plugins.httpclient.builders.IPatchRequestBuilder;
import org.spincast.plugins.httpclient.builders.IPostRequestBuilder;
import org.spincast.plugins.httpclient.builders.IPutRequestBuilder;
import org.spincast.plugins.httpclient.builders.ITraceRequestBuilder;
import org.spincast.plugins.httpclient.websocket.IHttpClient;
import org.spincast.plugins.httpclient.websocket.SpincastHttpClientWithWebsocketPluginGuiceModule;
import org.spincast.plugins.httpclient.websocket.builders.IWebsocketRequestBuilder;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.client.utils.DateUtils;
import org.spincast.testing.core.SpincastTestBase;

public abstract class SpincastIntegrationTestBase<R extends IRequestContext<?>, W extends IWebsocketContext<?>>
extends SpincastTestBase {
    @Inject
    private IHttpClient httpClient;
    @Inject
    private IServer server;
    @Inject
    private IRouter<R, W> router;
    @Inject
    private ICookieFactory cookieFactory;

    protected Module getDefaultOverridingModule(Type requestContextType, Type websocketContextType) {
        return new SpincastHttpClientWithWebsocketPluginGuiceModule(requestContextType, websocketContextType);
    }

    @Override
    public void afterClass() {
        super.afterClass();
        this.stopServer();
    }

    protected void stopServer() {
        if (this.getServer() != null) {
            this.getServer().stop();
        }
    }

    protected IHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected IRouter<R, W> getRouter() {
        return this.router;
    }

    protected ICookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected String createTestUrl(String path) {
        return this.createTestUrl(path, false, false);
    }

    protected String createTestUrl(String path, boolean https) {
        return this.createTestUrl(path, false, https);
    }

    protected String createTestUrl(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        if (isFullUrl) {
            return pathOrUrl;
        }
        if (StringUtils.isBlank((CharSequence)pathOrUrl)) {
            pathOrUrl = "/";
        } else if (!pathOrUrl.startsWith("/")) {
            pathOrUrl = "/" + pathOrUrl;
        }
        return "http" + (isHttps ? "s" : "") + "://" + this.getSpincastConfig().getServerHost() + ":" + (isHttps ? this.getSpincastConfig().getHttpsServerPort() : this.getSpincastConfig().getHttpServerPort()) + pathOrUrl;
    }

    protected IWebsocketRequestBuilder websocket(String path) {
        return this.websocket(path, false, false);
    }

    protected IWebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl) {
        return this.websocket(pathOrUrl, isFullUrl, false);
    }

    protected IWebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IWebsocketRequestBuilder builder = this.getHttpClient().websocket(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        return builder;
    }

    protected IGetRequestBuilder GET(String path) {
        return this.GET(path, false, false);
    }

    protected IGetRequestBuilder GET(String pathOrUrl, boolean isFullUrl) {
        return this.GET(pathOrUrl, isFullUrl, false);
    }

    protected IGetRequestBuilder GET(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IGetRequestBuilder client = this.getHttpClient().GET(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected boolean isDisableSllCetificateErrors() {
        return true;
    }

    protected IPostRequestBuilder POST(String path) {
        return this.POST(path, false, false);
    }

    protected IPostRequestBuilder POST(String pathOrUrl, boolean isFullUrl) {
        return this.POST(pathOrUrl, isFullUrl, false);
    }

    protected IPostRequestBuilder POST(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IPostRequestBuilder client = this.getHttpClient().POST(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IPutRequestBuilder PUT(String path) {
        return this.PUT(path, false, false);
    }

    protected IPutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl) {
        return this.PUT(pathOrUrl, isFullUrl, false);
    }

    protected IPutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IPutRequestBuilder client = this.getHttpClient().PUT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IDeleteRequestBuilder DELETE(String path) {
        return this.DELETE(path, false, false);
    }

    protected IDeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl) {
        return this.DELETE(pathOrUrl, isFullUrl, false);
    }

    protected IDeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IDeleteRequestBuilder client = this.getHttpClient().DELETE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IOptionsRequestBuilder OPTIONS(String path) {
        return this.OPTIONS(path, false, false);
    }

    protected IOptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl) {
        return this.OPTIONS(pathOrUrl, isFullUrl, false);
    }

    protected IOptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IOptionsRequestBuilder client = this.getHttpClient().OPTIONS(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected ITraceRequestBuilder TRACE(String path) {
        return this.TRACE(path, false, false);
    }

    protected ITraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl) {
        return this.TRACE(pathOrUrl, isFullUrl, false);
    }

    protected ITraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        ITraceRequestBuilder client = this.getHttpClient().TRACE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IConnectRequestBuilder CONNECT(String path) {
        return this.CONNECT(path, false, false);
    }

    protected IConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl) {
        return this.CONNECT(pathOrUrl, isFullUrl, false);
    }

    protected IConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IConnectRequestBuilder client = this.getHttpClient().CONNECT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IPatchRequestBuilder PATCH(String path) {
        return this.PATCH(path, false, false);
    }

    protected IPatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl) {
        return this.PATCH(pathOrUrl, isFullUrl, false);
    }

    protected IPatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IPatchRequestBuilder client = this.getHttpClient().PATCH(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected IHeadRequestBuilder HEAD(String path) {
        return this.HEAD(path, false, false);
    }

    protected IHeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl) {
        return this.HEAD(pathOrUrl, isFullUrl, false);
    }

    protected IHeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        IHeadRequestBuilder client = this.getHttpClient().HEAD(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected String formatDate(Date date) {
        Objects.requireNonNull(date, "The date can't be NULL");
        return DateUtils.formatDate((Date)date);
    }

    protected Date parseDate(String dateHeaderValue) {
        Objects.requireNonNull(dateHeaderValue, "The dateHeaderValue can't be NULL");
        return DateUtils.parseDate((String)dateHeaderValue);
    }
}

