/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.websocket.IWebsocketContext;
import org.spincast.testing.core.SpincastIntegrationTestBase;

public abstract class SpincastNoAppIntegrationTestBase<R extends IRequestContext<?>, W extends IWebsocketContext<?>>
extends SpincastIntegrationTestBase<R, W> {
    @Override
    protected Injector createInjector() {
        Module overridingModule = this.getOverridingModule();
        if (overridingModule == null) {
            return Guice.createInjector((Module[])new Module[]{this.getTestingModule()});
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{this.getTestingModule()}).with(new Module[]{overridingModule})});
    }

    public abstract Module getTestingModule();

    protected Module getOverridingModule() {
        return null;
    }

    protected String[] getMainArgsToUse() {
        return null;
    }

    @Override
    public void beforeClass() {
        super.beforeClass();
        this.beforeStartServer();
        this.startServer();
    }

    protected void beforeStartServer() {
    }

    @Override
    public void beforeTest() {
        super.beforeTest();
        this.clearRoutes();
    }

    protected void startServer() {
        this.getServer().start();
    }

    protected void clearRoutes() {
        this.getRouter().removeAllRoutes(this.removeSpincastRoutesToo());
        this.getServer().removeAllStaticResourcesServed();
    }

    protected boolean removeSpincastRoutesToo() {
        return false;
    }
}

