/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;
import org.junit.runners.MethodSorters;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.testing.utils.IBeforeAfterClassMethodsProvider;
import org.spincast.testing.utils.IRepeatedClassAfterMethodProvider;
import org.spincast.testing.utils.ITestFailureListener;
import org.spincast.testing.utils.SpincastJUnitRunner;

@RunWith(value=SpincastJUnitRunner.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class SpincastTestBase
implements IBeforeAfterClassMethodsProvider,
ITestFailureListener,
IRepeatedClassAfterMethodProvider {
    private Injector guice;
    private File testingWritableDir;
    private ISpincastConfig spincastConfig;

    public void beforeClass() {
        this.guice = this.createInjector();
        Assert.assertNotNull((Object)this.guice);
        this.guice.injectMembers((Object)this);
    }

    @Before
    public void beforeTest() {
    }

    @After
    public void afterTest() {
    }

    public void afterClass() {
        this.deleteTempDir();
    }

    public void afterClassLoops() {
    }

    public void testFailure(Failure failure) {
    }

    @Inject
    protected void setSpincastConfig(ISpincastConfig spincastConfig) {
        this.spincastConfig = spincastConfig;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Injector getInjector() {
        return this.guice;
    }

    protected void deleteTempDir() {
        try {
            if (this.testingWritableDir != null) {
                FileUtils.deleteDirectory((File)this.testingWritableDir);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    protected File getTestingWritableDir() {
        if (this.testingWritableDir == null) {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            if (!baseDir.isDirectory()) {
                throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
            }
            this.testingWritableDir = new File(baseDir, "/spincast/testing");
            if (!this.testingWritableDir.isDirectory()) {
                boolean mkdirs = this.testingWritableDir.mkdirs();
                Assert.assertTrue((boolean)mkdirs);
            }
            Assert.assertTrue((boolean)this.testingWritableDir.canWrite());
        }
        return this.testingWritableDir;
    }

    protected String createTestingFilePath(String relativePath) {
        return this.getTestingWritableDir().getAbsolutePath() + "/" + relativePath;
    }

    protected String createTestingFilePath() {
        return this.createTestingFilePath(UUID.randomUUID().toString());
    }

    protected abstract Injector createInjector();
}

