/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import org.junit.Assert;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.testing.core.AppTestingConfigInfo;
import org.spincast.testing.core.IntegrationTestBase;

public abstract class IntegrationTestAppBase<R extends RequestContext<?>, W extends WebsocketContext<?>>
extends IntegrationTestBase<R, W> {
    @Override
    protected final boolean isGuiceTweakerAutoTestingConfigBindings() {
        AppTestingConfigInfo info = this.getAppTestingConfigInfo();
        return info != null && info.getSpincastConfigTestingImplementationClass() != null;
    }

    @Override
    protected final Class<? extends SpincastConfig> getGuiceTweakerConfigImplementationClass() {
        return this.getAppTestingConfigInfo().getSpincastConfigTestingImplementationClass();
    }

    @Override
    protected Module getGuiceTweakerOverridingModule() {
        if (!this.isGuiceTweakerAutoTestingConfigBindings() || this.getAppTestingConfigInfo().getAppConfigInterface() == null && this.getAppTestingConfigInfo().getAppConfigTestingImplementationClass() == null) {
            return super.getGuiceTweakerOverridingModule();
        }
        final AppTestingConfigInfo testingConfigs = this.getAppTestingConfigInfo();
        if (testingConfigs.getAppConfigTestingImplementationClass() == null) {
            throw new RuntimeException("The testing app configuration implementation can't be null for the the specified interface " + testingConfigs.getAppConfigInterface().getName());
        }
        if (testingConfigs.getAppConfigInterface() != null && !testingConfigs.getAppConfigInterface().isAssignableFrom(testingConfigs.getAppConfigTestingImplementationClass())) {
            throw new RuntimeException("The testing app configuration implementation \"" + testingConfigs.getAppConfigTestingImplementationClass() + "\" doesn't implement the specified interface " + testingConfigs.getAppConfigInterface().getName());
        }
        return Modules.override((Module[])new Module[]{super.getGuiceTweakerOverridingModule()}).with(new Module[]{new SpincastGuiceModuleBase(){

            protected void configure() {
                this.bind(testingConfigs.getAppConfigTestingImplementationClass()).in(Scopes.SINGLETON);
                if (testingConfigs.getAppConfigInterface() != null) {
                    this.bind(testingConfigs.getAppConfigInterface()).to(testingConfigs.getAppConfigTestingImplementationClass()).in(Scopes.SINGLETON);
                }
            }
        }});
    }

    protected abstract AppTestingConfigInfo getAppTestingConfigInfo();

    @Override
    protected Injector createInjector() {
        this.initApp();
        Injector injector = this.getGuiceTweakerFromThreadLocal().getInjector();
        Assert.assertNotNull((Object)injector);
        return injector;
    }

    protected abstract void initApp();
}

