/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastPlugin;
import org.spincast.core.routing.Router;
import org.spincast.core.server.Server;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.httpclient.builders.ConnectRequestBuilder;
import org.spincast.plugins.httpclient.builders.DeleteRequestBuilder;
import org.spincast.plugins.httpclient.builders.GetRequestBuilder;
import org.spincast.plugins.httpclient.builders.HeadRequestBuilder;
import org.spincast.plugins.httpclient.builders.OptionsRequestBuilder;
import org.spincast.plugins.httpclient.builders.PatchRequestBuilder;
import org.spincast.plugins.httpclient.builders.PostRequestBuilder;
import org.spincast.plugins.httpclient.builders.PutRequestBuilder;
import org.spincast.plugins.httpclient.builders.TraceRequestBuilder;
import org.spincast.plugins.httpclient.websocket.HttpClient;
import org.spincast.plugins.httpclient.websocket.SpincastHttpClientWithWebsocketPlugin;
import org.spincast.plugins.httpclient.websocket.builders.WebsocketRequestBuilder;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.client.utils.DateUtils;
import org.spincast.testing.core.SpincastTestBase;

public abstract class IntegrationTestBase<R extends RequestContext<?>, W extends WebsocketContext<?>>
extends SpincastTestBase {
    @Inject
    private HttpClient httpClient;
    @Inject
    private Server server;
    @Inject
    private Router<R, W> router;
    @Inject
    private CookieFactory cookieFactory;

    @Override
    protected List<SpincastPlugin> getGuiceTweakerPlugins() {
        List<SpincastPlugin> plugins = super.getGuiceTweakerPlugins();
        plugins.add((SpincastPlugin)new SpincastHttpClientWithWebsocketPlugin());
        return plugins;
    }

    @Override
    protected void validateCreatedInjector(Injector guice) {
        super.validateCreatedInjector(guice);
        try {
            guice.getBinding(HttpClient.class);
        }
        catch (Exception ex) {
            String msg = "By extending the " + IntegrationTestBase.class.getName() + " base class, your test class *must* bind those extra plugins in the Guice context :\n";
            for (SpincastPlugin plugin : this.getGuiceTweakerPlugins()) {
                msg = msg + "- " + plugin.getClass().getName() + "\n";
            }
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public void afterClass() {
        super.afterClass();
        this.stopServer();
    }

    protected void stopServer() {
        if (this.getServer() != null) {
            this.getServer().stop(false);
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected Server getServer() {
        return this.server;
    }

    protected String createTestUrl(String path) {
        return this.createTestUrl(path, false, false);
    }

    protected String createTestUrl(String path, boolean https) {
        return this.createTestUrl(path, false, https);
    }

    protected String createTestUrl(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        if (isFullUrl) {
            return pathOrUrl;
        }
        if (StringUtils.isBlank((CharSequence)pathOrUrl)) {
            pathOrUrl = "/";
        } else if (!pathOrUrl.startsWith("/")) {
            pathOrUrl = "/" + pathOrUrl;
        }
        return "http" + (isHttps ? "s" : "") + "://" + this.getSpincastConfig().getServerHost() + ":" + (isHttps ? this.getSpincastConfig().getHttpsServerPort() : this.getSpincastConfig().getHttpServerPort()) + pathOrUrl;
    }

    protected WebsocketRequestBuilder websocket(String path) {
        return this.websocket(path, false, false);
    }

    protected WebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl) {
        return this.websocket(pathOrUrl, isFullUrl, false);
    }

    protected WebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        WebsocketRequestBuilder builder = this.getHttpClient().websocket(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        return builder;
    }

    protected GetRequestBuilder GET(String path) {
        return this.GET(path, false, false);
    }

    protected GetRequestBuilder GET(String pathOrUrl, boolean isFullUrl) {
        return this.GET(pathOrUrl, isFullUrl, false);
    }

    protected GetRequestBuilder GET(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        GetRequestBuilder client = this.getHttpClient().GET(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected boolean isDisableSllCetificateErrors() {
        return true;
    }

    protected PostRequestBuilder POST(String path) {
        return this.POST(path, false, false);
    }

    protected PostRequestBuilder POST(String pathOrUrl, boolean isFullUrl) {
        return this.POST(pathOrUrl, isFullUrl, false);
    }

    protected PostRequestBuilder POST(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PostRequestBuilder client = this.getHttpClient().POST(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected PutRequestBuilder PUT(String path) {
        return this.PUT(path, false, false);
    }

    protected PutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl) {
        return this.PUT(pathOrUrl, isFullUrl, false);
    }

    protected PutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PutRequestBuilder client = this.getHttpClient().PUT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected DeleteRequestBuilder DELETE(String path) {
        return this.DELETE(path, false, false);
    }

    protected DeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl) {
        return this.DELETE(pathOrUrl, isFullUrl, false);
    }

    protected DeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        DeleteRequestBuilder client = this.getHttpClient().DELETE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected OptionsRequestBuilder OPTIONS(String path) {
        return this.OPTIONS(path, false, false);
    }

    protected OptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl) {
        return this.OPTIONS(pathOrUrl, isFullUrl, false);
    }

    protected OptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        OptionsRequestBuilder client = this.getHttpClient().OPTIONS(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected TraceRequestBuilder TRACE(String path) {
        return this.TRACE(path, false, false);
    }

    protected TraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl) {
        return this.TRACE(pathOrUrl, isFullUrl, false);
    }

    protected TraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        TraceRequestBuilder client = this.getHttpClient().TRACE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected ConnectRequestBuilder CONNECT(String path) {
        return this.CONNECT(path, false, false);
    }

    protected ConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl) {
        return this.CONNECT(pathOrUrl, isFullUrl, false);
    }

    protected ConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        ConnectRequestBuilder client = this.getHttpClient().CONNECT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected PatchRequestBuilder PATCH(String path) {
        return this.PATCH(path, false, false);
    }

    protected PatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl) {
        return this.PATCH(pathOrUrl, isFullUrl, false);
    }

    protected PatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PatchRequestBuilder client = this.getHttpClient().PATCH(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected HeadRequestBuilder HEAD(String path) {
        return this.HEAD(path, false, false);
    }

    protected HeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl) {
        return this.HEAD(pathOrUrl, isFullUrl, false);
    }

    protected HeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        HeadRequestBuilder client = this.getHttpClient().HEAD(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected String formatDate(Date date) {
        Objects.requireNonNull(date, "The date can't be NULL");
        return DateUtils.formatDate((Date)date);
    }

    protected Date parseDate(String dateHeaderValue) {
        Objects.requireNonNull(dateHeaderValue, "The dateHeaderValue can't be NULL");
        return DateUtils.parseDate((String)dateHeaderValue);
    }
}

