/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core.utils;

import com.google.inject.Inject;
import org.spincast.core.dictionary.DictionaryEntryNotFoundBehavior;
import org.spincast.plugins.config.SpincastConfigDefault;
import org.spincast.plugins.config.SpincastConfigPluginConfig;
import org.spincast.testing.core.utils.SpincastTestUtils;

public class SpincastConfigTestingDefault
extends SpincastConfigDefault {
    private int serverPort = -1;

    @Inject
    protected SpincastConfigTestingDefault(SpincastConfigPluginConfig spincastConfigPluginConfig) {
        super(spincastConfigPluginConfig);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public String getServerHost() {
        return "localhost";
    }

    public int getHttpServerPort() {
        if (this.serverPort == -1) {
            do {
                this.serverPort = SpincastTestUtils.findFreePort();
            } while (this.serverPort == 44419);
        }
        return this.serverPort;
    }

    public String getPublicUrlBase() {
        return "http://" + this.getServerHost() + ":" + this.getHttpServerPort();
    }

    public boolean isValidateLocalhostHost() {
        return false;
    }

    public boolean isEnableCookiesValidator() {
        return false;
    }

    public DictionaryEntryNotFoundBehavior getDictionaryEntryNotFoundBehavior() {
        return DictionaryEntryNotFoundBehavior.EXCEPTION;
    }
}

