/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runner.notification.Failure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.guice.GuiceTweaker;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastPlugin;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.testing.core.utils.SpincastConfigTestingDefault;
import org.spincast.testing.junitrunner.BeforeAfterClassMethodsProvider;
import org.spincast.testing.junitrunner.CanBeDisabled;
import org.spincast.testing.junitrunner.RepeatedClassAfterMethodProvider;
import org.spincast.testing.junitrunner.SpincastJUnitRunner;
import org.spincast.testing.junitrunner.TestFailureListener;

@RunWith(value=SpincastJUnitRunner.class)
public abstract class SpincastTestBase
implements BeforeAfterClassMethodsProvider,
TestFailureListener,
RepeatedClassAfterMethodProvider,
CanBeDisabled {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastTestBase.class);
    private Injector guice;
    private File testingWritableTempDir;
    private GuiceTweaker previousGuiceTweaker;
    private Map<String, String> extraSystemProperties;
    private Map<String, String> extraSystemPropertiesOriginal;
    @Inject
    protected SpincastConfig spincastConfig;

    public boolean isTestClassDisabledPreBeforeClass() {
        return false;
    }

    public boolean isTestClassDisabledPostBeforeClass() {
        return false;
    }

    public void beforeClass() {
        this.addExtraSystemProperties();
        this.previousGuiceTweaker = (GuiceTweaker)GuiceTweaker.threadLocal.get();
        GuiceTweaker.threadLocal.set(this.createGuiceTweaker());
        try {
            this.guice = this.createInjector();
        }
        finally {
            if (this.previousGuiceTweaker != null) {
                GuiceTweaker.threadLocal.set(this.previousGuiceTweaker);
            } else {
                GuiceTweaker.threadLocal.remove();
            }
        }
        this.validateCreatedInjector(this.guice);
        this.guice.injectMembers((Object)this);
    }

    protected void addExtraSystemProperties() {
        this.extraSystemProperties = this.getExtraSystemProperties();
        if (this.extraSystemProperties != null && this.extraSystemProperties.size() > 0) {
            this.extraSystemPropertiesOriginal = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.extraSystemProperties.entrySet()) {
                String key = entry.getKey();
                String original = System.getProperty(key);
                if (original != null) {
                    this.extraSystemPropertiesOriginal.put(entry.getKey(), System.getProperty(key));
                }
                System.setProperty(key, entry.getValue());
            }
        }
    }

    protected Map<String, String> getExtraSystemProperties() {
        return new HashMap<String, String>();
    }

    protected Set<Key<?>> getExtraExactBindingsToRemoveBeforePlugins() {
        return new HashSet();
    }

    protected void resetSystemProperties() {
        if (this.extraSystemProperties != null && this.extraSystemProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.extraSystemProperties.entrySet()) {
                String key = entry.getKey();
                String original = this.extraSystemPropertiesOriginal.get(key);
                if (original != null) {
                    System.setProperty(key, original);
                    continue;
                }
                System.clearProperty(key);
            }
        }
    }

    protected GuiceTweaker getGuiceTweakerFromThreadLocal() {
        return (GuiceTweaker)GuiceTweaker.threadLocal.get();
    }

    protected void validateCreatedInjector(Injector guice) {
        Assert.assertNotNull((Object)guice);
    }

    protected GuiceTweaker createGuiceTweaker() {
        Set<String> pluginIdsToDisable;
        GuiceTweaker guiceTweaker = new GuiceTweaker();
        List<SpincastPlugin> plugins = this.getGuiceTweakerExtraPlugins();
        if (plugins != null) {
            for (SpincastPlugin plugin : plugins) {
                guiceTweaker.plugin(plugin);
            }
        }
        this.tweakConfigurations(guiceTweaker);
        if (this.getGuiceTweakerExtraOverridingModule() != null) {
            guiceTweaker.overridingModule(this.getGuiceTweakerExtraOverridingModule());
        }
        if (this.isDisableBindCurrentClass()) {
            guiceTweaker.disableBindCurrentClass();
        }
        if ((pluginIdsToDisable = this.getGuiceTweakerPluginsToDisable()) != null && pluginIdsToDisable.size() > 0) {
            for (String pluginId : this.getGuiceTweakerPluginsToDisable()) {
                guiceTweaker.pluginToDisable(pluginId);
            }
        }
        return guiceTweaker;
    }

    protected Set<String> getGuiceTweakerPluginsToDisable() {
        return Sets.newHashSet();
    }

    protected void tweakConfigurations(GuiceTweaker guiceTweaker) {
        final Class<? extends SpincastConfig> configImplClass = this.getTestingConfigImplementationClass();
        if (configImplClass == null) {
            throw new RuntimeException("The 'getSpincastConfigTestingImplementationClass()' can't return null.");
        }
        guiceTweaker.bindingHierarchyToRemove(SpincastConfig.class);
        Set<Key<?>> extraExactBindingsToRemove = this.getExtraExactBindingsToRemoveBeforePlugins();
        if (extraExactBindingsToRemove != null) {
            for (Key<?> key : extraExactBindingsToRemove) {
                guiceTweaker.exactBindingToRemove(key);
            }
        }
        guiceTweaker.overridingModule((Module)new SpincastGuiceModuleBase(){

            protected void configure() {
                this.bind(configImplClass).in(Scopes.SINGLETON);
                this.bind(SpincastConfig.class).to(configImplClass).in(Scopes.SINGLETON);
            }
        });
    }

    protected boolean isDisableBindCurrentClass() {
        return false;
    }

    protected List<SpincastPlugin> getGuiceTweakerExtraPlugins() {
        return new ArrayList<SpincastPlugin>();
    }

    protected Module getGuiceTweakerExtraOverridingModule() {
        return new SpincastGuiceModuleBase(){

            protected void configure() {
            }
        };
    }

    protected Class<? extends SpincastConfig> getTestingConfigImplementationClass() {
        return SpincastConfigTestingDefault.class;
    }

    @Before
    public void beforeTest() {
    }

    @After
    public void afterTest() {
    }

    public void afterClass() {
        try {
            this.resetSystemProperties();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage());
        }
        this.deleteTestingWritableTempDir();
    }

    public void beforeClassException(Throwable ex) {
        this.resetSystemProperties();
    }

    public void afterClassLoops() {
    }

    public void testFailure(Failure failure) {
    }

    protected Injector getInjector() {
        return this.guice;
    }

    protected void deleteTestingWritableTempDir() {
        try {
            if (this.testingWritableTempDir != null) {
                FileUtils.deleteDirectory((File)this.testingWritableTempDir);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    protected File getTestingWritableTempDir() {
        if (this.testingWritableTempDir == null || !this.testingWritableTempDir.exists()) {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            if (!baseDir.isDirectory()) {
                throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
            }
            this.testingWritableTempDir = new File(baseDir, "/spincast/testing");
            if (!this.testingWritableTempDir.isDirectory()) {
                boolean mkdirs = this.testingWritableTempDir.mkdirs();
                Assert.assertTrue((boolean)mkdirs);
            }
            Assert.assertTrue((boolean)this.testingWritableTempDir.canWrite());
        }
        return this.testingWritableTempDir;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected String createTestingFilePath(String relativePath) {
        return this.getTestingWritableTempDir().getAbsolutePath() + "/" + relativePath;
    }

    protected String createTestingFilePath() {
        return this.createTestingFilePath(UUID.randomUUID().toString());
    }

    protected File createTestingDir() {
        String path = this.createTestingFilePath();
        File dir = new File(path);
        boolean result = dir.mkdirs();
        if (!result) {
            throw new RuntimeException("Unable to create testing temp dir at: " + path);
        }
        return dir;
    }

    protected abstract Injector createInjector();
}

