/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core.utils;

import com.google.inject.Inject;
import org.spincast.core.dictionary.DictionaryEntryNotFoundBehavior;
import org.spincast.core.guice.TestingMode;
import org.spincast.plugins.config.SpincastConfigDefault;
import org.spincast.plugins.config.SpincastConfigPluginConfig;
import org.spincast.testing.core.utils.SpincastTestingUtils;

public class SpincastConfigTestingDefault
extends SpincastConfigDefault {
    private int serverPort = -1;

    @Inject
    protected SpincastConfigTestingDefault(SpincastConfigPluginConfig spincastConfigPluginConfig, @TestingMode boolean testingMode) {
        super(spincastConfigPluginConfig, testingMode);
    }

    public boolean isDevelopmentMode() {
        return false;
    }

    public String getServerHost() {
        return "localhost";
    }

    public int getHttpServerPort() {
        return -1;
    }

    public int getHttpsServerPort() {
        if (this.serverPort == -1) {
            do {
                this.serverPort = SpincastTestingUtils.findFreePort();
            } while (this.serverPort >= 44440 && this.serverPort <= 44450);
        }
        return this.serverPort;
    }

    public String getPublicUrlBase() {
        return "https://" + this.getServerHost() + ":" + this.getHttpsServerPort();
    }

    public String getHttpsKeyStorePath() {
        return "spincast/testing/certificates/devKeyStore.jks";
    }

    public String getHttpsKeyStoreType() {
        return "JKS";
    }

    public String getHttpsKeyStoreStorePass() {
        return "myStorePass";
    }

    public String getHttpsKeyStoreKeyPass() {
        return "myKeyPass";
    }

    public boolean isValidateLocalhostHost() {
        return false;
    }

    public boolean isEnableCookiesValidator() {
        return false;
    }

    public DictionaryEntryNotFoundBehavior getDictionaryEntryNotFoundBehavior() {
        return DictionaryEntryNotFoundBehavior.EXCEPTION;
    }
}

