/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.junit.Assert;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.cookies.Cookie;
import org.spincast.core.cookies.CookieFactory;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.GuiceModuleUtils;
import org.spincast.core.guice.GuiceTweaker;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.guice.SpincastPlugin;
import org.spincast.core.routing.Router;
import org.spincast.core.server.Server;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.httpclient.HttpResponse;
import org.spincast.plugins.httpclient.builders.ConnectRequestBuilder;
import org.spincast.plugins.httpclient.builders.DeleteRequestBuilder;
import org.spincast.plugins.httpclient.builders.GetRequestBuilder;
import org.spincast.plugins.httpclient.builders.HeadRequestBuilder;
import org.spincast.plugins.httpclient.builders.OptionsRequestBuilder;
import org.spincast.plugins.httpclient.builders.PatchRequestBuilder;
import org.spincast.plugins.httpclient.builders.PostRequestBuilder;
import org.spincast.plugins.httpclient.builders.PutRequestBuilder;
import org.spincast.plugins.httpclient.builders.TraceRequestBuilder;
import org.spincast.plugins.httpclient.websocket.HttpClient;
import org.spincast.plugins.httpclient.websocket.SpincastHttpClientWithWebsocketPlugin;
import org.spincast.plugins.httpclient.websocket.builders.WebsocketRequestBuilder;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.shaded.org.apache.http.client.utils.DateUtils;
import org.spincast.testing.core.AppTestingConfigs;
import org.spincast.testing.core.SpincastTestBase;

public abstract class AppBasedTestingBase<R extends RequestContext<?>, W extends WebsocketContext<?>>
extends SpincastTestBase {
    private Set<Cookie> previousResponseCookies = new HashSet<Cookie>();
    @Inject
    private HttpClient httpClient;
    @Inject
    private Server server;
    @Inject
    private Router<R, W> router;
    @Inject
    private CookieFactory cookieFactory;

    @Override
    public void beforeClass() {
        super.beforeClass();
    }

    @Override
    protected final Injector createInjector() {
        this.callAppMainMethod();
        Injector injector = this.getGuiceTweakerFromThreadLocal().getInjector();
        Assert.assertNotNull((Object)injector);
        return injector;
    }

    @Override
    protected final Class<? extends SpincastConfig> getTestingConfigImplementationClass() {
        Class<? extends SpincastConfig> impl = this.getAppTestingConfigs().getSpincastConfigTestingImplementationClass();
        return impl != null ? impl : super.getTestingConfigImplementationClass();
    }

    @Override
    protected final boolean isDisableBindCurrentClass() {
        return !this.getAppTestingConfigs().isBindAppClass();
    }

    @Override
    protected Set<Key<?>> getExtraExactBindingsToRemoveBeforePlugins() {
        Set<Key<?>> extraExactBindingsToRemove = super.getExtraExactBindingsToRemoveBeforePlugins();
        extraExactBindingsToRemove.add(Key.get(SpincastConfig.class));
        if (this.getAppTestingConfigs().getAppConfigTestingImplementationClass() != null) {
            extraExactBindingsToRemove.add(Key.get(this.getAppTestingConfigs().getAppConfigTestingImplementationClass()));
        }
        if (this.getAppTestingConfigs().getAppConfigInterface() != null) {
            extraExactBindingsToRemove.add(Key.get(this.getAppTestingConfigs().getAppConfigInterface()));
        }
        if (this.getAppTestingConfigs().getSpincastConfigTestingImplementationClass() != null) {
            extraExactBindingsToRemove.add(Key.get(this.getAppTestingConfigs().getSpincastConfigTestingImplementationClass()));
        }
        return extraExactBindingsToRemove;
    }

    @Override
    protected final Module getGuiceTweakerExtraOverridingModule() {
        Object extraModuleUserSpecified = this.getExtraOverridingModule();
        if (extraModuleUserSpecified == null) {
            extraModuleUserSpecified = new SpincastGuiceModuleBase(){

                protected void configure() {
                }
            };
        }
        Module localModule = super.getGuiceTweakerExtraOverridingModule();
        final AppTestingConfigs testingConfigs = this.getAppTestingConfigs();
        if (this.getAppTestingConfigs().getAppConfigInterface() != null || this.getAppTestingConfigs().getAppConfigTestingImplementationClass() != null) {
            if (testingConfigs.getAppConfigTestingImplementationClass() == null) {
                throw new RuntimeException("The testing app configuration implementation can't be null for the the specified interface " + testingConfigs.getAppConfigInterface().getName());
            }
            if (testingConfigs.getAppConfigInterface() != null && !testingConfigs.getAppConfigInterface().isAssignableFrom(testingConfigs.getAppConfigTestingImplementationClass())) {
                throw new RuntimeException("The testing app configuration implementation \"" + testingConfigs.getAppConfigTestingImplementationClass() + "\" doesn't implement the specified interface " + testingConfigs.getAppConfigInterface().getName());
            }
            localModule = Modules.override((Module[])new Module[]{localModule}).with(new Module[]{new SpincastGuiceModuleBase(){

                protected void configure() {
                    this.bind(testingConfigs.getAppConfigTestingImplementationClass()).in(Scopes.SINGLETON);
                    if (testingConfigs.getAppConfigInterface() != null) {
                        this.bind(testingConfigs.getAppConfigInterface()).to(testingConfigs.getAppConfigTestingImplementationClass()).in(Scopes.SINGLETON);
                    }
                }
            }});
        }
        return Modules.override((Module[])new Module[]{localModule}).with(new Module[]{extraModuleUserSpecified});
    }

    @Override
    protected void tweakConfigurations(GuiceTweaker guiceTweaker) {
        super.tweakConfigurations(guiceTweaker);
        AppTestingConfigs testingConfigs = this.getAppTestingConfigs();
        Class<?> appConfigInterface = testingConfigs.getAppConfigInterface();
        if (appConfigInterface != null && SpincastConfig.class.isAssignableFrom(appConfigInterface)) {
            Class<? extends SpincastConfig> spincastConfigTestingImplementationClass = testingConfigs.getSpincastConfigTestingImplementationClass();
            SpincastGuiceModuleBase interceptModule = GuiceModuleUtils.createInterceptorModule(appConfigInterface, spincastConfigTestingImplementationClass, (boolean)this.isIgnoreMethodsAnnotatedWithInjectDuringConfigurationsTweaking());
            guiceTweaker.overridingModule((Module)interceptModule);
        }
    }

    protected boolean isIgnoreMethodsAnnotatedWithInjectDuringConfigurationsTweaking() {
        return true;
    }

    protected Module getExtraOverridingModule() {
        return new SpincastGuiceModuleBase(){

            protected void configure() {
            }
        };
    }

    @Override
    protected final List<SpincastPlugin> getGuiceTweakerExtraPlugins() {
        List<SpincastPlugin> plugins = super.getGuiceTweakerExtraPlugins();
        List<SpincastPlugin> pluginsUserDefined = this.getExtraPlugins();
        if (pluginsUserDefined != null) {
            plugins.addAll(pluginsUserDefined);
        }
        plugins.add((SpincastPlugin)new SpincastHttpClientWithWebsocketPlugin());
        return plugins;
    }

    protected List<SpincastPlugin> getExtraPlugins() {
        return Lists.newArrayList();
    }

    @Override
    protected void validateCreatedInjector(Injector guice) {
        super.validateCreatedInjector(guice);
        try {
            guice.getBinding(HttpClient.class);
        }
        catch (Exception ex) {
            String msg = "By extending the " + this.getClass().getName() + " base class, the " + HttpClient.class.getName() + " extra plugin must be bound in the Guice context.";
            throw new RuntimeException(msg, ex);
        }
    }

    @Override
    public void afterClass() {
        super.afterClass();
        this.stopServer();
    }

    protected void stopServer() {
        if (this.getServer() != null) {
            this.getServer().stop(false);
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected CookieFactory getCookieFactory() {
        return this.cookieFactory;
    }

    protected Server getServer() {
        return this.server;
    }

    protected String createTestUrl(String path) {
        return this.createTestUrl(path, false, true);
    }

    protected String createTestUrl(String path, boolean isHttps) {
        return this.createTestUrl(path, false, isHttps);
    }

    protected String createTestUrl(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        if (isFullUrl) {
            return pathOrUrl;
        }
        if (StringUtils.isBlank((CharSequence)pathOrUrl)) {
            pathOrUrl = "/";
        } else if (!((String)pathOrUrl).startsWith("/")) {
            pathOrUrl = "/" + (String)pathOrUrl;
        }
        String host = this.getSpincastConfig().getServerHost();
        if ("0.0.0.0".equals(host)) {
            host = "127.0.0.1";
        }
        return this.createTestUrl(host, (String)pathOrUrl, isHttps);
    }

    protected String createTestUrl(String host, String path, boolean isHttps) {
        return "http" + (isHttps ? "s" : "") + "://" + host + ":" + (isHttps ? this.getSpincastConfig().getHttpsServerPort() : this.getSpincastConfig().getHttpServerPort()) + path;
    }

    protected WebsocketRequestBuilder websocket(String path) {
        return this.websocket(path, false, true);
    }

    protected WebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl) {
        return this.websocket(pathOrUrl, isFullUrl, true);
    }

    protected WebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        WebsocketRequestBuilder builder = this.getHttpClient().websocket(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        return builder;
    }

    protected GetRequestBuilder GET(String path) {
        return this.GET(path, false, true);
    }

    protected GetRequestBuilder GET(String pathOrUrl, boolean isFullUrl) {
        return this.GET(pathOrUrl, isFullUrl, true);
    }

    protected GetRequestBuilder GET(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        GetRequestBuilder client = this.getHttpClient().GET(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected boolean isDisableSllCetificateErrors() {
        return true;
    }

    protected PostRequestBuilder POST(String path) {
        return this.POST(path, false, true);
    }

    protected PostRequestBuilder POST(String pathOrUrl, boolean isFullUrl) {
        return this.POST(pathOrUrl, isFullUrl, true);
    }

    protected PostRequestBuilder POST(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PostRequestBuilder client = this.getHttpClient().POST(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected PutRequestBuilder PUT(String path) {
        return this.PUT(path, false, true);
    }

    protected PutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl) {
        return this.PUT(pathOrUrl, isFullUrl, true);
    }

    protected PutRequestBuilder PUT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PutRequestBuilder client = this.getHttpClient().PUT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected DeleteRequestBuilder DELETE(String path) {
        return this.DELETE(path, false, true);
    }

    protected DeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl) {
        return this.DELETE(pathOrUrl, isFullUrl, true);
    }

    protected DeleteRequestBuilder DELETE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        DeleteRequestBuilder client = this.getHttpClient().DELETE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected OptionsRequestBuilder OPTIONS(String path) {
        return this.OPTIONS(path, false, true);
    }

    protected OptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl) {
        return this.OPTIONS(pathOrUrl, isFullUrl, true);
    }

    protected OptionsRequestBuilder OPTIONS(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        OptionsRequestBuilder client = this.getHttpClient().OPTIONS(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected TraceRequestBuilder TRACE(String path) {
        return this.TRACE(path, false, true);
    }

    protected TraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl) {
        return this.TRACE(pathOrUrl, isFullUrl, true);
    }

    protected TraceRequestBuilder TRACE(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        TraceRequestBuilder client = this.getHttpClient().TRACE(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected ConnectRequestBuilder CONNECT(String path) {
        return this.CONNECT(path, false, true);
    }

    protected ConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl) {
        return this.CONNECT(pathOrUrl, isFullUrl, true);
    }

    protected ConnectRequestBuilder CONNECT(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        ConnectRequestBuilder client = this.getHttpClient().CONNECT(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected PatchRequestBuilder PATCH(String path) {
        return this.PATCH(path, false, true);
    }

    protected PatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl) {
        return this.PATCH(pathOrUrl, isFullUrl, true);
    }

    protected PatchRequestBuilder PATCH(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        PatchRequestBuilder client = this.getHttpClient().PATCH(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected HeadRequestBuilder HEAD(String path) {
        return this.HEAD(path, false, true);
    }

    protected HeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl) {
        return this.HEAD(pathOrUrl, isFullUrl, true);
    }

    protected HeadRequestBuilder HEAD(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        HeadRequestBuilder client = this.getHttpClient().HEAD(this.createTestUrl(pathOrUrl, isFullUrl, isHttps));
        if (this.isDisableSllCetificateErrors()) {
            client.disableSslCertificateErrors();
        }
        return client;
    }

    protected String formatDate(Date date) {
        Objects.requireNonNull(date, "The date can't be NULL");
        return DateUtils.formatDate((Date)date);
    }

    protected Date parseDate(String dateHeaderValue) {
        Objects.requireNonNull(dateHeaderValue, "The dateHeaderValue can't be NULL");
        return DateUtils.parseDate((String)dateHeaderValue);
    }

    protected Set<Cookie> getPreviousResponseCookies() {
        if (this.previousResponseCookies == null) {
            this.previousResponseCookies = new HashSet<Cookie>();
        }
        return this.previousResponseCookies;
    }

    protected Cookie getPreviousResponseCookie(String cookieName) {
        if (cookieName == null) {
            return null;
        }
        for (Cookie cookie : this.getPreviousResponseCookies()) {
            if (cookie == null || !cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    protected void clearPreviousResponseCookies() {
        this.getPreviousResponseCookies().clear();
    }

    protected void saveResponseCookies(HttpResponse response) {
        this.clearPreviousResponseCookies();
        if (response == null) {
            return;
        }
        Map cookies = response.getCookies();
        if (cookies == null || cookies.size() == 0) {
            return;
        }
        for (Cookie cookie : cookies.values()) {
            if (!this.isSetSecureFalseOnCookiesFromBag()) continue;
            cookie.setSecure(false);
            this.getPreviousResponseCookies().add(cookie);
        }
    }

    protected boolean isSetSecureFalseOnCookiesFromBag() {
        return true;
    }

    protected abstract AppTestingConfigs getAppTestingConfigs();

    protected abstract void callAppMainMethod();
}

