/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core.h2;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import javax.sql.DataSource;
import org.h2.tools.Server;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.jdbc.JdbcQueries;
import org.spincast.plugins.jdbc.JdbcUtils;
import org.spincast.plugins.jdbc.SpincastDataSource;
import org.spincast.plugins.jdbc.SpincastDataSourceFactory;
import org.spincast.plugins.jdbc.statements.UpdateStatement;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.testing.core.h2.SpincastTestingH2Config;
import org.spincast.testing.core.utils.SpincastTestingUtils;

@Singleton
public class SpincastTestingH2
implements Provider<SpincastDataSource> {
    private final SpincastTestingH2Config spincastTestingH2Config;
    private final JdbcUtils jdbcUtils;
    private final SpincastDataSourceFactory spincastDataSourceFactory;
    private Server h2Server = null;
    private Integer serverPort;
    private SpincastDataSource dataSource;

    @Inject
    public SpincastTestingH2(SpincastTestingH2Config spincastTestingH2Config, JdbcUtils jdbcUtils, SpincastDataSourceFactory spincastDataSourceFactory) {
        this.spincastTestingH2Config = spincastTestingH2Config;
        this.jdbcUtils = jdbcUtils;
        this.spincastDataSourceFactory = spincastDataSourceFactory;
    }

    protected Server getH2Server() {
        return this.h2Server;
    }

    protected SpincastTestingH2Config getSpincastTestingH2Config() {
        return this.spincastTestingH2Config;
    }

    protected JdbcUtils getJdbcUtils() {
        return this.jdbcUtils;
    }

    protected SpincastDataSourceFactory getSpincastDataSourceFactory() {
        return this.spincastDataSourceFactory;
    }

    protected int getServerPort() {
        if (this.serverPort == null) {
            Integer port = this.getSpincastTestingH2Config().getServerPort();
            if (port == null) {
                port = SpincastTestingUtils.findFreePort();
            }
            this.serverPort = port;
        }
        return this.serverPort;
    }

    @Inject
    public void init() {
        try {
            this.h2Server = Server.createTcpServer((String[])new String[]{"-tcpPort", "" + this.getServerPort(), "-ifNotExists", "-tcpAllowOthers"}).start();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected String createConnectionString() {
        StringBuilder b = new StringBuilder();
        b.append("jdbc:h2:tcp://");
        b.append(this.getSpincastTestingH2Config().getServerHost()).append(":").append(this.getServerPort());
        b.append("/mem:").append(this.getSpincastTestingH2Config().getDatabaseName());
        b.append(";DATABASE_TO_UPPER=" + Boolean.toString(this.getSpincastTestingH2Config().isDatabaseToUpper()));
        String compatibilityMode = this.getSpincastTestingH2Config().getCompatibilityMode();
        if (!StringUtils.isBlank((CharSequence)compatibilityMode)) {
            b.append(";MODE=").append(compatibilityMode);
        }
        return b.toString();
    }

    public SpincastDataSource get() {
        if (this.dataSource == null) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.createConnectionString());
            config.setUsername("");
            config.setPassword("");
            config.setMaximumPoolSize(10);
            HikariDataSource ds = new HikariDataSource(config);
            this.dataSource = this.getSpincastDataSourceFactory().create((DataSource)ds);
        }
        return this.dataSource;
    }

    public void stopH2() {
        if (this.h2Server != null) {
            try {
                if (this.h2Server.isRunning(false)) {
                    this.h2Server.stop();
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    public void clearDatabase() {
        this.getJdbcUtils().scopes().autoCommit((DataSource)this.get(), (JdbcQueries)new JdbcQueries<Void>(){

            public Void run(Connection connection) {
                UpdateStatement stm = SpincastTestingH2.this.getJdbcUtils().statements().createUpdateStatement(connection);
                stm.sql("DROP ALL OBJECTS DELETE FILES ");
                stm.update();
                return null;
            }
        });
    }
}

