/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.junit.Assert;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.testing.core.utils.TrueChecker;

public class SpincastTestingUtils {
    public static final String TEST_STRING = "\u201b'\u00ef\u0153\ud84c\udfb4\ud840\udc0b\u16a1\u0160\u0161\u00c8\u00c6\u00e6\u00d0\u00f0\ud834\udd58\ud834\udd65\ud834\udd6f\u2019";
    public static final String TEST_STRING_LONG = "\u201b'\u00ef\u0153\ud84c\udfb4\ud840\udc0b\u16a1\u0160\u0161\u00c8\u00c6\u00e6\u00d0\u00f0\ud834\udd58\ud834\udd65\ud834\udd6f\u20190123456789asasdnalfh23uio4y4213ralksfan394u2348902ursdfjsdfj2534tuuegjdfgjdfgdgjmelfj234i2jsdjfsdjgdlkgjdlkfgjdgj9dgh09fgdhfdgksdjfasdfkasdf858656";
    private static Date testDate;
    public static final Handler<DefaultRequestContext> dummyRouteHandler;

    protected static InputStream getThisClassFileInputStream() {
        Object s = SpincastTestingUtils.class.getName();
        int i = ((String)s).lastIndexOf(".");
        if (i > -1) {
            s = ((String)s).substring(i + 1);
        }
        s = (String)s + ".class";
        return SpincastTestingUtils.class.getResourceAsStream((String)s);
    }

    public static File generateTempClassFile(File writableDir) {
        InputStream fileOriInputStream = null;
        try {
            File dir = new File(writableDir + "/TestUtils");
            fileOriInputStream = SpincastTestingUtils.getThisClassFileInputStream();
            File fileTarget = new File(dir.getAbsolutePath() + "/file" + UUID.randomUUID().toString() + ".class");
            FileUtils.copyInputStreamToFile((InputStream)fileOriInputStream, (File)fileTarget);
            return fileTarget;
        }
        catch (Exception ex) {
            SpincastStatics.closeQuietly(fileOriInputStream);
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public static int findFreePort() {
        int port = -1;
        try {
            try (ServerSocket s = null;){
                s = new ServerSocket(0);
                port = s.getLocalPort();
            }
            return port;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    public static boolean isPortAvailable(String host, int port) {
        try {
            new Socket(host, port).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean waitForTrue(TrueChecker trueChecker) {
        return SpincastTestingUtils.waitForTrue(trueChecker, 5000);
    }

    public static boolean waitForTrue(TrueChecker trueChecker, int maxMillisecToWait) {
        if (trueChecker == null) {
            throw new RuntimeException("The true checker can't be null");
        }
        if (maxMillisecToWait < 0) {
            maxMillisecToWait = 0;
        }
        try {
            int waitTimeTotal = 0;
            while (true) {
                if (trueChecker.check()) {
                    return true;
                }
                if (waitTimeTotal >= maxMillisecToWait) {
                    return false;
                }
                Thread.sleep(SpincastTestingUtils.waitForTrueLoopInterval());
                waitTimeTotal += SpincastTestingUtils.waitForTrueLoopInterval();
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    protected static int waitForTrueLoopInterval() {
        return 50;
    }

    public static boolean waitForSize(Collection<?> collection, int expected) {
        return SpincastTestingUtils.waitForSize(collection, expected, 5000);
    }

    public static boolean waitForSize(final Collection<?> collection, final int expected, int maxMillisecToWait) {
        Objects.requireNonNull(collection, "The collection can't be NULL");
        if (expected <= 0) {
            throw new RuntimeException("The expected size must be at least 1.");
        }
        return SpincastTestingUtils.waitForTrue(new TrueChecker(){

            @Override
            public boolean check() {
                return collection.size() >= expected;
            }
        }, maxMillisecToWait);
    }

    public static boolean waitForMaxSize(Collection<?> collection, int maxSize) {
        return SpincastTestingUtils.waitForMaxSize(collection, maxSize, 5000);
    }

    public static boolean waitForMaxSize(final Collection<?> collection, final int maxSize, int maxMillisecToWait) {
        Objects.requireNonNull(collection, "The collection can't be NULL");
        return SpincastTestingUtils.waitForTrue(new TrueChecker(){

            @Override
            public boolean check() {
                return collection.size() <= maxSize;
            }
        }, maxMillisecToWait);
    }

    public static boolean waitForNumber(int[] oneIntArray, int expected) {
        return SpincastTestingUtils.waitForNumber(oneIntArray, expected, 5000);
    }

    public static boolean waitForNumber(final int[] oneIntArray, final int expected, int maxMillisecToWait) {
        if (oneIntArray == null || oneIntArray.length == 0) {
            throw new RuntimeException("The array can't be null and must have at least (and probably only) one element.");
        }
        return SpincastTestingUtils.waitForTrue(new TrueChecker(){

            @Override
            public boolean check() {
                return oneIntArray[0] >= expected;
            }
        }, maxMillisecToWait);
    }

    public static Date getTestDateNoTime() {
        if (testDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            testDate = cal.getTime();
        }
        return testDate;
    }

    public static void logException(String fileName, Exception ex, String info) {
        try {
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            if (!baseDir.isDirectory()) {
                throw new RuntimeException("Temporary directory doesn't exist : " + baseDir.getAbsolutePath());
            }
            File dir = new File(baseDir, "/spincast_testing_exceptions");
            if (!dir.isDirectory()) {
                boolean mkdirs = dir.mkdirs();
                Assert.assertTrue((boolean)mkdirs);
            }
            Assert.assertTrue((boolean)dir.canWrite());
            File file = new File(dir.getAbsolutePath() + "/" + fileName);
            FileUtils.write((File)file, (CharSequence)(info + "\n" + ex.getMessage() + "\n" + SpincastStatics.getStackTrace((Throwable)ex)), (String)"UTF-8");
        }
        catch (Exception ex2) {
            System.err.println("Error logging testing exception: " + ex2);
        }
    }

    public static File getClasspathFileNotInJar(String relativePath) {
        if (relativePath == null) {
            return null;
        }
        try {
            relativePath = StringUtils.stripStart((String)relativePath, (String)"/");
            URL url = ClassLoader.getSystemResource(relativePath);
            if (url == null) {
                return null;
            }
            return Paths.get(url.toURI()).toFile();
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize((Exception)ex);
        }
    }

    static {
        dummyRouteHandler = new Handler<DefaultRequestContext>(){

            public void handle(DefaultRequestContext exchange) {
            }
        };
    }
}

