/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.defaults.testing;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.spincast.core.exchange.DefaultRequestContextDefault;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.GuiceTweaker;
import org.spincast.core.websocket.DefaultWebsocketContextDefault;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.defaults.bootstrapping.Spincast;
import org.spincast.defaults.bootstrapping.SpincastBootstrapper;
import org.spincast.testing.core.SpincastTestBase;

public class UnitTestBase
extends SpincastTestBase {
    private final Class<? extends RequestContext<?>> requestContextImplementationClass;
    private final Class<? extends WebsocketContext<?>> websocketContextImplementationClass;

    @Inject
    public UnitTestBase() {
        this(DefaultRequestContextDefault.class, DefaultWebsocketContextDefault.class);
    }

    public UnitTestBase(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        if (requestContextImplementationClass == null) {
            requestContextImplementationClass = DefaultRequestContextDefault.class;
        }
        if (websocketContextImplementationClass == null) {
            websocketContextImplementationClass = DefaultWebsocketContextDefault.class;
        }
        this.requestContextImplementationClass = requestContextImplementationClass;
        this.websocketContextImplementationClass = websocketContextImplementationClass;
    }

    protected Class<? extends RequestContext<?>> getRequestContextImplementationClass() {
        return this.requestContextImplementationClass;
    }

    protected Class<? extends WebsocketContext<?>> getWebsocketContextImplementationClass() {
        return this.websocketContextImplementationClass;
    }

    protected Injector createInjector() {
        SpincastBootstrapper builder = Spincast.configure().bindCurrentClass(false).requestContextImplementationClass(this.getRequestContextImplementationClass()).websocketContextImplementationClass(this.getWebsocketContextImplementationClass());
        if (this.getExtraOverridingModule() != null) {
            builder.module(this.getExtraOverridingModule());
        }
        return builder.init();
    }

    protected GuiceTweaker createGuiceTweaker() {
        GuiceTweaker guiceTweaker = super.createGuiceTweaker();
        if (guiceTweaker == null) {
            guiceTweaker = new GuiceTweaker();
        }
        guiceTweaker.bindCurrentClassByDefault(false);
        return guiceTweaker;
    }

    protected Module getExtraOverridingModule() {
        return null;
    }
}

