/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.defaults.testing;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exchange.DefaultRequestContext;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.core.websocket.WebsocketEndpointManager;
import org.spincast.plugins.httpclient.HttpResponse;
import org.spincast.plugins.httpclient.utils.SpincastHttpClientUtils;
import org.spincast.plugins.httpclient.websocket.builders.WebsocketRequestBuilder;
import org.spincast.plugins.undertow.config.SpincastUndertowConfig;
import org.spincast.plugins.undertow.config.SpincastUndertowConfigDefault;
import org.spincast.testing.core.AppBasedTestingBase;
import org.spincast.testing.core.utils.SpincastTestUtils;
import org.spincast.testing.core.utils.TrueChecker;

public abstract class AppBasedWebsocketTestingBase<R extends RequestContext<?>, W extends WebsocketContext<?>>
extends AppBasedTestingBase<DefaultRequestContext, W> {
    protected final Logger logger = LoggerFactory.getLogger(AppBasedWebsocketTestingBase.class);
    @Inject
    protected SpincastHttpClientUtils spincastHttpClientUtils;
    private String expectedWebsocketV13AcceptHeaderValue;
    private String secSocketKey;

    protected Module getExtraOverridingModule2() {
        Object extraModuleUserSpecified = this.getExtraOverridingModule3();
        if (extraModuleUserSpecified == null) {
            extraModuleUserSpecified = new SpincastGuiceModuleBase(){

                protected void configure() {
                }
            };
        }
        return Modules.override((Module[])new Module[]{new SpincastGuiceModuleBase(){

            protected void configure() {
                this.bind(SpincastUndertowConfig.class).toInstance((Object)AppBasedWebsocketTestingBase.this.getSpincastUndertowConfigImplementation());
            }
        }}).with(new Module[]{extraModuleUserSpecified});
    }

    protected Module getExtraOverridingModule3() {
        return null;
    }

    protected SpincastUndertowConfig getSpincastUndertowConfigImplementation() {
        return new SpincastUndertowConfigDefault(){

            public int getWebsocketAutomaticPingIntervalSeconds() {
                return AppBasedWebsocketTestingBase.this.getServerPingIntervalSeconds();
            }
        };
    }

    protected SpincastHttpClientUtils getSpincastHttpClientUtils() {
        return this.spincastHttpClientUtils;
    }

    public void beforeTest() {
        super.beforeTest();
        this.closeAllWebsocketEndpoints();
    }

    protected int getServerPingIntervalSeconds() {
        return 1;
    }

    protected void closeAllWebsocketEndpoints() {
        List websocketEndpointManagers = this.getServer().getWebsocketEndpointManagers();
        for (WebsocketEndpointManager manager : websocketEndpointManagers) {
            manager.closeEndpoint(false);
        }
        Assert.assertTrue((boolean)SpincastTestUtils.waitForTrue((TrueChecker)new TrueChecker(){

            public boolean check() {
                return AppBasedWebsocketTestingBase.this.getServer().getWebsocketEndpointManagers().size() == 0;
            }
        }));
    }

    protected String getWebsocketTestExpectedWebsocketV13AcceptHeaderValue() {
        if (this.expectedWebsocketV13AcceptHeaderValue == null) {
            this.expectedWebsocketV13AcceptHeaderValue = this.getSpincastHttpClientUtils().generateExpectedWebsocketV13AcceptHeaderValue(this.getSecSocketKey());
        }
        return this.expectedWebsocketV13AcceptHeaderValue;
    }

    protected String getSecSocketKey() {
        if (this.secSocketKey == null) {
            this.secSocketKey = UUID.randomUUID().toString();
        }
        return this.secSocketKey;
    }

    protected void validateIsWebsocketUpgradeHttpResponse(String path, HttpResponse response) {
        Assert.assertNotNull((Object)response);
        String upgradeHeader = response.getHeaderFirst("Upgrade");
        Assert.assertNotNull((Object)upgradeHeader);
        Assert.assertEquals((Object)"WebSocket", (Object)upgradeHeader);
        String locationHeader = response.getHeaderFirst("Sec-WebSocket-Location");
        Assert.assertNotNull((Object)locationHeader);
        Assert.assertEquals((Object)("ws://" + this.getSpincastConfig().getServerHost() + ":" + this.getSpincastConfig().getHttpServerPort() + path), (Object)locationHeader);
        String connectionHeader = response.getHeaderFirst("Connection");
        Assert.assertNotNull((Object)connectionHeader);
        Assert.assertEquals((Object)"Upgrade", (Object)connectionHeader);
        String websocketAcceptHeader = response.getHeaderFirst("Sec-WebSocket-Accept");
        Assert.assertNotNull((Object)websocketAcceptHeader);
        Assert.assertEquals((Object)this.getWebsocketTestExpectedWebsocketV13AcceptHeaderValue(), (Object)websocketAcceptHeader);
    }

    protected void validateIsNotWebsocketUpgradeHttpResponse(HttpResponse response) {
        String upgradeHeader = response.getHeaderFirst("Upgrade");
        Assert.assertNull((Object)upgradeHeader);
        String websocketAcceptHeader = response.getHeaderFirst("Sec-WebSocket-Accept");
        Assert.assertNull((Object)websocketAcceptHeader);
    }

    protected WebsocketRequestBuilder websocket(String pathOrUrl, boolean isFullUrl, boolean isHttps) {
        WebsocketRequestBuilder builder = super.websocket(pathOrUrl, isFullUrl, isHttps);
        builder.addHeaderValue("Sec-WebSocket-Key", this.getSecSocketKey());
        return builder;
    }
}

