/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.junitrunner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.testing.junitrunner.BeforeAfterClassMethodsProvider;
import org.spincast.testing.junitrunner.CanBeDisabled;
import org.spincast.testing.junitrunner.ExpectingBeforeClassException;
import org.spincast.testing.junitrunner.ExpectingFailure;
import org.spincast.testing.junitrunner.IgnoreErrorButStopLoops;
import org.spincast.testing.junitrunner.NoTestsFrameworkMethod;
import org.spincast.testing.junitrunner.RepeatUntilFailure;
import org.spincast.testing.junitrunner.RepeatUntilSuccess;
import org.spincast.testing.junitrunner.RepeatedClassAfterMethodProvider;
import org.spincast.testing.junitrunner.TestFailureListener;

public class SpincastJUnitRunner
extends BlockJUnit4ClassRunner {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastJUnitRunner.class);
    public static final String SPINCAST_TEST_NAME_BEFORE_CLASS_ANNOTATIONS_VALIDATION = "[Spincast] @" + BeforeClass.class.getSimpleName() + " annotations validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_ANNOTATIONS_VALIDATION = "[Spincast] @" + AfterClass.class.getSimpleName() + " annotations validation";
    public static final String SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION = "[Spincast] beforeClass method validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_METHOD_VALIDATION = "[Spincast] afterClass method validation";
    public static final String SPINCAST_TEST_NAME_NO_TESTS_AND_NO_EXPECTION_EXCEPTION_ANNOTATION = "[Spincast] No tests and no @" + ExpectingBeforeClassException.class.getSimpleName() + " validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_LOOPS_EXCEPTION = "[Spincast] afterClassLoops method validation";
    public static final String SPINCAST_TEST_NAME_REPEAT_ANNOTATIONS_VALIDATION = "[Spincast] @" + RepeatUntilSuccess.class.getSimpleName() + " and @" + RepeatUntilFailure.class.getSimpleName() + " annotations validation";
    public static final String SPINCAST_TEST_NAME_EXPECTING_FAILURE_BUT_ONLY_SUCCESSES = "[Spincast] @" + ExpectingFailure.class.getSimpleName() + " annotation but only successes!";
    private Object testClassInstance = null;
    private boolean exceptionInBeforeClass = false;
    private Boolean isExpectingBeforeClassException = null;
    private Boolean isExpectingFailure = null;
    private boolean currentTestFailed = false;
    private boolean atLeastOneTestFailedInAllLoops = false;
    private boolean atLeastOneTestFailedInCurrentLoop = false;
    private boolean stopLoopsForced = false;
    private RunNotifier runNotifier = null;
    private int currentClassLoopPosition = 1;
    private boolean ignoreRemainingTests = false;
    private boolean isLastLoop = false;
    private boolean isLastSingleTestLoop = false;

    public SpincastJUnitRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected RunNotifier getRunNotifier() {
        return this.runNotifier;
    }

    protected void setIgnoreRemainingTests() {
        this.ignoreRemainingTests = true;
    }

    protected boolean isIgnoreRemainingTests() {
        return this.ignoreRemainingTests;
    }

    protected void setExceptionInBeforeClass() {
        this.exceptionInBeforeClass = true;
    }

    protected boolean isExceptionInBeforeClass() {
        return this.exceptionInBeforeClass;
    }

    protected int getCurrentClassLoopPosition() {
        return this.currentClassLoopPosition;
    }

    public Object createTest() throws Exception {
        if (this.testClassInstance == null) {
            this.testClassInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        }
        return this.testClassInstance;
    }

    protected Object getTestClassInstance() {
        try {
            return this.createTest();
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    protected String getName() {
        String name = super.getName();
        Integer repeatUntilFailureLoopsNbr = this.getTestClassRepeatUntilFailureAnnotationLoopsNbr();
        Integer repeatUntilSuccessLoopsNbr = this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr();
        Integer loopsNbr = 1;
        if (repeatUntilFailureLoopsNbr != null) {
            loopsNbr = repeatUntilFailureLoopsNbr;
        } else if (repeatUntilSuccessLoopsNbr != null) {
            loopsNbr = repeatUntilSuccessLoopsNbr;
        }
        if (loopsNbr > 1) {
            name = name + " [" + loopsNbr + " loops]";
        }
        return name;
    }

    protected final List<FrameworkMethod> computeTestMethods() {
        ArrayList<NoTestsFrameworkMethod> tests = super.computeTestMethods();
        if (tests == null || tests.size() == 0) {
            tests = new ArrayList<NoTestsFrameworkMethod>(tests);
            tests.add(new NoTestsFrameworkMethod());
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        this.runNotifier = notifier;
        this.stopLoopsForced = false;
        this.isLastLoop = false;
        if (this.getTestClassInstance() instanceof CanBeDisabled && ((CanBeDisabled)this.getTestClassInstance()).isTestClassDisabledPreBeforeClass()) {
            logger.info("Test class disabled (pre 'beforeClass')! Skipping...");
            return;
        }
        this.addTestFailureListener(notifier);
        this.runPreClassLoopsSpincastTests();
        try {
            Integer repeatUntilFailureLoopsNbr = this.getTestClassRepeatUntilFailureAnnotationLoopsNbr();
            Integer repeatUntilFailureSleep = this.getTestClassRepeatUntilFailureAnnotationLoopsSleep();
            Integer repeatUntilSuccessLoopsNbr = this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr();
            Integer repeatUntilSuccessSleep = this.getTestClassRepeatUntilSuccessAnnotationLoopsSleep();
            int loopNbr = 1;
            if (repeatUntilFailureLoopsNbr != null) {
                loopNbr = repeatUntilFailureLoopsNbr;
            } else if (repeatUntilSuccessLoopsNbr != null) {
                loopNbr = repeatUntilSuccessLoopsNbr;
            }
            int sleep = 0;
            if (repeatUntilFailureSleep != null) {
                sleep = repeatUntilFailureSleep;
            } else if (repeatUntilSuccessSleep != null) {
                sleep = repeatUntilSuccessSleep;
            }
            try {
                for (int i = 0; i < loopNbr; ++i) {
                    String msg;
                    this.currentClassLoopPosition = i + 1;
                    this.atLeastOneTestFailedInCurrentLoop = false;
                    boolean bl = this.isLastLoop = i == loopNbr - 1;
                    if (loopNbr > 1) {
                        logger.info("Running loop " + this.getCurrentClassLoopPosition() + "/" + loopNbr + " of test class " + this.getTestClass().getJavaClass().getName());
                    }
                    this.testClassInstance = null;
                    if (this.getTestClassInstance() instanceof BeforeAfterClassMethodsProvider) {
                        try {
                            ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).beforeClass();
                            if (this.isExpectingBeforeClassException()) {
                                msg = "An exception was expected in the 'beforeClass()' method since the @" + ExpectingBeforeClassException.class.getSimpleName() + " is used on the class, but none occured.";
                                this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, msg);
                            }
                        }
                        catch (Throwable ex) {
                            this.setExceptionInBeforeClass();
                            this.setIgnoreRemainingTests();
                            if (!this.isExpectingBeforeClassException()) {
                                this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, ex);
                            }
                            try {
                                ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).beforeClassException(ex);
                            }
                            catch (Exception ex2) {
                                logger.error("Error managing the 'beforeClass' exception : ", (Throwable)ex2);
                            }
                        }
                    } else if (this.isExpectingBeforeClassException()) {
                        msg = "The @" + ExpectingBeforeClassException.class.getSimpleName() + " annotation can only be used on a class implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
                        this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, msg);
                    }
                    if (this.getTestClassInstance() instanceof CanBeDisabled && ((CanBeDisabled)this.getTestClassInstance()).isTestClassDisabledPostBeforeClass()) {
                        logger.info("Test class disabled (post 'beforeClass')! Skipping...");
                        return;
                    }
                    super.run(notifier);
                    if (!this.isIgnoreRemainingTests() && this.getTestClassInstance() instanceof BeforeAfterClassMethodsProvider) {
                        try {
                            ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).afterClass();
                        }
                        catch (Throwable ex) {
                            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_METHOD_VALIDATION, ex);
                            break;
                        }
                    }
                    if (this.stopLoopsForced || i >= loopNbr - 1 || (!this.atLeastOneTestFailedInCurrentLoop ? repeatUntilSuccessLoopsNbr != null : repeatUntilFailureLoopsNbr != null)) break;
                    if (sleep <= 0) continue;
                    try {
                        Thread.sleep(sleep);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.isExpectingFailure() && !this.atLeastOneTestFailedInAllLoops) {
                    String msg = "There were no failures but we were expecting some.";
                    this.spincastTestError(SPINCAST_TEST_NAME_EXPECTING_FAILURE_BUT_ONLY_SUCCESSES, msg);
                }
            }
            finally {
                if (this.getTestClassInstance() instanceof RepeatedClassAfterMethodProvider) {
                    if (!this.isExceptionInBeforeClass()) {
                        try {
                            ((RepeatedClassAfterMethodProvider)this.getTestClassInstance()).afterClassLoops();
                        }
                        catch (Throwable ex) {
                            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_LOOPS_EXCEPTION, ex);
                        }
                    } else {
                        logger.info("An exception occured in the 'beforeClass()' method, so the 'afterClassLoops()' method won't be called.");
                    }
                }
            }
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
        finally {
            Integer classLoopsNbr = 1;
            if (this.getTestClassRepeatUntilFailureAnnotationLoopsNbr() != null) {
                classLoopsNbr = this.getTestClassRepeatUntilFailureAnnotationLoopsNbr();
            } else if (this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr() != null) {
                classLoopsNbr = this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr();
            }
            if (this.atLeastOneTestFailedInAllLoops && classLoopsNbr != null && classLoopsNbr > 1) {
                logger.error("The test failure occured during the class loop #" + this.getCurrentClassLoopPosition());
            }
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (NoTestsFrameworkMethod.class.getName().equals(method.getDeclaringClass().getName())) {
            Description description = this.describeChild(method);
            notifier.fireTestStarted(description);
            notifier.fireTestFinished(description);
            return;
        }
        if (this.isIgnoreRemainingTests()) {
            Description description = this.describeChild(method);
            notifier.fireTestIgnored(description);
            return;
        }
        this.isLastSingleTestLoop = false;
        Method methodObj = method.getMethod();
        Integer repeatUntilFailureLoopsNbr = this.getMethodRepeatUntilFailureAnnotationLoopsNbr(methodObj);
        Integer repeatUntilFailureSleep = this.getMethodRepeatUntilFailureAnnotationLoopsSleep(methodObj);
        Integer repeatUntilSuccessLoopsNbr = this.getMethodRepeatUntilSuccessAnnotationLoopsNbr(methodObj);
        Integer repeatUntilSuccessSleep = this.getMethodRepeatUntilSuccessAnnotationLoopsSleep(methodObj);
        int loopNbr = 1;
        if (repeatUntilFailureLoopsNbr != null && repeatUntilSuccessLoopsNbr != null) {
            String msg = "Only one of the @" + RepeatUntilSuccess.class.getSimpleName() + " or @" + RepeatUntilFailure.class.getSimpleName() + " annotation can be used at the time.";
            this.spincastTestError(SPINCAST_TEST_NAME_REPEAT_ANNOTATIONS_VALIDATION, msg);
            return;
        }
        if (repeatUntilFailureLoopsNbr != null) {
            loopNbr = repeatUntilFailureLoopsNbr;
        } else if (repeatUntilSuccessLoopsNbr != null) {
            loopNbr = repeatUntilSuccessLoopsNbr;
        }
        int sleep = 0;
        if (repeatUntilFailureSleep != null) {
            sleep = repeatUntilFailureSleep;
        } else if (repeatUntilSuccessSleep != null) {
            sleep = repeatUntilSuccessSleep;
        }
        for (int i = 0; i < loopNbr; ++i) {
            boolean bl = this.isLastSingleTestLoop = i == loopNbr - 1;
            if (loopNbr > 1) {
                logger.info("Execution " + (i + 1) + "/" + loopNbr + " of test " + method.getMethod().getName() + " from test class " + this.getTestClass().getJavaClass().getName());
            }
            this.currentTestFailed = false;
            super.runChild(method, notifier);
            if (this.stopLoopsForced || i >= loopNbr - 1) break;
            if (this.currentTestFailed) {
                if (repeatUntilFailureLoopsNbr != null) {
                    logger.error("The test \"" + method.getMethod().getName() + "\" failed during the loop #" + (i + 1));
                    break;
                }
            } else if (repeatUntilSuccessLoopsNbr != null) {
                logger.info("The test \"" + method.getMethod().getName() + "\" succeeded during the loop #" + (i + 1));
                break;
            }
            if (sleep <= 0) continue;
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return this.customizeStatement(super.methodBlock(method), method);
    }

    protected Statement customizeStatement(Statement statement, FrameworkMethod method) {
        statement = this.addCustomErrorHandling(statement, method);
        return statement;
    }

    protected Statement addCustomErrorHandling(final Statement baseStatement, final FrameworkMethod method) {
        Statement statement = new Statement(){

            public void evaluate() throws Throwable {
                try {
                    baseStatement.evaluate();
                }
                catch (Throwable ex22) {
                    RuntimeException ex22;
                    Description description = SpincastJUnitRunner.this.describeChild(method);
                    if (description.getAnnotation(IgnoreErrorButStopLoops.class) != null) {
                        SpincastJUnitRunner.this.stopLoopsForced = true;
                        logger.info("The test failed, but is annotated with @" + IgnoreErrorButStopLoops.class.getSimpleName() + " so we don't show it as an error but stop any test loops.");
                    }
                    if ((SpincastJUnitRunner.this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr() != null || SpincastJUnitRunner.this.getMethodRepeatUntilSuccessAnnotationLoopsNbr(method.getMethod()) != null) && !SpincastJUnitRunner.this.isLastInstanceOfThisTestToRun() || SpincastJUnitRunner.this.isExpectingFailure()) {
                        SpincastJUnitRunner.this.testFailureCustomHandling(new Failure(description, ex22));
                    }
                    if (SpincastJUnitRunner.this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr() != null) {
                        String msg = "The @" + RepeatUntilSuccess.class.getSimpleName() + " annotation was used on the test class but there was no success after " + SpincastJUnitRunner.this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr() + " loops.";
                        ex22 = new RuntimeException(msg, ex22);
                    } else if (SpincastJUnitRunner.this.getMethodRepeatUntilSuccessAnnotationLoopsNbr(method.getMethod()) != null) {
                        String msg = "The @" + RepeatUntilSuccess.class.getSimpleName() + " annotation was used on the test method but there was no success after " + SpincastJUnitRunner.this.getMethodRepeatUntilSuccessAnnotationLoopsNbr(method.getMethod()) + " loops.";
                        ex22 = new RuntimeException(msg, ex22);
                    }
                    throw ex22;
                }
            }
        };
        return statement;
    }

    protected void addTestFailureListener(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                SpincastJUnitRunner.this.testFailureCustomHandling(failure);
            }
        });
    }

    protected void testFailureCustomHandling(Failure failure) {
        this.currentTestFailed = true;
        this.atLeastOneTestFailedInCurrentLoop = true;
        this.atLeastOneTestFailedInAllLoops = true;
        this.logTestFailure(failure);
        if (this.testClassInstance instanceof TestFailureListener) {
            ((TestFailureListener)this.testClassInstance).testFailure(failure);
        }
    }

    protected void logTestFailure(Failure failure) {
        System.err.println(this.getStackTrace(failure.getException()));
    }

    protected boolean isLastInstanceOfThisTestToRun() {
        return this.isLastLoop && this.isLastSingleTestLoop;
    }

    protected void runPreClassLoopsSpincastTests() {
        this.validateNoBeforeClassAnnotations();
        this.validateNoAfterClassAnnotations();
        this.validateNoTestsAndNoExpectingBeforeClassExceptionAnnotation();
        this.validateTestClassRepeateAnnotations();
    }

    protected void validateNoBeforeClassAnnotations() {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        if (befores != null && befores.size() > 0) {
            String msg = "The @BeforeClass JUnit annotation can't be used with the " + SpincastJUnitRunner.class.getSimpleName() + " custom runner. Use the beforeClass() method instead by implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
            this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_ANNOTATIONS_VALIDATION, msg);
        }
    }

    protected void validateNoAfterClassAnnotations() {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        if (afters != null && afters.size() > 0) {
            String msg = "The @AfterClass JUnit annotation can't be used with the " + SpincastJUnitRunner.class.getSimpleName() + " custom runner. Use the afterClass() method instead by implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_ANNOTATIONS_VALIDATION, msg);
        }
    }

    protected void validateNoTestsAndNoExpectingBeforeClassExceptionAnnotation() {
        List regularTests = SpincastJUnitRunner.super.computeTestMethods();
        if (!(regularTests != null && regularTests.size() != 0 || this.isExpectingBeforeClassException())) {
            String msg = "There must be at least one @Test or the @" + ExpectingBeforeClassException.class.getSimpleName() + " must be present.";
            this.spincastTestError(SPINCAST_TEST_NAME_NO_TESTS_AND_NO_EXPECTION_EXCEPTION_ANNOTATION, msg);
        }
    }

    protected void validateTestClassRepeateAnnotations() {
        Integer repeatUntilFailureLoopsNbr = this.getTestClassRepeatUntilFailureAnnotationLoopsNbr();
        Integer repeatUntilSuccessLoopsNbr = this.getTestClassRepeatUntilSuccessAnnotationLoopsNbr();
        if (repeatUntilFailureLoopsNbr != null && repeatUntilSuccessLoopsNbr != null) {
            String msg = "Only one of the @" + RepeatUntilSuccess.class.getSimpleName() + " or " + RepeatUntilFailure.class.getSimpleName() + " annotation can be used at the time.";
            this.spincastTestError(SPINCAST_TEST_NAME_REPEAT_ANNOTATIONS_VALIDATION, msg);
        }
    }

    protected void spincastTestError(String testName, String errorMessage) {
        this.spincastTestError(testName, new RuntimeException(errorMessage));
    }

    protected void spincastTestError(String testName, Throwable exception) {
        logger.error("Test error", exception);
        if (this.isExpectingFailure()) {
            logger.info("Error expected due to the " + ExpectingFailure.class.getSimpleName() + " annotation. Error ignored.");
            return;
        }
        Description description = Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)testName);
        this.setIgnoreRemainingTests();
        this.getRunNotifier().fireTestStarted(description);
        this.getRunNotifier().fireTestFailure(new Failure(description, exception));
        this.getRunNotifier().fireTestFinished(description);
    }

    protected String getStackTrace(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public boolean isExpectingBeforeClassException() {
        if (this.isExpectingBeforeClassException == null) {
            this.isExpectingBeforeClassException = this.getTestClass().getAnnotation(ExpectingBeforeClassException.class) != null;
        }
        return this.isExpectingBeforeClassException;
    }

    public boolean isExpectingFailure() {
        if (this.isExpectingFailure == null) {
            this.isExpectingFailure = this.getTestClass().getAnnotation(ExpectingFailure.class) != null;
        }
        return this.isExpectingFailure;
    }

    protected Integer getTestClassRepeatUntilFailureAnnotationLoopsNbr() {
        return this.geRepeatUntilFailureAnnotationLoopsNbr((RepeatUntilFailure)this.getTestClass().getAnnotation(RepeatUntilFailure.class));
    }

    protected Integer getMethodRepeatUntilFailureAnnotationLoopsNbr(Method method) {
        return this.geRepeatUntilFailureAnnotationLoopsNbr(method.getAnnotation(RepeatUntilFailure.class));
    }

    protected Integer geRepeatUntilFailureAnnotationLoopsNbr(RepeatUntilFailure repeatUntilFailureAnnotation) {
        if (repeatUntilFailureAnnotation == null) {
            return null;
        }
        int loopsNbr = 1;
        if (repeatUntilFailureAnnotation != null && (loopsNbr = repeatUntilFailureAnnotation.value()) < 1) {
            loopsNbr = 1;
        }
        return loopsNbr;
    }

    protected Integer getTestClassRepeatUntilFailureAnnotationLoopsSleep() {
        return this.getRepeatUntilFailureAnnotationLoopsSleep((RepeatUntilFailure)this.getTestClass().getAnnotation(RepeatUntilFailure.class));
    }

    protected Integer getMethodRepeatUntilFailureAnnotationLoopsSleep(Method method) {
        return this.getRepeatUntilFailureAnnotationLoopsSleep(method.getAnnotation(RepeatUntilFailure.class));
    }

    protected Integer getRepeatUntilFailureAnnotationLoopsSleep(RepeatUntilFailure repeatAnnotation) {
        if (repeatAnnotation == null) {
            return null;
        }
        return repeatAnnotation.sleep();
    }

    protected Integer getTestClassRepeatUntilSuccessAnnotationLoopsNbr() {
        return this.geRepeatUntilSuccessAnnotationLoopsNbr((RepeatUntilSuccess)this.getTestClass().getAnnotation(RepeatUntilSuccess.class));
    }

    protected Integer getMethodRepeatUntilSuccessAnnotationLoopsNbr(Method method) {
        return this.geRepeatUntilSuccessAnnotationLoopsNbr(method.getAnnotation(RepeatUntilSuccess.class));
    }

    protected Integer geRepeatUntilSuccessAnnotationLoopsNbr(RepeatUntilSuccess repeatUntilSuccessAnnotation) {
        if (repeatUntilSuccessAnnotation == null) {
            return null;
        }
        int loopsNbr = 1;
        if (repeatUntilSuccessAnnotation != null && (loopsNbr = repeatUntilSuccessAnnotation.value()) < 1) {
            loopsNbr = 1;
        }
        return loopsNbr;
    }

    protected Integer getTestClassRepeatUntilSuccessAnnotationLoopsSleep() {
        return this.getRepeatUntilSuccessAnnotationLoopsSleep((RepeatUntilSuccess)this.getTestClass().getAnnotation(RepeatUntilSuccess.class));
    }

    protected Integer getMethodRepeatUntilSuccessAnnotationLoopsSleep(Method method) {
        return this.getRepeatUntilSuccessAnnotationLoopsSleep(method.getAnnotation(RepeatUntilSuccess.class));
    }

    protected Integer getRepeatUntilSuccessAnnotationLoopsSleep(RepeatUntilSuccess repeatUntilSuccessAnnotation) {
        if (repeatUntilSuccessAnnotation == null) {
            return null;
        }
        return repeatUntilSuccessAnnotation.sleep();
    }
}

