/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.testing.junitrunner;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.testing.junitrunner.BeforeAfterClassMethodsProvider;
import org.spincast.testing.junitrunner.CanBeDisabled;
import org.spincast.testing.junitrunner.ExpectingBeforeClassException;
import org.spincast.testing.junitrunner.NoTestsFrameworkMethod;
import org.spincast.testing.junitrunner.Repeat;
import org.spincast.testing.junitrunner.RepeatedClassAfterMethodProvider;
import org.spincast.testing.junitrunner.TestFailureListener;

public class SpincastJUnitRunner
extends BlockJUnit4ClassRunner {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastJUnitRunner.class);
    public static final String SPINCAST_TEST_NAME_BEFORE_CLASS_ANNOTATIONS_VALIDATION = "[Spincast] @BeforeClass annotations validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_ANNOTATIONS_VALIDATION = "[Spincast] @AfterClass annotations validation";
    public static final String SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION = "[Spincast] beforeClass method validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_METHOD_VALIDATION = "[Spincast] afterClass method validation";
    public static final String SPINCAST_TEST_NAME_NO_TESTS_AND_NO_EXPECTION_EXCEPTION_ANNOTATION = "[Spincast] No tests and no @" + ExpectingBeforeClassException.class.getSimpleName() + " validation";
    public static final String SPINCAST_TEST_NAME_AFTER_CLASS_LOOPS_EXCEPTION = "[Spincast] afterClassLoops method validation";
    private Object testClassInstance = null;
    private boolean exceptionInBeforeClass = false;
    private Boolean isExpectingBeforeClassException = null;
    private boolean atLeastOneTestFailed = false;
    private RunNotifier runNotifier = null;
    private int currentClassLoopPosition = 1;
    private boolean ignoreRemainingTests = false;

    public SpincastJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected RunNotifier getRunNotifier() {
        return this.runNotifier;
    }

    protected void setIgnoreRemainingTests() {
        this.ignoreRemainingTests = true;
    }

    protected boolean isIgnoreRemainingTests() {
        return this.ignoreRemainingTests;
    }

    protected void setExceptionInBeforeClass() {
        this.exceptionInBeforeClass = true;
    }

    protected boolean isExceptionInBeforeClass() {
        return this.exceptionInBeforeClass;
    }

    protected int getCurrentClassLoopPosition() {
        return this.currentClassLoopPosition;
    }

    protected void setCurrentClassLoopPosition(int currentClassLoopPosition) {
        this.currentClassLoopPosition = currentClassLoopPosition;
    }

    public Object createTest() throws Exception {
        if (this.testClassInstance == null) {
            this.testClassInstance = this.getTestClass().getOnlyConstructor().newInstance(new Object[0]);
        }
        return this.testClassInstance;
    }

    protected Object getTestClassInstance() {
        try {
            return this.createTest();
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
    }

    protected String getName() {
        String name = super.getName();
        int loopsNbr = this.getTestClassLoopsNbr();
        if (loopsNbr > 1) {
            name = name + " [" + loopsNbr + " loops]";
        }
        return name;
    }

    protected final List<FrameworkMethod> computeTestMethods() {
        ArrayList<NoTestsFrameworkMethod> tests = super.computeTestMethods();
        if (tests == null || tests.size() == 0) {
            tests = new ArrayList<NoTestsFrameworkMethod>(tests);
            tests.add(new NoTestsFrameworkMethod());
        }
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        this.runNotifier = notifier;
        if (this.getTestClassInstance() instanceof CanBeDisabled && ((CanBeDisabled)this.getTestClassInstance()).isTestsFileDisabled()) {
            logger.info("tests file disabled! Skipping...");
            return;
        }
        this.addTestFailureListener(notifier);
        this.runPreClassLoopsSpincastTests();
        try {
            int loopsNbr = this.getTestClassLoopsNbr();
            int sleep = this.getTestClassLoopsSleep();
            try {
                for (int i = 0; i < loopsNbr; ++i) {
                    String msg;
                    this.setCurrentClassLoopPosition(i + 1);
                    if (loopsNbr > 1) {
                        logger.info("Running loop " + this.getCurrentClassLoopPosition() + "/" + loopsNbr + " of test class " + this.getTestClass().getJavaClass().getName());
                    }
                    this.testClassInstance = null;
                    if (this.getTestClassInstance() instanceof BeforeAfterClassMethodsProvider) {
                        try {
                            ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).beforeClass();
                            if (this.isExpectingBeforeClassException()) {
                                msg = "An exception was expected in the 'beforeClass()' method since the @" + ExpectingBeforeClassException.class.getSimpleName() + " is used on the class, but none occured.";
                                this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, msg);
                            }
                        }
                        catch (Throwable ex) {
                            this.setExceptionInBeforeClass();
                            this.setIgnoreRemainingTests();
                            if (!this.isExpectingBeforeClassException()) {
                                this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, ex);
                            }
                            try {
                                ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).beforeClassException(ex);
                            }
                            catch (Exception ex2) {
                                logger.error("Error managing the 'beforeClass' exception : ", (Throwable)ex2);
                            }
                        }
                    } else if (this.isExpectingBeforeClassException()) {
                        msg = "The @" + ExpectingBeforeClassException.class.getSimpleName() + " annotation can only be used on a class implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
                        this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_METHOD_VALIDATION, msg);
                    }
                    super.run(notifier);
                    if (!this.isIgnoreRemainingTests() && this.getTestClassInstance() instanceof BeforeAfterClassMethodsProvider) {
                        try {
                            ((BeforeAfterClassMethodsProvider)this.getTestClassInstance()).afterClass();
                        }
                        catch (Throwable ex) {
                            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_METHOD_VALIDATION, ex);
                            break;
                        }
                    }
                    if (this.atLeastOneTestFailed) break;
                    if (i >= loopsNbr - 1) {
                        break;
                    }
                    if (sleep <= 0) continue;
                    try {
                        Thread.sleep(sleep);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                if (this.getTestClassInstance() instanceof RepeatedClassAfterMethodProvider) {
                    if (!this.isExceptionInBeforeClass()) {
                        try {
                            ((RepeatedClassAfterMethodProvider)this.getTestClassInstance()).afterClassLoops();
                        }
                        catch (Throwable ex) {
                            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_LOOPS_EXCEPTION, ex);
                        }
                    } else {
                        logger.info("An exception occured in the 'beforeClass()' method, so the 'afterClassLoops()' method won't be called.");
                    }
                }
            }
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
        }
        finally {
            int classLoopsNbr = this.getTestClassLoopsNbr();
            if (this.atLeastOneTestFailed && classLoopsNbr > 1) {
                logger.error("The test failure occured during the class loop #" + this.getCurrentClassLoopPosition());
            }
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (NoTestsFrameworkMethod.class.getName().equals(method.getDeclaringClass().getName())) {
            Description description = this.describeChild(method);
            notifier.fireTestStarted(description);
            notifier.fireTestFinished(description);
            return;
        }
        if (this.isIgnoreRemainingTests()) {
            Description description = this.describeChild(method);
            notifier.fireTestIgnored(description);
            return;
        }
        int sleep = this.getMethodLoopsSleep(method.getMethod());
        int loopsNbr = this.getMethodLoopsNbr(method.getMethod());
        for (int i = 0; i < loopsNbr; ++i) {
            if (loopsNbr > 1) {
                logger.info("Execution " + (i + 1) + "/" + loopsNbr + " of test " + method.getMethod().getName() + " from test class " + this.getTestClass().getJavaClass().getName());
            }
            super.runChild(method, notifier);
            if (loopsNbr > 1 && this.atLeastOneTestFailed) {
                logger.error("The test \"" + method.getMethod().getName() + "\" failed during the loop #" + (i + 1));
                break;
            }
            if (i >= loopsNbr - 1) break;
            if (sleep <= 0) continue;
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void addTestFailureListener(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testFailure(Failure failure) throws Exception {
                SpincastJUnitRunner.this.atLeastOneTestFailed = true;
                SpincastJUnitRunner.this.logTestFailure(failure);
                if (SpincastJUnitRunner.this.testClassInstance instanceof TestFailureListener) {
                    ((TestFailureListener)SpincastJUnitRunner.this.testClassInstance).testFailure(failure);
                }
            }
        });
    }

    protected void logTestFailure(Failure failure) {
        System.err.println(this.getStackTrace(failure.getException()));
    }

    protected void runPreClassLoopsSpincastTests() {
        this.validateNoBeforeClassAnnotations();
        this.validateNoAfterClassAnnotations();
        this.validateNoTestsAndNoExpectingBeforeClassExceptionAnnotation();
    }

    protected void validateNoBeforeClassAnnotations() {
        List befores = this.getTestClass().getAnnotatedMethods(BeforeClass.class);
        if (befores != null && befores.size() > 0) {
            String msg = "The @BeforeClass JUnit annotation can't be used with the " + SpincastJUnitRunner.class.getSimpleName() + " custom runner. Use the beforeClass() method instead by implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
            this.spincastTestError(SPINCAST_TEST_NAME_BEFORE_CLASS_ANNOTATIONS_VALIDATION, msg);
        }
    }

    protected void validateNoAfterClassAnnotations() {
        List afters = this.getTestClass().getAnnotatedMethods(AfterClass.class);
        if (afters != null && afters.size() > 0) {
            String msg = "The @AfterClass JUnit annotation can't be used with the " + SpincastJUnitRunner.class.getSimpleName() + " custom runner. Use the afterClass() method instead by implementing the " + BeforeAfterClassMethodsProvider.class.getSimpleName() + " interface.";
            this.spincastTestError(SPINCAST_TEST_NAME_AFTER_CLASS_ANNOTATIONS_VALIDATION, msg);
        }
    }

    protected void validateNoTestsAndNoExpectingBeforeClassExceptionAnnotation() {
        List regularTests = SpincastJUnitRunner.super.computeTestMethods();
        if (!(regularTests != null && regularTests.size() != 0 || this.isExpectingBeforeClassException())) {
            String msg = "There must be at least one @Test or the @" + ExpectingBeforeClassException.class.getSimpleName() + " must be present.";
            this.spincastTestError(SPINCAST_TEST_NAME_NO_TESTS_AND_NO_EXPECTION_EXCEPTION_ANNOTATION, msg);
        }
    }

    protected void spincastTestError(String testName, String errorMessage) {
        this.spincastTestError(testName, new RuntimeException(errorMessage));
    }

    protected void spincastTestError(String testName, Throwable exception) {
        logger.error("Test error", exception);
        Description description = Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)testName);
        this.setIgnoreRemainingTests();
        this.getRunNotifier().fireTestStarted(description);
        this.getRunNotifier().fireTestFailure(new Failure(description, exception));
        this.getRunNotifier().fireTestFinished(description);
    }

    protected String getStackTrace(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public boolean isExpectingBeforeClassException() {
        if (this.isExpectingBeforeClassException == null) {
            this.isExpectingBeforeClassException = this.getTestClass().getAnnotation(ExpectingBeforeClassException.class) != null;
        }
        return this.isExpectingBeforeClassException;
    }

    protected int getTestClassLoopsNbr() {
        return this.getLoopsNbr((Repeat)this.getTestClass().getAnnotation(Repeat.class));
    }

    protected int getMethodLoopsNbr(Method method) {
        return this.getLoopsNbr(method.getAnnotation(Repeat.class));
    }

    protected int getLoopsNbr(Repeat repeatAnnotation) {
        int loopsNbr = 1;
        if (repeatAnnotation != null && (loopsNbr = repeatAnnotation.value()) < 1) {
            loopsNbr = 1;
        }
        return loopsNbr;
    }

    protected int getMethodLoopsSleep(Method method) {
        return this.getLoopsSleep(method.getAnnotation(Repeat.class));
    }

    protected int getTestClassLoopsSleep() {
        return this.getLoopsSleep((Repeat)this.getTestClass().getAnnotation(Repeat.class));
    }

    protected int getLoopsSleep(Repeat repeatAnnotation) {
        int sleep = 0;
        if (repeatAnnotation != null) {
            sleep = repeatAnnotation.sleep();
        }
        return sleep;
    }
}

