/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.response;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.exchange.IResponseRequestContextAddon;
import org.spincast.core.json.IJsonManager;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.ContentTypeDefaults;
import org.spincast.core.utils.GzipOption;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.xml.IXmlManager;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastResponseRequestContextAddon<R extends IRequestContext<?>>
implements IResponseRequestContextAddon<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastResponseRequestContextAddon.class);
    protected static final boolean IS_RESPONSE_CHARACTERS_BASED_BY_DEFAULT = false;
    private final R requestContext;
    private final IServer server;
    private final IJsonManager jsonManager;
    private final IXmlManager xmlManager;
    private final ISpincastConfig spincastConfig;
    private final ISpincastUtils spincastUtils;
    private String responseContentType = null;
    private int responseStatusCode = 200;
    private final ByteArrayOutputStream byteArrayOutputStreamIn = new ByteArrayOutputStream(256);
    private final ByteArrayOutputStream byteArrayOutputStreamOut = new ByteArrayOutputStream(256);
    private GZIPOutputStream gzipOutputStream = null;
    private Boolean isShouldGzip = null;
    private String charactersCharsetName = "UTF-8";
    private boolean isResponseCharactersBased = false;
    private boolean requestSizeValidated = false;
    private Map<String, List<String>> headers;
    private GzipOption gzipOption = GzipOption.DEFAULT;

    @Inject
    public SpincastResponseRequestContextAddon(R requestContext, IServer server, IJsonManager jsonManager, IXmlManager xmlManager, ISpincastConfig spincastConfig, ISpincastUtils spincastUtils) {
        this.requestContext = requestContext;
        this.server = server;
        this.jsonManager = jsonManager;
        this.xmlManager = xmlManager;
        this.spincastConfig = spincastConfig;
        this.spincastUtils = spincastUtils;
    }

    protected R getRequestContext() {
        return this.requestContext;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected Object getExchange() {
        return this.getRequestContext().exchange();
    }

    protected IJsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected IXmlManager getXmlManager() {
        return this.xmlManager;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected ByteArrayOutputStream getBuffer() {
        return this.byteArrayOutputStreamIn;
    }

    protected ByteArrayOutputStream getOut() {
        return this.byteArrayOutputStreamOut;
    }

    public GZIPOutputStream getGzipBuffer() {
        try {
            if (this.gzipOutputStream == null) {
                this.gzipOutputStream = new GZIPOutputStream((OutputStream)this.getOut(), true);
            }
            return this.gzipOutputStream;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected boolean isRequestSizeValidated() {
        return this.requestSizeValidated;
    }

    protected void setRequestSizeValidated(boolean requestSizeValidated) {
        this.requestSizeValidated = requestSizeValidated;
    }

    @Override
    public void setGzipOption(GzipOption gzipOption) {
        if (gzipOption == null) {
            gzipOption = GzipOption.DEFAULT;
        }
        if (this.isHeadersSent() && gzipOption != this.getGzipOption()) {
            this.logger.warn("The headers are sent, you can't change the gzip options.");
            return;
        }
        this.gzipOption = gzipOption;
    }

    @Override
    public GzipOption getGzipOption() {
        return this.gzipOption;
    }

    @Override
    public int getStatusCode() {
        return this.responseStatusCode;
    }

    @Override
    public void setStatusCode(int responseStatusCode) {
        if (this.isHeadersSent()) {
            if (responseStatusCode != this.getStatusCode()) {
                this.logger.warn("Response headers already sent, the http status code can't be changed...");
            }
        } else {
            this.responseStatusCode = responseStatusCode;
        }
    }

    @Override
    public String getContentType() {
        return this.responseContentType;
    }

    @Override
    public void setContentType(String responseContentType) {
        if (this.isHeadersSent()) {
            if (responseContentType != null && !responseContentType.equals(this.getContentType())) {
                this.logger.warn("Response headers already sent, the content-type can't be changed...");
            }
        } else {
            GzipOption gzipOption;
            if ((responseContentType != null && !responseContentType.equals(this.getContentType()) || responseContentType == null && this.getContentType() != null) && (gzipOption = this.getGzipOption()) == GzipOption.DEFAULT) {
                this.setIsShouldGzip(null);
            }
            this.responseContentType = responseContentType;
        }
    }

    protected boolean isResponseCharactersBased() {
        return this.isResponseCharactersBased;
    }

    @Override
    public boolean isClosed() {
        return this.getServer().isResponseClosed(this.getExchange());
    }

    @Override
    public void redirect(String newUrl, boolean permanently) {
        if (permanently) {
            this.redirect(newUrl, 301);
        } else {
            this.redirect(newUrl, 302);
        }
    }

    @Override
    public void redirect(String newUrl, int specific3xxCode) {
        try {
            if (this.isHeadersSent()) {
                throw new RuntimeException("Can't set redirect, the headers are already sent.");
            }
            this.setStatusCode(specific3xxCode);
            if (StringUtils.isBlank(newUrl)) {
                newUrl = "/";
            } else if ((newUrl = newUrl.trim()).startsWith("//")) {
                newUrl = this.getServer().getRequestScheme(this.getExchange()) + ":" + newUrl;
            }
            URI uri = new URI(newUrl);
            if (!uri.isAbsolute()) {
                URI currentUri = new URI(this.getRequestContext().request().getFullUrl());
                String path = newUrl;
                if (!path.startsWith("/")) {
                    String currentPath = currentUri.getPath();
                    int lastSlashPos = (currentPath = StringUtils.strip(currentPath, "/")).lastIndexOf("/");
                    path = lastSlashPos < 0 ? "/" + path : "/" + currentPath.substring(0, lastSlashPos) + "/" + path;
                }
                uri = new URI(currentUri.getScheme(), currentUri.getUserInfo(), currentUri.getHost(), currentUri.getPort(), path, null, null);
                newUrl = uri.toString();
            }
            this.setHeader("Location", newUrl);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void sendBytes(byte[] bytes) {
        this.sendBytes(bytes, null, false);
    }

    @Override
    public void sendBytes(byte[] bytes, String contentType) {
        this.sendBytes(bytes, contentType, false);
    }

    @Override
    public void sendBytes(byte[] bytes, String contentType, boolean flush) {
        this.send(bytes, contentType, flush);
    }

    protected void send(byte[] bytes, String contentType, boolean flush) {
        if (this.isClosed()) {
            this.logger.debug("The response is closed, nothing more can be sent!");
            return;
        }
        if (this.isHeadersSent()) {
            if (contentType != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("Response headers are already sent, the content-type won't be changed...");
            }
        } else if (contentType != null) {
            if (this.getContentType() != null && !contentType.equals(this.getContentType())) {
                this.logger.warn("The content-type is changed from " + this.getContentType() + " to " + contentType);
            }
            this.setContentType(contentType);
        }
        if (bytes != null) {
            try {
                this.getBuffer().write(bytes);
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
        }
        if (flush) {
            this.flush();
        }
    }

    @Override
    public void sendCharacters(String content) {
        this.sendCharacters(content, null, false);
    }

    @Override
    public void sendCharacters(String content, String contentType) {
        this.sendCharacters(content, contentType, false);
    }

    @Override
    public void sendCharacters(String content, String contentType, boolean flush) {
        try {
            this.isResponseCharactersBased = true;
            byte[] bytes = null;
            if (content != null) {
                bytes = content.getBytes(this.getCharactersCharsetName());
            }
            this.send(bytes, contentType, flush);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String getCharactersCharsetName() {
        return this.charactersCharsetName;
    }

    @Override
    public void setCharactersCharsetName(String charactersCharsetName) {
        Objects.requireNonNull(charactersCharsetName, "charactersCharsetName can't be NULL");
        if (this.isHeadersSent() && !charactersCharsetName.equalsIgnoreCase(this.getCharactersCharsetName())) {
            this.logger.warn("Some data have already been send, it may not be a good idea to change the Charset now.");
        }
        this.charactersCharsetName = charactersCharsetName;
    }

    @Override
    public void sendPlainText(String string) {
        this.sendPlainText(string, false);
    }

    @Override
    public void sendPlainText(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendHtml(String html) {
        this.sendHtml(html, false);
    }

    @Override
    public void sendHtml(String string, boolean flush) {
        this.sendCharacters(string, ContentTypeDefaults.HTML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendHtmlParse(String html, Map<String, Object> params) {
        this.sendHtmlParse(html, params, false);
    }

    @Override
    public void sendHtmlParse(String html, Map<String, Object> params, boolean flush) {
        String evaluated = this.getRequestContext().templating().evaluate(html, params);
        this.sendHtml(evaluated, flush);
    }

    @Override
    public void sendParse(String content, String contentType, Map<String, Object> params) {
        this.sendParse(content, contentType, params, false);
    }

    @Override
    public void sendParse(String content, String contentType, Map<String, Object> params, boolean flush) {
        if (StringUtils.isBlank(contentType)) {
            this.sendHtmlParse(content, params, flush);
            return;
        }
        String evaluated = this.getRequestContext().templating().evaluate(content, params);
        this.sendCharacters(evaluated, contentType, flush);
    }

    @Override
    public void sendHtmlTemplate(String templatePath, Map<String, Object> params) {
        this.sendHtmlTemplate(templatePath, true, params, false);
    }

    @Override
    public void sendHtmlTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params) {
        this.sendHtmlTemplate(templatePath, isClasspathPath, params, false);
    }

    @Override
    public void sendHtmlTemplate(String templatePath, Map<String, Object> params, boolean flush) {
        this.sendHtmlTemplate(templatePath, true, params, flush);
    }

    @Override
    public void sendHtmlTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params, boolean flush) {
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, params);
        this.sendHtml(evaluated, flush);
    }

    @Override
    public void sendTemplate(String templatePath, String contentType, Map<String, Object> params) {
        this.sendTemplate(templatePath, true, contentType, params, false);
    }

    @Override
    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, Map<String, Object> params) {
        this.sendTemplate(templatePath, isClasspathPath, contentType, params, false);
    }

    @Override
    public void sendTemplate(String templatePath, String contentType, Map<String, Object> params, boolean flush) {
        this.sendTemplate(templatePath, true, contentType, params, flush);
    }

    @Override
    public void sendTemplate(String templatePath, boolean isClasspathPath, String contentType, Map<String, Object> params, boolean flush) {
        if (StringUtils.isBlank(contentType)) {
            this.sendHtmlTemplate(templatePath, isClasspathPath, params, flush);
            return;
        }
        String evaluated = this.getRequestContext().templating().fromTemplate(templatePath, isClasspathPath, params);
        this.sendCharacters(evaluated, contentType, flush);
    }

    @Override
    public void sendJson(Object obj) {
        this.sendJson(obj, false);
    }

    @Override
    public void sendJson(Object obj, boolean flush) {
        String json = this.getJsonManager().toJsonString(obj);
        this.sendCharacters(json, ContentTypeDefaults.JSON.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void sendXml(Object obj) {
        this.sendXml(obj, false);
    }

    @Override
    public void sendXml(Object obj, boolean flush) {
        String xml = this.getXmlManager().toXml(obj);
        this.sendCharacters(xml, ContentTypeDefaults.XML.getMainVariationWithUtf8Charset(), flush);
    }

    @Override
    public void resetBuffer() {
        try {
            this.getBuffer().reset();
            if (!this.isHeadersSent()) {
                this.isResponseCharactersBased = false;
            }
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void resetEverything() {
        this.resetBuffer();
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, the cookies, headers and status code won't be reset...");
        } else {
            this.getRequestContext().cookies().resetCookies();
            this.getHeaders().clear();
            this.setContentType(null);
            this.setStatusCode(200);
        }
    }

    @Override
    public byte[] getUnsentBytes() {
        return this.getBuffer().toByteArray();
    }

    @Override
    public String getUnsentCharacters() {
        return this.getUnsentCharacters("UTF-8");
    }

    @Override
    public String getUnsentCharacters(String encoding) {
        try {
            byte[] unsentBytes = this.getUnsentBytes();
            return new String(unsentBytes, encoding);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public void removeHeader(String name) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return;
        }
        this.getHeaders().remove(name);
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return;
        }
        if (value == null) {
            this.removeHeader(name);
            return;
        }
        this.setHeader(name, Arrays.asList(value));
    }

    @Override
    public void setHeader(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return;
        }
        if (values == null) {
            this.removeHeader(name);
            return;
        }
        this.getHeaders().put(name, values);
    }

    @Override
    public void addHeaderValue(String name, String value) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return;
        }
        if (value == null) {
            return;
        }
        this.addHeaderValues(name, Arrays.asList(value));
    }

    @Override
    public void addHeaderValues(String name, List<String> values) {
        if (this.isHeadersSent()) {
            this.logger.warn("Response headers are already sent, can't change them...");
            return;
        }
        if (values == null) {
            return;
        }
        List<String> currentValues = this.getHeaders().get(name);
        if (currentValues == null) {
            currentValues = new ArrayList<String>();
            this.getHeaders().put(name, currentValues);
        }
        currentValues.addAll(values);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            Map<String, List<String>> headersFromServer = this.getServer().getResponseHeaders(this.getExchange());
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (headersFromServer == null) {
                treeMap.putAll(headersFromServer);
            }
            this.headers = treeMap;
        }
        return this.headers;
    }

    @Override
    public List<String> getHeader(String name) {
        if (StringUtils.isBlank(name)) {
            return new LinkedList<String>();
        }
        List<String> values = this.getHeaders().get(name);
        if (values == null) {
            values = new LinkedList<String>();
        }
        return values;
    }

    @Override
    public String getHeaderFirst(String name) {
        List<String> values = this.getHeader(name);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public boolean isHeadersSent() {
        return this.getServer().isResponseHeadersSent(this.getExchange());
    }

    protected void setIsShouldGzip(Boolean isShouldGzip) {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption != GzipOption.DEFAULT) {
            this.logger.warn("Can't turn on/off the gzip feature since the GzipOption is " + (Object)((Object)gzipOption));
            return;
        }
        try {
            if (this.isHeadersSent()) {
                if (this.isShouldGzip != isShouldGzip) {
                    this.logger.warn("Can't turn on/off the gzip feature since headers are already sent.");
                }
                return;
            }
            if (this.isShouldGzip != null && this.isShouldGzip.booleanValue() && (isShouldGzip == null || !isShouldGzip.booleanValue())) {
                this.byteArrayOutputStreamIn.reset();
                this.getGzipBuffer().close();
                ByteArrayOutputStream buffer = this.getBuffer();
                if (buffer.size() > 0) {
                    GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(buffer.toByteArray()));
                    byte[] ungzipedBytes = IOUtils.toByteArray(gzipInputStream);
                    this.byteArrayOutputStreamIn.write(ungzipedBytes);
                }
                this.gzipOutputStream = null;
            }
            this.isShouldGzip = isShouldGzip;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected boolean isShouldGzip() {
        GzipOption gzipOption = this.getGzipOption();
        if (gzipOption == GzipOption.FORCE) {
            return true;
        }
        if (gzipOption == GzipOption.DISABLE) {
            return false;
        }
        if (gzipOption != GzipOption.DEFAULT) {
            throw new RuntimeException("Unimplemented : " + (Object)((Object)gzipOption));
        }
        if (this.isShouldGzip == null) {
            String responseContentType;
            boolean hasGzipAcceptHeader = false;
            List<String> acceptEncodings = this.getRequestContext().request().getHeader("Accept-Encoding");
            if (acceptEncodings != null) {
                for (String acceptEncoding : acceptEncodings) {
                    if (acceptEncoding == null || !acceptEncoding.contains("gzip")) continue;
                    hasGzipAcceptHeader = true;
                    break;
                }
            }
            if ((responseContentType = this.getContentType()) == null) {
                String path = this.getRequestContext().request().getRequestPath();
                responseContentType = this.getSpincastUtils().getMimeTypeFromPath(path);
            }
            if (responseContentType != null) {
                this.setIsShouldGzip(!this.getSpincastUtils().isContentTypeToSkipGziping(responseContentType));
            } else {
                this.setIsShouldGzip(false);
            }
            if (this.isShouldGzip.booleanValue() && !hasGzipAcceptHeader) {
                this.logger.debug("No gzip 'Accept-Encoding' header, we won't gzip the response.");
                this.setIsShouldGzip(false);
            }
        }
        return this.isShouldGzip;
    }

    @Override
    public void end() {
        this.flush(true);
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    @Override
    public void flush(boolean end) {
        try {
            byte[] bytesToFlush;
            if (this.isClosed()) {
                return;
            }
            if (!this.isRequestSizeValidated() && !this.isHeadersSent()) {
                this.setRequestSizeValidated(true);
                boolean requestSizeOk = this.getServer().forceRequestSizeValidation(this.getExchange());
                if (!requestSizeOk) {
                    this.resetEverything();
                    this.setStatusCode(413);
                }
            }
            ByteArrayOutputStream buffer = this.getBuffer();
            if (!this.isHeadersSent()) {
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                String responseContentType = this.getContentType();
                if (responseContentType == null) {
                    String mimeType = this.getSpincastUtils().getMimeTypeFromPath(this.getRequestContext().request().getRequestPath());
                    responseContentType = mimeType != null ? mimeType : (this.isResponseCharactersBased() || buffer.size() == 0 ? ContentTypeDefaults.TEXT.getMainVariationWithUtf8Charset() : ContentTypeDefaults.BINARY.getMainVariation());
                    this.setContentType(responseContentType);
                }
                this.setHeader("Content-Type", responseContentType);
                this.getServer().setResponseStatusCode(this.getExchange(), this.getStatusCode());
                if (end && !this.isShouldGzip()) {
                    this.setHeader("Content-Length", "" + buffer.size());
                }
                this.getServer().addCookies(this.getExchange(), this.getRequestContext().cookies().getCookies());
                if (this.isShouldGzip()) {
                    this.setHeader("Content-Encoding", "gzip");
                    this.setHeader("Transfer-Encoding", "chunked");
                }
                this.getServer().setResponseHeaders(this.getExchange(), this.getHeaders());
            }
            if (this.isShouldGzip()) {
                this.getGzipBuffer().write(buffer.toByteArray());
                this.getGzipBuffer().flush();
                if (end) {
                    this.getGzipBuffer().close();
                }
                bytesToFlush = this.getOut().toByteArray();
                this.getOut().reset();
            } else {
                bytesToFlush = buffer.toByteArray();
            }
            buffer.reset();
            this.getServer().flushBytes(this.getExchange(), bytesToFlush, end);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }
}

