/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.multibindings;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.MapKey;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoMap;
import com.google.inject.multibindings.ProvidesIntoOptional;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ModuleAnnotatedMethodScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class MultibindingsScanner {
    private MultibindingsScanner() {
    }

    public static Module asModule() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.binder().scanModulesForAnnotatedMethods(Scanner.INSTANCE);
            }
        };
    }

    public static ModuleAnnotatedMethodScanner scanner() {
        return Scanner.INSTANCE;
    }

    private static AnnotationOrError findMapKeyAnnotation(Binder binder, Method method) {
        Annotation foundAnnotation = null;
        for (Annotation annotation : method.getAnnotations()) {
            MapKey mapKey = annotation.annotationType().getAnnotation(MapKey.class);
            if (mapKey == null) continue;
            if (foundAnnotation != null) {
                binder.addError("Found more than one MapKey annotations on %s.", method);
                return AnnotationOrError.forError();
            }
            if (mapKey.unwrapValue()) {
                try {
                    Method valueMethod = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
                    if (valueMethod.getReturnType().isArray()) {
                        binder.addError("Array types are not allowed in a MapKey with unwrapValue=true: %s", annotation.annotationType());
                        return AnnotationOrError.forError();
                    }
                }
                catch (NoSuchMethodException invalid) {
                    binder.addError("No 'value' method in MapKey with unwrapValue=true: %s", annotation.annotationType());
                    return AnnotationOrError.forError();
                }
            }
            foundAnnotation = annotation;
        }
        return AnnotationOrError.forPossiblyNullAnnotation(foundAnnotation);
    }

    static TypeAndValue<?> typeAndValueOfMapKey(Annotation mapKeyAnnotation) {
        if (!mapKeyAnnotation.annotationType().getAnnotation(MapKey.class).unwrapValue()) {
            return new TypeAndValue<Annotation>(TypeLiteral.get(mapKeyAnnotation.annotationType()), mapKeyAnnotation);
        }
        try {
            Method valueMethod = mapKeyAnnotation.annotationType().getDeclaredMethod("value", new Class[0]);
            valueMethod.setAccessible(true);
            TypeLiteral<?> returnType = TypeLiteral.get(mapKeyAnnotation.annotationType()).getReturnType(valueMethod);
            return new TypeAndValue<Object>(returnType, valueMethod.invoke((Object)mapKeyAnnotation, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TypeAndValue<T> {
        final TypeLiteral<T> type;
        final T value;

        TypeAndValue(TypeLiteral<T> type, T value) {
            this.type = type;
            this.value = value;
        }
    }

    private static class AnnotationOrError {
        final Annotation annotation;
        final boolean error;

        AnnotationOrError(Annotation annotation, boolean error) {
            this.annotation = annotation;
            this.error = error;
        }

        static AnnotationOrError forPossiblyNullAnnotation(Annotation annotation) {
            return new AnnotationOrError(annotation, false);
        }

        static AnnotationOrError forError() {
            return new AnnotationOrError(null, true);
        }
    }

    private static class Scanner
    extends ModuleAnnotatedMethodScanner {
        private static final Scanner INSTANCE = new Scanner();

        private Scanner() {
        }

        @Override
        public Set<? extends Class<? extends Annotation>> annotationClasses() {
            return ImmutableSet.of(ProvidesIntoSet.class, ProvidesIntoMap.class, ProvidesIntoOptional.class);
        }

        @Override
        public <T> Key<T> prepareMethod(Binder binder, Annotation annotation, Key<T> key, InjectionPoint injectionPoint) {
            Method method = (Method)injectionPoint.getMember();
            AnnotationOrError mapKey = MultibindingsScanner.findMapKeyAnnotation(binder, method);
            if (annotation instanceof ProvidesIntoSet) {
                if (mapKey.annotation != null) {
                    binder.addError("Found a MapKey annotation on non map binding at %s.", method);
                }
                return Multibinder.newRealSetBinder(binder, key).getKeyForNewItem();
            }
            if (annotation instanceof ProvidesIntoMap) {
                if (mapKey.error) {
                    return key;
                }
                if (mapKey.annotation == null) {
                    binder.addError("No MapKey found for map binding at %s.", method);
                    return key;
                }
                TypeAndValue<?> typeAndValue = MultibindingsScanner.typeAndValueOfMapKey(mapKey.annotation);
                return MapBinder.newRealMapBinder(binder, typeAndValue.type, key).getKeyForNewValue(typeAndValue.value);
            }
            if (annotation instanceof ProvidesIntoOptional) {
                if (mapKey.annotation != null) {
                    binder.addError("Found a MapKey annotation on non map binding at %s.", method);
                }
                switch (((ProvidesIntoOptional)annotation).value()) {
                    case DEFAULT: {
                        return OptionalBinder.newRealOptionalBinder(binder, key).getKeyForDefaultBinding();
                    }
                    case ACTUAL: {
                        return OptionalBinder.newRealOptionalBinder(binder, key).getKeyForActualBinding();
                    }
                }
            }
            String string = String.valueOf(String.valueOf(annotation));
            throw new IllegalStateException(new StringBuilder(20 + string.length()).append("Invalid annotation: ").append(string).toString());
        }
    }
}

