/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.maven;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.OS;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.defaults.guice.SpincastDefaultGuiceModule;
import org.spincast.shaded.org.apache.commons.io.FileUtils;

public class GenerateAggregatedJavadoc {
    private final String[] mainArgs;
    private File projectBaseDir;
    private File projectBuildOutputDir;
    private File mavenInstallatinRoot;
    private File javadocSourceGenerationDir;

    public static void main(String[] args) {
        Injector guice = Guice.createInjector(new SpincastDefaultGuiceModule(args), new SpincastMavenPluginPackageModule());
        GenerateAggregatedJavadoc spincastMavenPluginPackage = guice.getInstance(GenerateAggregatedJavadoc.class);
        spincastMavenPluginPackage.start();
    }

    @Inject
    public GenerateAggregatedJavadoc(@MainArgs String[] mainArgs) {
        this.mainArgs = mainArgs;
    }

    protected String[] getMainArgs() {
        return this.mainArgs;
    }

    protected File getProjectBaseDir() {
        if (this.projectBaseDir == null) {
            if (this.getMainArgs().length == 0) {
                this.sendException("The " + GenerateAggregatedJavadoc.class.getName() + " class expect the base directory of the project " + "to be passed as the first parameter:  <arguments><argument>${project.basedir}</argument></arguments>");
            }
            String baseDirPath = this.getMainArgs()[0];
            this.projectBaseDir = new File(baseDirPath);
            if (!this.projectBaseDir.isDirectory()) {
                this.sendException("The first parameter must be the base directory of the project. The specified directory doesn't exist: " + baseDirPath);
            }
        }
        return this.projectBaseDir;
    }

    protected File getProjectBuildOutputDir() {
        if (this.projectBuildOutputDir == null) {
            if (this.getMainArgs().length < 2) {
                this.sendException("The " + GenerateAggregatedJavadoc.class.getName() + " class expect the build output directory of the project " + "to be passed as the second parameter:  <arguments><argument>${project.build.outputDirectory}</argument></arguments>");
            }
            String buildDirPath = this.getMainArgs()[1];
            this.projectBuildOutputDir = new File(buildDirPath);
            if (!this.projectBuildOutputDir.isDirectory()) {
                this.sendException("The second parameter must be the build output directory of the project. The specified directory doesn't exist: " + buildDirPath);
            }
        }
        return this.projectBuildOutputDir;
    }

    protected File getMavenInstallatinRoot() {
        if (this.mavenInstallatinRoot == null) {
            if (this.getMainArgs().length < 3) {
                this.sendException("The " + GenerateAggregatedJavadoc.class.getName() + " class expect the Maven installation directory (M2_HOME) " + "to be passed as the third parameter:  <arguments><argument>${env.M2_HOME}</argument></arguments>");
            }
            String mavenHome = this.getMainArgs()[2];
            this.mavenInstallatinRoot = new File(mavenHome);
            if (!this.mavenInstallatinRoot.isDirectory()) {
                this.sendException("The third parameter must be the Maven installation directory. The specified directory doesn't exist: " + mavenHome);
            }
            if (!new File(mavenHome + "/bin/").isDirectory()) {
                this.sendException("The specified Maven home doesn't seem to be valid: " + mavenHome);
            }
        }
        return this.mavenInstallatinRoot;
    }

    protected File getJavadocSourceGenerationDir() {
        if (this.javadocSourceGenerationDir == null) {
            this.javadocSourceGenerationDir = new File(this.getProjectBaseDir().getAbsolutePath() + "/../target/site/apidocs");
        }
        return this.javadocSourceGenerationDir;
    }

    protected void sendException(String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n!\n!\n! ==========================================\n");
        builder.append("! SPINCAST MAVEN BUILD ERROR:\n!\n");
        builder.append("! ").append(message);
        builder.append("\n! ==========================================\n!\n!\n");
        throw new RuntimeException(builder.toString());
    }

    protected void log(String message) {
        System.out.println("[INFO-SPINCAST] " + message);
    }

    protected void start() {
        this.log("Starting the aggregated Javadoc generation using a custom Spincast script...");
        this.generateAggregatedJavadoc();
        this.copyJavadocsToWebsite();
    }

    protected void generateAggregatedJavadoc() {
        try {
            File mvnBin;
            this.log("Generating Aggregated Javadoc...");
            FileUtils.deleteDirectory(this.getJavadocSourceGenerationDir());
            String mavenHome = this.getMavenInstallatinRoot().getCanonicalPath();
            String executable = "mvn";
            if (OS.isFamilyWindows()) {
                executable = new File(mavenHome, "/bin/mvn.cmd").exists() ? "mvn.cmd" : "mvn.bat";
            }
            if (!(mvnBin = new File(mavenHome + "/bin/" + executable)).isFile()) {
                this.sendException("Maven executable not found: " + mvnBin.getCanonicalPath());
            }
            File frameworkBaseDir = new File(this.getProjectBaseDir().getAbsolutePath() + "/..");
            CommandLine cmdLine = new CommandLine(mvnBin.getCanonicalPath());
            cmdLine.addArgument("-f");
            cmdLine.addArgument(frameworkBaseDir.getCanonicalPath() + "/pom.xml");
            cmdLine.addArgument("javadoc:aggregate@aggregated-javadoc");
            cmdLine.addArgument("-P");
            cmdLine.addArgument("aggregatedJavadoc");
            this.log("Command launched to generate the aggregated Javadoc: " + cmdLine);
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValue(0);
            ExecuteWatchdog watchdog = new ExecuteWatchdog(180000L);
            executor.setWatchdog(watchdog);
            int n = executor.execute(cmdLine);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected void copyJavadocsToWebsite() {
        try {
            File javadocSourceDir = this.getJavadocSourceGenerationDir();
            if (!javadocSourceDir.isDirectory()) {
                this.sendException("The Javadoc source directory was not found: " + javadocSourceDir.getCanonicalPath());
            }
            File javadocTargetDir = new File(this.getProjectBuildOutputDir().getCanonicalPath() + "/public/javadoc");
            FileUtils.deleteDirectory(javadocTargetDir);
            FileUtils.copyDirectory(javadocSourceDir, javadocTargetDir);
            this.log("Javadoc copied to the build output dir: " + javadocTargetDir.getAbsolutePath());
            javadocTargetDir = new File(this.getProjectBaseDir().getCanonicalPath() + "/src/main/resources/public/javadoc");
            FileUtils.deleteDirectory(javadocTargetDir);
            FileUtils.copyDirectory(javadocSourceDir, javadocTargetDir);
            this.log("Javadoc copied to the website source dir: " + javadocTargetDir.getAbsolutePath());
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    public static class SpincastMavenPluginPackageModule
    extends AbstractModule {
        @Override
        protected void configure() {
        }
    }
}

