/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.config.ISpincastDictionary;
import org.spincast.core.exchange.IRequestContext;
import org.spincast.core.filters.ISpincastFilters;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.IHandler;
import org.spincast.core.routing.IRoute;
import org.spincast.core.routing.IRouteBuilder;
import org.spincast.core.routing.IRouteBuilderFactory;
import org.spincast.core.routing.IRouteHandlerMatch;
import org.spincast.core.routing.IRouter;
import org.spincast.core.routing.IRoutingResult;
import org.spincast.core.routing.IStaticResource;
import org.spincast.core.routing.IStaticResourceBuilder;
import org.spincast.core.routing.IStaticResourceBuilderFactory;
import org.spincast.core.routing.RoutingType;
import org.spincast.core.server.IServer;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.routing.IRouteFactory;
import org.spincast.plugins.routing.IRouteHandlerMatchFactory;
import org.spincast.plugins.routing.ISpincastRouterConfig;
import org.spincast.plugins.routing.IStaticResourceFactory;
import org.spincast.plugins.routing.RoutingResult;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastRouter<R extends IRequestContext<?>>
implements IRouter<R> {
    protected final Logger logger = LoggerFactory.getLogger(SpincastRouter.class);
    private final IRouteHandlerMatchFactory<R> routeHandlerMatchFactory;
    private final IRouteBuilderFactory<R> routeBuilderFactory;
    private final IStaticResourceBuilderFactory<R> staticResourceBuilderFactory;
    private final IStaticResourceFactory<R> staticResourceFactory;
    private final ISpincastRouterConfig spincastRouterConfig;
    private final IRouteFactory<R> routeFactory;
    private final ISpincastConfig spincastConfig;
    private final ISpincastDictionary spincastDictionary;
    private final ISpincastFilters<R> spincastFilters;
    private TreeMap<Integer, List<IRoute<R>>> globalBeforeFiltersPerPosition;
    private TreeMap<Integer, List<IRoute<R>>> globalAfterFiltersPerPosition;
    private List<IRoute<R>> globalBeforeFilters;
    private List<IRoute<R>> globalAfterFilters;
    private List<IRoute<R>> mainRoutes;
    private final IServer server;
    private final Map<String, String> routeParamPatternAliases = new HashMap<String, String>();
    private final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    @Inject
    public SpincastRouter(ISpincastRouterConfig spincastRouterConfig, IRouteFactory<R> routeFactory, ISpincastConfig spincastConfig, ISpincastDictionary spincastDictionary, IServer server, ISpincastFilters<R> spincastFilters, IRouteBuilderFactory<R> routeBuilderFactory, IStaticResourceBuilderFactory<R> staticResourceBuilderFactory, IRouteHandlerMatchFactory<R> routeHandlerMatchFactory, IStaticResourceFactory<R> staticResourceFactory) {
        this.spincastRouterConfig = spincastRouterConfig;
        this.routeFactory = routeFactory;
        this.spincastConfig = spincastConfig;
        this.spincastDictionary = spincastDictionary;
        this.server = server;
        this.spincastFilters = spincastFilters;
        this.routeBuilderFactory = routeBuilderFactory;
        this.staticResourceBuilderFactory = staticResourceBuilderFactory;
        this.routeHandlerMatchFactory = routeHandlerMatchFactory;
        this.staticResourceFactory = staticResourceFactory;
    }

    @Inject
    protected void init() {
        this.validation();
    }

    protected void validation() {
        int corsFilterPosition = this.getSpincastRouterConfig().getCorsFilterPosition();
        if (corsFilterPosition >= 0) {
            throw new RuntimeException("The position of the Cors filter must be less than 0. Currently : " + corsFilterPosition);
        }
    }

    protected ISpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    protected IRouteFactory<R> getRouteFactory() {
        return this.routeFactory;
    }

    protected ISpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected ISpincastDictionary getSpincastDictionary() {
        return this.spincastDictionary;
    }

    protected IServer getServer() {
        return this.server;
    }

    protected ISpincastFilters<R> getSpincastFilters() {
        return this.spincastFilters;
    }

    protected IRouteBuilderFactory<R> getRouteBuilderFactory() {
        return this.routeBuilderFactory;
    }

    protected IStaticResourceBuilderFactory<R> getStaticResourceBuilderFactory() {
        return this.staticResourceBuilderFactory;
    }

    protected IRouteHandlerMatchFactory<R> getRouteHandlerMatchFactory() {
        return this.routeHandlerMatchFactory;
    }

    protected IStaticResourceFactory<R> getStaticResourceFactory() {
        return this.staticResourceFactory;
    }

    protected Pattern getPattern(String patternStr) {
        Pattern pattern = this.patternCache.get(patternStr);
        if (pattern == null) {
            pattern = Pattern.compile(patternStr);
            this.patternCache.put(patternStr, pattern);
        }
        return pattern;
    }

    @Override
    public Map<String, String> getRouteParamPatternAliases() {
        return this.routeParamPatternAliases;
    }

    @Override
    public IRoute<R> getRoute(String routeId) {
        for (IRoute<R> route : this.getGlobalBeforeFiltersRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        for (IRoute<R> route : this.getMainRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        for (IRoute<R> route : this.getGlobalAfterFiltersRoutes()) {
            if ((routeId != null || route.getId() != null) && (routeId == null || !routeId.equals(route.getId()))) continue;
            return route;
        }
        return null;
    }

    protected Map<Integer, List<IRoute<R>>> getGlobalBeforeFiltersPerPosition() {
        if (this.globalBeforeFiltersPerPosition == null) {
            this.globalBeforeFiltersPerPosition = new TreeMap();
        }
        return this.globalBeforeFiltersPerPosition;
    }

    @Override
    public List<IRoute<R>> getGlobalBeforeFiltersRoutes() {
        if (this.globalBeforeFilters == null) {
            this.globalBeforeFilters = new ArrayList<IRoute<R>>();
            Collection<List<IRoute<R>>> routesLists = this.getGlobalBeforeFiltersPerPosition().values();
            if (routesLists != null) {
                for (List<IRoute<R>> routeList : routesLists) {
                    this.globalBeforeFilters.addAll(routeList);
                }
            }
        }
        return this.globalBeforeFilters;
    }

    protected Map<Integer, List<IRoute<R>>> getGlobalAfterFiltersPerPosition() {
        if (this.globalAfterFiltersPerPosition == null) {
            this.globalAfterFiltersPerPosition = new TreeMap();
        }
        return this.globalAfterFiltersPerPosition;
    }

    @Override
    public List<IRoute<R>> getGlobalAfterFiltersRoutes() {
        if (this.globalAfterFilters == null) {
            this.globalAfterFilters = new ArrayList<IRoute<R>>();
            Collection<List<IRoute<R>>> routesLists = this.getGlobalAfterFiltersPerPosition().values();
            if (routesLists != null) {
                for (List<IRoute<R>> routeList : routesLists) {
                    this.globalAfterFilters.addAll(routeList);
                }
            }
        }
        return this.globalAfterFilters;
    }

    @Override
    public List<IRoute<R>> getMainRoutes() {
        if (this.mainRoutes == null) {
            this.mainRoutes = new ArrayList<IRoute<R>>();
        }
        return this.mainRoutes;
    }

    @Override
    public void addRoute(IRoute<R> route) {
        if (route == null || route.getMainHandler() == null || route.getHttpMethods() == null) {
            return;
        }
        this.validateId(route.getId());
        this.validatePath(route.getPath());
        List<Integer> positions = route.getPositions();
        for (int position : positions) {
            List<IRoute<R>> routes;
            if (position < 0) {
                this.globalBeforeFilters = null;
                routes = this.getGlobalBeforeFiltersPerPosition().get(position);
                if (routes == null) {
                    routes = new ArrayList<IRoute<R>>();
                    this.getGlobalBeforeFiltersPerPosition().put(position, routes);
                }
                routes.add(route);
                continue;
            }
            if (position == 0) {
                this.getMainRoutes().add(route);
                continue;
            }
            this.globalAfterFilters = null;
            routes = this.getGlobalAfterFiltersPerPosition().get(position);
            if (routes == null) {
                routes = new ArrayList<IRoute<R>>();
                this.getGlobalAfterFiltersPerPosition().put(position, routes);
            }
            routes.add(route);
        }
    }

    protected void validateId(String id) {
        if (id == null) {
            return;
        }
        IRoute<R> sameIdRoute = null;
        for (IRoute<R> route : this.getGlobalBeforeFiltersRoutes()) {
            if (!id.equals(route.getId())) continue;
            sameIdRoute = route;
            break;
        }
        if (sameIdRoute == null) {
            for (IRoute<R> route : this.getGlobalAfterFiltersRoutes()) {
                if (!id.equals(route.getId())) continue;
                sameIdRoute = route;
                break;
            }
        }
        if (sameIdRoute == null) {
            for (IRoute<R> route : this.getMainRoutes()) {
                if (!id.equals(route.getId())) continue;
                sameIdRoute = route;
                break;
            }
        }
        if (sameIdRoute != null) {
            throw new RuntimeException("A route already use the id '" + id + "' : " + sameIdRoute + ". Ids " + "must be uniques!");
        }
    }

    protected void validatePath(String path) {
        if (path == null) {
            return;
        }
        HashSet<String> paramNames = new HashSet<String>();
        String[] pathTokens = path.split("/");
        boolean splatFound = false;
        for (String pathToken : pathTokens) {
            if (StringUtils.isBlank(pathToken) || !pathToken.startsWith("${") && !pathToken.startsWith("*{")) continue;
            if (!pathToken.endsWith("}")) {
                throw new RuntimeException("A parameter in the path of a route must end with '}'. Incorrect parameter : " + pathToken);
            }
            if (pathToken.startsWith("*{")) {
                if (splatFound) {
                    throw new RuntimeException("The path of a route can only contain one splat parameter (the one starting with a '*{'). The path is : " + path);
                }
                if (pathToken.contains(":")) {
                    throw new RuntimeException("A splat parameter can't contain a pattern (so no ':' allowed) : " + pathToken);
                }
                splatFound = true;
            } else {
                String token = pathToken.substring(2, pathToken.length() - 1);
                int posColon = token.indexOf(":");
                if (posColon > -1 && (token = token.substring(posColon + 1)).startsWith("<")) {
                    if (!token.endsWith(">")) {
                        throw new RuntimeException("A parameter with an pattern alias must have a closing '>' : " + pathToken);
                    }
                    String pattern = this.getPatternFromAlias(token = token.substring(1, token.length() - 1));
                    if (pattern == null) {
                        throw new RuntimeException("Pattern not found using alias : " + token);
                    }
                }
            }
            String paramName = pathToken.substring(2, pathToken.length() - 1);
            if (!StringUtils.isBlank(paramName) && paramNames.contains(paramName)) {
                throw new RuntimeException("Two parameters with the same name, '" + paramName + "', in route with path : " + path);
            }
            paramNames.add(paramName);
        }
    }

    @Override
    public void removeAllRoutes() {
        this.getGlobalBeforeFiltersPerPosition().clear();
        this.globalBeforeFilters = null;
        this.getMainRoutes().clear();
        this.getGlobalAfterFiltersPerPosition().clear();
        this.globalAfterFilters = null;
    }

    @Override
    public void removeRoute(String routeId) {
        IRoute<R> route;
        int i;
        if (routeId == null) {
            return;
        }
        Collection<List<IRoute<R>>> routeLists = this.getGlobalBeforeFiltersPerPosition().values();
        for (List<IRoute<R>> routes : routeLists) {
            for (i = routes.size() - 1; i >= 0; --i) {
                route = routes.get(i);
                if (route == null || !routeId.equals(route.getId())) continue;
                routes.remove(i);
            }
        }
        this.globalBeforeFilters = null;
        routeLists = this.getGlobalAfterFiltersPerPosition().values();
        for (List<IRoute<R>> routes : routeLists) {
            for (i = routes.size() - 1; i >= 0; --i) {
                route = routes.get(i);
                if (route == null || !routeId.equals(route.getId())) continue;
                routes.remove(i);
            }
        }
        this.globalAfterFilters = null;
        List<IRoute<R>> routes = this.getMainRoutes();
        for (int i2 = routes.size() - 1; i2 >= 0; --i2) {
            IRoute<R> route2 = routes.get(i2);
            if (route2 == null || !routeId.equals(route2.getId())) continue;
            routes.remove(i2);
        }
    }

    @Override
    public IRoutingResult<R> route(R requestContext) {
        return this.route(requestContext, requestContext.request().getFullUrl(), RoutingType.NORMAL);
    }

    @Override
    public IRoutingResult<R> route(R requestContext, RoutingType routingType) {
        return this.route(requestContext, requestContext.request().getFullUrl(), routingType);
    }

    public IRoutingResult<R> route(R requestContext, String fullUrl, RoutingType routingType) {
        try {
            URL url = new URL(fullUrl);
            HttpMethod httpMethod = requestContext.request().getHttpMethod();
            List<String> acceptedContentTypes = requestContext.request().getHeader("Accept");
            if (acceptedContentTypes == null) {
                acceptedContentTypes = new ArrayList<String>();
            }
            ArrayList<IRouteHandlerMatch<R>> routeHandlerMatches = new ArrayList<IRouteHandlerMatch<R>>();
            List<IRouteHandlerMatch<R>> mainRouteHandlerMatches = null;
            for (IRoute<R> route : this.getMainRoutes()) {
                List<IRouteHandlerMatch<R>> routeHandlerMatch = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, 0);
                if (routeHandlerMatch == null || routeHandlerMatch.size() <= 0) continue;
                mainRouteHandlerMatches = routeHandlerMatch;
                break;
            }
            if (mainRouteHandlerMatches != null) {
                for (IRoute<R> route : this.getGlobalBeforeFiltersRoutes()) {
                    List<IRouteHandlerMatch<R>> beforeRouteHandlerMatches;
                    if (!this.isRoutingTypeMatch(routingType, route) || (beforeRouteHandlerMatches = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, -1)) == null) continue;
                    routeHandlerMatches.addAll(beforeRouteHandlerMatches);
                }
                routeHandlerMatches.addAll(mainRouteHandlerMatches);
                for (IRoute<R> route : this.getGlobalAfterFiltersRoutes()) {
                    List<IRouteHandlerMatch<R>> afterRouteHandlerMatches;
                    if (!this.isRoutingTypeMatch(routingType, route) || (afterRouteHandlerMatches = this.createRegularHandlerMatches(routingType, route, httpMethod, acceptedContentTypes, url, 1)) == null) continue;
                    routeHandlerMatches.addAll(afterRouteHandlerMatches);
                }
            }
            if (routeHandlerMatches.size() == 0) {
                return null;
            }
            IRoutingResult<R> routingResult = this.createRoutingResult(routeHandlerMatches);
            return routingResult;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected boolean isRoutingTypeMatch(RoutingType routingType, IRoute<R> route) {
        Objects.requireNonNull(routingType, "routingType can't be NULL");
        Objects.requireNonNull(route, "route can't be NULL");
        return route.getRoutingTypes() != null && route.getRoutingTypes().contains((Object)routingType);
    }

    protected IRoutingResult<R> createRoutingResult(List<IRouteHandlerMatch<R>> routeHandlerMatches) {
        RoutingResult<R> routingResult = new RoutingResult<R>(routeHandlerMatches);
        return routingResult;
    }

    protected List<IRouteHandlerMatch<R>> createRegularHandlerMatches(RoutingType routingType, IRoute<R> route, HttpMethod httpMethod, List<String> acceptedContentTypes, URL url, int position) {
        List<IHandler<R>> afterFilters;
        if (!this.isRoutingTypeMatch(routingType, route)) {
            return null;
        }
        if (!this.isRouteMatchHttpMethod(route, httpMethod)) {
            return null;
        }
        if (!this.isRouteMatchAcceptedContentType(route, acceptedContentTypes)) {
            return null;
        }
        String routePath = route.getPath();
        Map<String, String> matchingParams = this.validatePath(routePath, url);
        if (matchingParams == null) {
            return null;
        }
        ArrayList<IRouteHandlerMatch<R>> matches = new ArrayList<IRouteHandlerMatch<R>>();
        IRouteHandlerMatch<R> routeHandlerMatch = this.getRouteHandlerMatchFactory().create(route, route.getMainHandler(), matchingParams, position);
        matches.add(routeHandlerMatch);
        List<IHandler<R>> beforeFilters = route.getBeforeFilters();
        if (beforeFilters != null) {
            for (IHandler<R> beforeFilter : beforeFilters) {
                if (beforeFilter == null) continue;
                IRouteHandlerMatch<R> beforeMethodRouteHandlerMatch = this.createHandlerMatchForBeforeOrAfterFilter(routeHandlerMatch, beforeFilter, -1);
                matches.add(0, beforeMethodRouteHandlerMatch);
            }
        }
        if ((afterFilters = route.getAfterFilters()) != null) {
            for (IHandler<R> afterFilter : afterFilters) {
                if (afterFilter == null) continue;
                IRouteHandlerMatch<R> afterMethodRouteHandlerMatch = this.createHandlerMatchForBeforeOrAfterFilter(routeHandlerMatch, afterFilter, 1);
                matches.add(afterMethodRouteHandlerMatch);
            }
        }
        return matches;
    }

    protected boolean isRouteMatchAcceptedContentType(IRoute<R> route, List<String> requestContentTypes) {
        if (requestContentTypes == null || requestContentTypes.size() == 0) {
            return true;
        }
        Set<String> routeContentTypes = route.getAcceptedContentTypes();
        if (routeContentTypes == null || routeContentTypes.size() == 0) {
            return true;
        }
        for (String contentType : requestContentTypes) {
            if (contentType == null || !routeContentTypes.contains(contentType.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected IRouteHandlerMatch<R> createNoMatchingParamsHandlerMatch(IRoute<R> route, String id, IHandler<R> handler, int position) {
        return this.getRouteHandlerMatchFactory().create(route, handler, null, position);
    }

    protected IRouteHandlerMatch<R> createHandlerMatchForBeforeOrAfterFilter(IRouteHandlerMatch<R> mainRouteHandlerMatch, IHandler<R> beforeOrAfterMethod, int position) {
        IRouteHandlerMatch<R> routeHandlerMatch = this.getRouteHandlerMatchFactory().create(mainRouteHandlerMatch.getSourceRoute(), beforeOrAfterMethod, mainRouteHandlerMatch.getParameters(), position);
        return routeHandlerMatch;
    }

    protected boolean isRouteMatchHttpMethod(IRoute<R> route, HttpMethod httpMethod) {
        return route.getHttpMethods().contains((Object)httpMethod);
    }

    protected Map<String, String> validatePath(String routePath, URL url) {
        String[] urlPathTokens;
        String[] routePathTokens;
        String urlPath = url.getPath();
        String urlPathSlashesStriped = StringUtils.strip(urlPath, "/ ");
        String routePathSlashesStriped = StringUtils.strip(routePath, "/ ");
        boolean routesAreCaseSensitive = this.getSpincastConfig().isRoutesCaseSensitive();
        if (routesAreCaseSensitive ? urlPathSlashesStriped.equals(routePathSlashesStriped) : urlPathSlashesStriped.equalsIgnoreCase(routePathSlashesStriped)) {
            return new HashMap<String, String>();
        }
        int pos = routePathSlashesStriped.indexOf("*{");
        boolean hasSplat = true;
        if (pos < 0) {
            hasSplat = false;
            pos = routePathSlashesStriped.indexOf("${");
            if (pos < 0) {
                return null;
            }
        }
        if ((routePathTokens = routePathSlashesStriped.split("/")).length == 1 && routePathTokens[0].equals("")) {
            routePathTokens = new String[]{};
        }
        if ((urlPathTokens = urlPathSlashesStriped.split("/")).length == 1 && urlPathTokens[0].equals("")) {
            urlPathTokens = new String[]{};
        }
        if (!hasSplat && urlPathTokens.length > routePathTokens.length) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int urlTokenPos = 0;
        for (int routePathTokenPos = 0; routePathTokenPos < routePathTokens.length; ++routePathTokenPos) {
            int nbrTokensInSplat;
            String paramValue;
            String routePathToken = routePathTokens[routePathTokenPos];
            String urlPathToken = "";
            if (!routePathToken.startsWith("*{") || urlTokenPos < urlPathTokens.length) {
                if (urlTokenPos + 1 > urlPathTokens.length) {
                    return null;
                }
                urlPathToken = urlPathTokens[urlTokenPos];
            }
            ++urlTokenPos;
            if (!routePathToken.startsWith("${") && !routePathToken.startsWith("*{")) {
                if (!(routesAreCaseSensitive ? !urlPathToken.equals(routePathToken) : !urlPathToken.equalsIgnoreCase(routePathToken))) continue;
                return null;
            }
            String paramName = routePathToken.substring(2, routePathToken.length() - 1);
            try {
                paramValue = URLDecoder.decode(urlPathToken, "UTF-8");
            }
            catch (Exception ex) {
                throw SpincastStatics.runtimize(ex);
            }
            String pattern = null;
            if (routePathToken.startsWith("${")) {
                int posComma = paramName.indexOf(":");
                if (posComma > -1) {
                    pattern = paramName.substring(posComma + 1);
                    paramName = paramName.substring(0, posComma);
                    if (StringUtils.isBlank(pattern)) {
                        pattern = null;
                    } else if (pattern.startsWith("<") && pattern.endsWith(">")) {
                        pattern = this.getPatternFromAlias(pattern.substring(1, pattern.length() - 1));
                    }
                }
                if (pattern != null && !this.getPattern(pattern).matcher(urlPathToken).matches()) {
                    this.logger.debug("Url token '" + urlPathToken + "' doesn't match pattern '" + pattern + "'.");
                    return null;
                }
            } else if (routePathToken.startsWith("*{") && (nbrTokensInSplat = urlPathTokens.length - routePathTokens.length + 1) > 1) {
                StringBuilder builder = new StringBuilder(paramValue);
                for (int i = 1; i < nbrTokensInSplat; ++i) {
                    builder.append("/").append(urlPathTokens[urlTokenPos]);
                    ++urlTokenPos;
                }
                paramValue = builder.toString();
            }
            if (StringUtils.isBlank(paramName)) continue;
            params.put(paramName, paramValue);
        }
        return params;
    }

    protected String getPatternFromAlias(String alias) {
        if (alias == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.getRouteParamPatternAliases().entrySet()) {
            if (!alias.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void addRouteParamPatternAlias(String alias, String pattern) {
        if (StringUtils.isBlank(alias)) {
            throw new RuntimeException("The alias can't be empty.");
        }
        if (StringUtils.isBlank(pattern)) {
            throw new RuntimeException("The pattern can't be empty.");
        }
        this.getRouteParamPatternAliases().put(alias, pattern);
    }

    @Override
    public IRouteBuilder<R> GET(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.GET();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> POST(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.POST();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> PUT(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.PUT();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> DELETE(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.DELETE();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> OPTIONS(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.OPTIONS();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> TRACE(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.TRACE();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> HEAD(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.HEAD();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> PATCH(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.PATCH();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> ALL(String path) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.ALL();
        builder = builder.path(path);
        return builder;
    }

    @Override
    public IRouteBuilder<R> SOME(String path, HttpMethod ... httpMethods) {
        if (httpMethods.length == 0) {
            throw new RuntimeException("Using SOME(...), you have to specify at least one HTTP method.");
        }
        return this.SOME(path, Sets.newHashSet(httpMethods));
    }

    @Override
    public IRouteBuilder<R> SOME(String path, Set<HttpMethod> httpMethods) {
        if (httpMethods == null || httpMethods.size() == 0) {
            throw new RuntimeException("Using SOME(...), you have to specify at least one HTTP method.");
        }
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.SOME(httpMethods);
        builder = builder.path(path);
        return builder;
    }

    @Override
    public void before(IHandler<R> handler) {
        this.before("/*{path}", handler);
    }

    @Override
    public void before(String path, IHandler<R> handler) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.ALL();
        builder = builder.pos(-1);
        builder = builder.path(path);
        builder = this.addFilterDefaultRoutingTypes(builder);
        builder.save(handler);
    }

    @Override
    public void after(IHandler<R> handler) {
        this.after("/*{path}", handler);
    }

    @Override
    public void after(String path, IHandler<R> handler) {
        IRouteBuilder<R> builder = this.getRouteBuilderFactory().create(this);
        builder = builder.ALL();
        builder = builder.pos(1);
        builder = builder.path(path);
        builder = this.addFilterDefaultRoutingTypes(builder);
        builder.save(handler);
    }

    @Override
    public void beforeAndAfter(IHandler<R> handler) {
        this.beforeAndAfter("/*{path}", handler);
    }

    @Override
    public void beforeAndAfter(String path, IHandler<R> handler) {
        this.before(path, handler);
        this.after(path, handler);
    }

    protected IRouteBuilder<R> addFilterDefaultRoutingTypes(IRouteBuilder<R> builder) {
        Set<RoutingType> defaultRoutingTypes = this.getSpincastRouterConfig().getFilterDefaultRoutingTypes();
        for (RoutingType routingType : defaultRoutingTypes) {
            if (routingType == RoutingType.NORMAL) {
                builder.found();
                continue;
            }
            if (routingType == RoutingType.NOT_FOUND) {
                builder.notFound();
                continue;
            }
            if (routingType == RoutingType.EXCEPTION) {
                builder.exception();
                continue;
            }
            throw new RuntimeException("Not managed : " + (Object)((Object)routingType));
        }
        return builder;
    }

    @Override
    public void exception(IHandler<R> handler) {
        this.exception("/*{path}", handler);
    }

    @Override
    public void exception(String path, IHandler<R> handler) {
        this.ALL(path).exception().save(handler);
    }

    @Override
    public void notFound(IHandler<R> handler) {
        this.notFound("/*{path}", handler);
    }

    @Override
    public void notFound(String path, IHandler<R> handler) {
        this.ALL(path).notFound().save(handler);
    }

    @Override
    public void cors() {
        this.cors("/*{path}");
    }

    @Override
    public void cors(Set<String> allowedOrigins) {
        this.cors("/*{path}", allowedOrigins);
    }

    @Override
    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead);
    }

    @Override
    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent);
    }

    @Override
    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies);
    }

    @Override
    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods);
    }

    @Override
    public void cors(Set<String> allowedOrigins, Set<String> extraHeadersAllowedToBeRead, Set<String> extraHeadersAllowedToBeSent, boolean allowCookies, Set<HttpMethod> allowedMethods, int maxAgeInSeconds) {
        this.cors("/*{path}", allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
    }

    @Override
    public void cors(String path) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies, final Set<HttpMethod> allowedMethods) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods);
            }
        });
    }

    @Override
    public void cors(String path, final Set<String> allowedOrigins, final Set<String> extraHeadersAllowedToBeRead, final Set<String> extraHeadersAllowedToBeSent, final boolean allowCookies, final Set<HttpMethod> allowedMethods, final int maxAgeInSeconds) {
        this.ALL(path).pos(this.getSpincastRouterConfig().getCorsFilterPosition()).save(new IHandler<R>(){

            @Override
            public void handle(R context) {
                SpincastRouter.this.getSpincastFilters().cors(context, allowedOrigins, extraHeadersAllowedToBeRead, extraHeadersAllowedToBeSent, allowCookies, allowedMethods, maxAgeInSeconds);
            }
        });
    }

    @Override
    public IStaticResourceBuilder<R> file(String url) {
        IStaticResourceBuilder<R> builder = this.getStaticResourceBuilderFactory().create(this, false);
        builder = builder.url(url);
        return builder;
    }

    @Override
    public IStaticResourceBuilder<R> dir(String url) {
        IStaticResourceBuilder<R> builder = this.getStaticResourceBuilderFactory().create(this, true);
        builder = builder.url(url);
        return builder;
    }

    @Override
    public void addStaticResource(final IStaticResource<R> staticResource) {
        String[] tokens;
        if (staticResource.getUrlPath() == null) {
            throw new RuntimeException("The URL to the resource must be specified!");
        }
        if (staticResource.getResourcePath() == null) {
            throw new RuntimeException("A classpath or a file system path must be specified!");
        }
        if (staticResource.isClasspath() && staticResource.getGenerator() != null) {
            throw new RuntimeException("A resource generator can only be specified when a file system path is used, not a classpath path.");
        }
        String urlPath = staticResource.getUrlPath();
        boolean splatParamFound = false;
        StringBuilder urlPathForServerBuilder = new StringBuilder("");
        for (String token : tokens = staticResource.getUrlPath().split("/")) {
            if (staticResource.isFileResource()) {
                if (!token.startsWith("${") && !token.startsWith("*{")) continue;
                throw new RuntimeException("A file resource path can't contain dynamic parameters. Use 'dir()' instead or a regular route which won't be considered as a static resource.");
            }
            if (StringUtils.isBlank(token)) continue;
            if (token.startsWith("${")) {
                throw new RuntimeException("A dir static resource path can't contains any standard dynamic parameter. It can only contain a splat parameter, at the very end of the path : " + token);
            }
            if (token.startsWith("*{")) {
                splatParamFound = true;
                continue;
            }
            if (splatParamFound) {
                throw new RuntimeException("A dir resource path can contain a splat parameter, only at the very end of the path! For example, this is invalid as a path : '/one/*{param1}/two', but this is valid : '/one/two/*{param1}'.");
            }
            urlPathForServerBuilder.append("/").append(token);
        }
        String urlPathPrefixWithoutSplatParameter = staticResource.getUrlPath();
        if (splatParamFound) {
            urlPathPrefixWithoutSplatParameter = urlPathForServerBuilder.toString();
            if (staticResource.isDirResource() && StringUtils.isBlank(urlPathPrefixWithoutSplatParameter = urlPathForServerBuilder.toString())) {
                urlPathPrefixWithoutSplatParameter = "/";
            }
            IStaticResource<R> staticResourceNoDynParams = this.getStaticResourceFactory().create(staticResource.getStaticResourceType(), urlPathPrefixWithoutSplatParameter, staticResource.getResourcePath(), staticResource.getGenerator(), staticResource.getCorsConfig());
            this.getServer().addStaticResourceToServe(staticResourceNoDynParams);
        } else {
            this.getServer().addStaticResourceToServe(staticResource);
        }
        IRoute<R> route = null;
        IHandler saveResourceFilter = null;
        if (staticResource.getGenerator() != null) {
            if (staticResource.isFileResource()) {
                saveResourceFilter = new IHandler<R>(){

                    @Override
                    public void handle(R context) {
                        SpincastRouter.this.getSpincastFilters().saveGeneratedResource(context, staticResource.getResourcePath());
                    }
                };
            } else {
                if (!splatParamFound) {
                    urlPath = StringUtils.stripEnd(urlPath, "/") + "/*{path}";
                }
                final String urlPathPrefixWithoutDynamicParametersFinal = urlPathPrefixWithoutSplatParameter;
                saveResourceFilter = new IHandler<R>(){

                    @Override
                    public void handle(R context) {
                        String resourceToGeneratePath;
                        String urlPathPrefix = StringUtils.stripStart(urlPathPrefixWithoutDynamicParametersFinal, "/");
                        String requestPath = context.request().getRequestPath();
                        if (!(requestPath = StringUtils.stripStart(requestPath, "/")).startsWith(urlPathPrefix)) {
                            throw new RuntimeException("The requestPath '" + requestPath + "' should starts with the urlPathPrefix '" + urlPathPrefix + "' here!");
                        }
                        requestPath = requestPath.substring(urlPathPrefix.length());
                        try {
                            resourceToGeneratePath = new File(staticResource.getResourcePath() + "/" + requestPath).getCanonicalFile().getAbsolutePath();
                            String resourcesRoot = new File(staticResource.getResourcePath()).getCanonicalFile().getAbsolutePath();
                            if (!resourceToGeneratePath.startsWith(resourcesRoot)) {
                                throw new RuntimeException("The requestPath '" + resourceToGeneratePath + "' should be inside the root resources folder : " + resourcesRoot);
                            }
                        }
                        catch (Exception ex) {
                            throw SpincastStatics.runtimize(ex);
                        }
                        SpincastRouter.this.getSpincastFilters().saveGeneratedResource(context, resourceToGeneratePath);
                    }
                };
            }
            route = this.getRouteFactory().createRoute(null, Sets.newHashSet(HttpMethod.GET), urlPath, Sets.newHashSet(RoutingType.NORMAL), null, staticResource.getGenerator(), saveResourceFilter != null ? Arrays.asList(saveResourceFilter) : null, Sets.newHashSet(0), null);
            this.addRoute(route);
        }
    }
}

