/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.response.AlertLevel;
import org.spincast.core.session.FlashMessageFactory;
import org.spincast.core.validation.JsonObjectValidationSet;
import org.spincast.core.validation.ValidationFactory;
import org.spincast.core.validation.ValidationSet;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsDynamicFieldsController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsDynamicFieldsController.class);
    private final FlashMessageFactory flashMessageFactory;
    private final ValidationFactory validationFactory;
    private final JsonManager jsonManager;

    @Inject
    public DemoHtmlFormsDynamicFieldsController(FlashMessageFactory flashMessageFactory, ValidationFactory validationFactory, JsonManager jsonManager) {
        this.flashMessageFactory = flashMessageFactory;
        this.validationFactory = validationFactory;
        this.jsonManager = jsonManager;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    protected ValidationFactory getValidationFactory() {
        return this.validationFactory;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected void sendTemplate(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/dynamic.html");
    }

    public void dynamicFields(AppRequestContext context) {
        JsonObject form = context.json().create();
        JsonArray users = context.json().createArray();
        form.put("users", users);
        JsonObject firstUser = this.createFirstUser();
        users.add(firstUser);
        context.response().getModel().put("demoForm", form);
        this.sendTemplate(context);
    }

    protected JsonObject createFirstUser() {
        JsonObject firstUser = this.getJsonManager().create();
        firstUser.put("name", "Stromgol");
        firstUser.put("city", "Amos");
        JsonArray firstUserTags = this.getJsonManager().createArray();
        firstUserTags.add("myTag1");
        firstUserTags.add("myTag2");
        firstUserTags.add("myTag3");
        firstUser.put("tags", firstUserTags);
        return firstUser;
    }

    public void dynamicFieldsSubmit(AppRequestContext context) {
        Integer addTagToUserPos;
        JsonObject form = context.request().getFormData().getJsonObjectOrEmpty("demoForm").clone(true);
        context.response().getModel().put("demoForm", form);
        boolean actionDone = false;
        if (context.request().getFormData().isElementExists("addUserBtn")) {
            actionDone = true;
            JsonArray users = form.getJsonArrayOrEmpty("users");
            JsonObject newUser = context.json().create();
            newUser.put("name", "");
            newUser.put("city", "");
            users.add(newUser);
            JsonArray newUserTags = context.json().createArray();
            newUserTags.add("");
            newUser.put("tags", newUserTags);
        }
        if (!actionDone && (addTagToUserPos = this.getUserToAddTagTo(context)) != null) {
            actionDone = true;
            JsonObject user = form.getJsonObject("users[" + addTagToUserPos + "]");
            if (user != null) {
                JsonArray tags = user.getJsonArray("tags");
                if (tags == null) {
                    tags = context.json().createArray();
                    user.put("tags", tags);
                }
                tags.add("");
            }
        }
        if (!actionDone) {
            if (form.getJsonArrayOrEmpty("users").size() > 0) {
                ValidationSet validationResult = this.validateForm(form);
                validationResult.prefixValidationKeys("demoForm.");
                context.response().getModel().putNoKeyParsing("validation", validationResult);
            } else {
                context.response().addAlert(AlertLevel.WARNING, "No users to validate!");
            }
        }
        this.sendTemplate(context);
    }

    protected Integer getUserToAddTagTo(AppRequestContext context) {
        Integer userPositionToAddTagTo = null;
        for (Map.Entry formDatas : context.request().getFormData()) {
            String key = (String)formDatas.getKey();
            if (key == null || !key.startsWith("addTag_")) continue;
            try {
                userPositionToAddTagTo = Integer.parseInt(key.substring("addTag_".length()));
                break;
            }
            catch (Exception exception) {
            }
        }
        return userPositionToAddTagTo;
    }

    protected ValidationSet validateForm(JsonObject form) {
        JsonObjectValidationSet demoFormValidation = form.validationSet();
        form.trimAll();
        JsonArray users = form.getJsonArrayOrEmpty("users");
        for (int i = 0; i < users.size(); ++i) {
            JsonObject user = users.getJsonObject(i);
            ValidationSet userValidation = this.validateUser(user);
            demoFormValidation.mergeValidationSet("users[" + i + "].", userValidation);
        }
        return demoFormValidation;
    }

    protected ValidationSet validateUser(JsonObject user) {
        JsonObjectValidationSet userValidation = user.validationSet();
        ValidationSet lastResult = userValidation.validationNotBlank().jsonPath("name").validate();
        if (lastResult.isValid()) {
            userValidation.validationMinLength(3).jsonPath("name").validate();
        }
        if ((lastResult = userValidation.validationNotBlank().jsonPath("city").validate()).isValid()) {
            userValidation.validationMinLength(4).jsonPath("city").validate();
        }
        if ((lastResult = userValidation.validationMinSize(1, false).jsonPath("tags").validate()).isValid()) {
            boolean atLeastOneTagError = false;
            lastResult = userValidation.validationNotBlank().jsonPathAll("tags").validate();
            atLeastOneTagError = atLeastOneTagError || lastResult.isError();
            lastResult = userValidation.validationMinLength(3).jsonPathAll("tags").validate(true);
            atLeastOneTagError = atLeastOneTagError || lastResult.isError();
            lastResult = userValidation.validationMaxLength(10).jsonPathAll("tags").validate(true);
            atLeastOneTagError = atLeastOneTagError || lastResult.isError();
            HashSet<String> tagsSet = new HashSet<String>();
            JsonArray tagsArray = user.getJsonArrayOrEmpty("tags");
            for (int i = 0; i < tagsArray.size(); ++i) {
                String tag = tagsArray.getString(i, "");
                if (tag == null) continue;
                if (!StringUtils.isBlank(tag = tag.toLowerCase()) && tagsSet.contains(tag)) {
                    lastResult = userValidation.addError("tags[" + i + "]", "DUPLICATE_TAG", "This tag already exists.");
                    atLeastOneTagError = true;
                    continue;
                }
                tagsSet.add(tag);
            }
            if (atLeastOneTagError) {
                lastResult = userValidation.addError("tags", "CONTAINS_INVALID_TAGS", "At least one tag is invalid.");
            }
        }
        return userValidation;
    }
}

