/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.website.controllers.demos;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.JsonObject;
import org.spincast.core.session.FlashMessage;
import org.spincast.core.session.FlashMessageFactory;
import org.spincast.core.session.FlashMessageLevel;
import org.spincast.core.validation.JsonObjectValidationSet;
import org.spincast.shaded.org.apache.commons.codec.binary.Base64;
import org.spincast.shaded.org.apache.commons.io.FileUtils;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.website.exchange.AppRequestContext;

public class DemoHtmlFormsFileUploadController {
    protected final Logger logger = LoggerFactory.getLogger(DemoHtmlFormsFileUploadController.class);
    private final FlashMessageFactory flashMessageFactory;

    @Inject
    public DemoHtmlFormsFileUploadController(FlashMessageFactory flashMessageFactory) {
        this.flashMessageFactory = flashMessageFactory;
    }

    protected FlashMessageFactory getFlashMessageFactory() {
        return this.flashMessageFactory;
    }

    public void fileUpload(AppRequestContext context) {
        FlashMessage flashMessage = context.request().getFlashMessage();
        if (flashMessage != null) {
            String uploadFileBase64ImageSrc = flashMessage.getVariables().getString("uploadFileBase64ImageSrc");
            if (uploadFileBase64ImageSrc == null) {
                this.logger.error("The uploadFileBase64ImageSrc was expected...");
            } else {
                context.response().getModel().put("uploadFileBase64ImageSrc", uploadFileBase64ImageSrc);
            }
        }
        this.sendTemplate(context);
    }

    protected void sendTemplate(AppRequestContext context) {
        context.response().sendTemplateHtml("/templates/demos/htmlForms/fileUpload.html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileUploadSubmit(AppRequestContext context) {
        long length;
        JsonObjectValidationSet validation = context.request().getFormData().getJsonObject("demoForm").validationSet();
        File uploadedFile = context.request().getUploadedFileFirst("demoForm.fileToUpload");
        if (uploadedFile == null) {
            validation.addError("demoForm.fileToUpload", "FILE_MISSING", "Please select a file to upload.");
        }
        if ((length = uploadedFile.length()) == 0L) {
            validation.addError("demoForm.fileToUpload", "FILE_EMPTY", "The file is empty.");
        } else if (length / 1024L > 200L) {
            validation.addError("demoForm.fileToUpload", "FILE_TOO_BIG", "The file must be 200KB or less. It was " + length / 1024L + "KB.");
        }
        if (validation.isValid()) {
            try {
                ImageIO.read(uploadedFile).toString();
            }
            catch (Exception e) {
                validation.addError("demoForm.fileToUpload", "FILE_NOT_KNOWN_IMAGE_TYPE", "The file must be a valid image of type PNG, JPEG, GIF or BMP.");
            }
        }
        if (!validation.isValid()) {
            context.response().getModel().put("validation", validation);
            this.sendTemplate(context);
        } else {
            ImageInputStream iis = null;
            JsonObject variables = context.json().create();
            try {
                iis = ImageIO.createImageInputStream(uploadedFile);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
                if (iter.hasNext()) {
                    String base64Str = Base64.encodeBase64String(FileUtils.readFileToByteArray(uploadedFile));
                    String formatName = iter.next().getFormatName();
                    String uploadFileBase64ImageSrc = "data:image/" + formatName + ";charset=utf-8;base64," + base64Str;
                    variables.put("uploadFileBase64ImageSrc", uploadFileBase64ImageSrc);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error converting the image to base 64.", ex);
            }
            finally {
                IOUtils.closeQuietly((Closeable)iis);
            }
            context.response().redirect(this.getFlashMessageFactory().create(FlashMessageLevel.SUCCESS, "The file was uploaded successfully!", variables));
        }
    }
}

